/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.framework.equinox;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.libra.framework.core.FrameworkDelegate;
import org.eclipse.libra.framework.core.IOSGIFrameworkWorkingCopy;
import org.eclipse.libra.framework.equinox.EquinoxPlugin;
import org.eclipse.libra.framework.equinox.IEquinoxFramework;
import org.eclipse.libra.framework.equinox.IEquinoxVersionHandler;
import org.eclipse.libra.framework.equinox.Messages;
import org.eclipse.wst.server.core.IRuntimeType;

public class EquinoxFramework
extends FrameworkDelegate
implements IOSGIFrameworkWorkingCopy,
IEquinoxFramework {
    public IEquinoxVersionHandler getVersionHandler() {
        IRuntimeType type = this.getRuntime().getRuntimeType();
        return EquinoxPlugin.getEquinoxVersionHandler(type.getId());
    }

    public List getFrameworkClasspath(IPath configPath) {
        IPath installPath = this.getRuntime().getLocation();
        if (!installPath.isAbsolute()) {
            try {
                String installLoc = new File(installPath.toOSString()).getCanonicalPath();
                installPath = new Path(installLoc);
            }
            catch (IOException iOException) {}
        }
        return this.getVersionHandler().getFrameworkClasspath(installPath, configPath);
    }

    public IStatus verifyLocation() {
        return this.getVersionHandler().verifyInstallPath(this.getRuntime().getLocation());
    }

    public IStatus validate() {
        IStatus status = super.validate();
        if (!status.isOK()) {
            return status;
        }
        status = this.verifyLocation();
        if (!status.isOK()) {
            return status;
        }
        if (this.getRuntime().getLocation().hasTrailingSeparator()) {
            return new Status(4, "org.eclipse.libra.framework.equinox", 0, Messages.errorInstallDirTrailingSlash, null);
        }
        if (this.getVMInstall() == null) {
            return new Status(4, "org.eclipse.libra.framework.equinox", 0, Messages.errorJRE, null);
        }
        return Status.OK_STATUS;
    }
}

