/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.internal.conversion;

import java.io.InputStream;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.m2e.wtp.DomUtils;
import org.eclipse.m2e.wtp.WTPProjectsUtil;
import org.eclipse.m2e.wtp.internal.conversion.AbstractWtpProjectConversionParticipant;
import org.eclipse.m2e.wtp.internal.conversion.MavenPluginUtils;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;

public class AppClientProjectConverter
extends AbstractWtpProjectConversionParticipant {
    private static final String MAIN_CLASS = "Main-Class";

    public void convert(IProject project, Model model, IProgressMonitor monitor) throws CoreException {
        if (!this.accept(project) || !"app-client".equals(model.getPackaging())) {
            return;
        }
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component == null) {
            return;
        }
        this.setAcrPlugin(component, model);
    }

    private void setAcrPlugin(IVirtualComponent component, Model model) {
        Build build = this.getCloneOrCreateBuild(model);
        String pluginVersion = this.getAcrPluginVersion();
        Plugin acrPlugin = this.setPlugin(build, "org.apache.maven.plugins", "maven-acr-plugin", pluginVersion);
        acrPlugin.setExtensions(true);
        String mainClass = this.getMainClass(component.getProject());
        if (mainClass != null) {
            this.configureManifest(acrPlugin, mainClass);
        }
        model.setBuild(build);
    }

    private void configureManifest(Plugin acrPlugin, String mainClass) {
        Xpp3Dom archiver = this.getArchiver(acrPlugin);
        Xpp3Dom manifestEntriesDom = DomUtils.getOrCreateChildNode(archiver, "manifestEntries");
        Xpp3Dom[] xpp3DomArray = manifestEntriesDom.getChildren();
        int n = xpp3DomArray.length;
        int n2 = 0;
        while (n2 < n) {
            Xpp3Dom entry = xpp3DomArray[n2];
            if (MAIN_CLASS.equals(entry.getName()) && StringUtils.isNotEmpty((String)entry.getValue())) {
                return;
            }
            ++n2;
        }
        Xpp3Dom main = new Xpp3Dom(MAIN_CLASS);
        main.setValue(mainClass);
        manifestEntriesDom.addChild(main);
    }

    private Xpp3Dom getArchiver(Plugin plugin) {
        Xpp3Dom config = this.getOrCreateConfiguration(plugin);
        plugin.setConfiguration((Object)config);
        return DomUtils.getOrCreateChildNode(config, "archive");
    }

    private String getMainClass(IProject project) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null) {
            return null;
        }
        IFile manifest = null;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        try {
            IClasspathEntry[] classpath;
            IClasspathEntry[] iClasspathEntryArray = classpath = javaProject.getRawClasspath();
            int n = classpath.length;
            int n2 = 0;
            while (n2 < n) {
                IFile sourceManifest;
                IClasspathEntry cpe = iClasspathEntryArray[n2];
                if (3 == cpe.getEntryKind() && (sourceManifest = root.getFile(cpe.getPath().append("META-INF/MANIFEST.MF"))).exists()) {
                    manifest = sourceManifest;
                    break;
                }
                ++n2;
            }
        }
        catch (JavaModelException ex) {
            ex.printStackTrace();
        }
        if (manifest == null) {
            return null;
        }
        InputStream is = null;
        try {
            is = manifest.getContents();
            Manifest mf = new Manifest(is);
            Attributes mainAttributes = mf.getMainAttributes();
            String string = mainAttributes.getValue(MAIN_CLASS);
            return string;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            IOUtil.close((InputStream)is);
        }
        return null;
    }

    @Override
    protected IProjectFacet getRequiredFaced() {
        return WTPProjectsUtil.APP_CLIENT_FACET;
    }

    private String getAcrPluginVersion() {
        String version = System.getProperty("org.eclipse.m2e.wtp.conversion.acrplugin.version");
        if (version != null) {
            return version;
        }
        return MavenPluginUtils.getMostRecentPluginVersion("org.apache.maven.plugins", "maven-acr-plugin", "3.1.0");
    }
}

