/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections;

import java.util.Iterator;
import org.eclipse.mat.inspections.HeapObjectsTracker;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.query.quantize.Quantize;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.snapshot.query.RetainedSizeDerivedData;
import org.eclipse.mat.util.IProgressListener;

@CommandName(value="group_by_value")
@Icon(value="/META-INF/icons/group_by_value.gif")
@HelpUrl(value="/org.eclipse.mat.ui.help/reference/inspections/group_by_value.html")
public class GroupByValueQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(flag="none")
    public IHeapObjectArgument objects;
    @Argument(isMandatory=false)
    public String field;

    public IResult execute(IProgressListener listener) throws Exception {
        Quantize quantize = Quantize.valueDistribution((String[])new String[]{Messages.GroupByValueQuery_Column_StringValue}).column(Messages.GroupByValueQuery_Column_Objects, Quantize.COUNT).column(Messages.Column_ShallowHeap, Quantize.SUM_LONG, Column.SortDirection.DESC).column(Messages.GroupByValueQuery_Column_AvgRetainedSize, Quantize.AVERAGE_LONG).addDerivedData(RetainedSizeDerivedData.APPROXIMATE).build();
        HeapObjectsTracker hot = new HeapObjectsTracker(this.objects);
        listener.beginTask(Messages.GroupByValueQuery_GroupingObjects, hot.totalWork());
        boolean canceled = false;
        Iterator it = this.objects.iterator();
        while (it.hasNext()) {
            int[] objectIds = (int[])it.next();
            hot.beginBlock(objectIds, !it.hasNext());
            int ii = 0;
            while (ii < objectIds.length) {
                if (listener.isCanceled()) {
                    canceled = true;
                    break;
                }
                int objectId = objectIds[ii];
                IObject object = this.snapshot.getObject(objectId);
                Object subject = object;
                if (this.field != null) {
                    subject = object.resolveValue(this.field);
                }
                if (subject instanceof IObject) {
                    subject = subject.getClassSpecificName();
                }
                quantize.addValue(objectId, new Object[]{subject, null, object.getUsedHeapSize(), object.getRetainedHeapSize()});
                listener.worked(hot.work());
                ++ii;
            }
            if (canceled) break;
            listener.worked(hot.endBlock());
        }
        listener.done();
        return quantize.getResult();
    }
}

