/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.browser.core;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.command.DragAndDropCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.modisco.infra.browser.core.DragAndDropUtils;
import org.eclipse.modisco.infra.browser.core.LinkItemEx;
import org.eclipse.modisco.infra.browser.uicore.internal.model.ITreeElement;
import org.eclipse.modisco.infra.browser.uicore.internal.model.LinkItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DragAndDropOnLinkCommand
extends DragAndDropCommand {
    private final LinkItemEx linkItem;

    public DragAndDropOnLinkCommand(EditingDomain editingDomain, LinkItemEx linkItem, float location, int operations, int operation, Collection<?> collection) {
        super(editingDomain, (Object)linkItem, location, operations, operation, collection);
        this.linkItem = linkItem;
    }

    public LinkItem getLinkItem() {
        return this.linkItem;
    }

    public Command getDropCommand() {
        return this.dropCommand;
    }

    protected Object getParent(Object object) {
        if (object instanceof ITreeElement) {
            ITreeElement treeElement = (ITreeElement)object;
            return treeElement.getTreeParent();
        }
        return Collections.emptyList();
    }

    protected Collection<?> getChildren(Object object) {
        if (object instanceof ITreeElement) {
            ITreeElement treeElement = (ITreeElement)object;
            return treeElement.getChildren();
        }
        return Collections.emptyList();
    }

    protected boolean prepareDropInsert() {
        return false;
    }

    protected boolean prepareDropMoveOn() {
        EObject eObject;
        Resource resource;
        if (this.isCrossDomain() && (resource = (eObject = this.linkItem.getParent()).eResource()) != null && resource.getResourceSet() != null) {
            this.collection = DragAndDropUtils.translateCrossDomainObjects(this.collection, resource.getResourceSet());
        }
        if (this.isCrossDomain() || !this.checkReferenceType(this.linkItem.getReference(), this.collection)) {
            this.dragCommand = IdentityCommand.INSTANCE;
            this.dropCommand = UnexecutableCommand.INSTANCE;
        } else if (this.linkItem.getReference().isContainment()) {
            this.dropCommand = AddCommand.create((EditingDomain)this.domain, (Object)this.linkItem.getParent(), null, (Collection)this.collection);
            this.dragCommand = RemoveCommand.create((EditingDomain)this.domain, (Collection)this.collection);
        } else if (this.linkItem.getReference().isContainer()) {
            this.dropCommand = UnexecutableCommand.INSTANCE;
            this.dragCommand = IdentityCommand.INSTANCE;
        } else {
            this.dropCommand = this.linkItem.getReference().isMany() ? AddCommand.create((EditingDomain)this.domain, (Object)this.linkItem.getParent(), (Object)this.linkItem.getReference(), (Collection)this.collection) : (this.collection.size() == 1 ? SetCommand.create((EditingDomain)this.domain, (Object)this.linkItem.getParent(), (Object)this.linkItem.getReference(), this.collection.iterator().next()) : UnexecutableCommand.INSTANCE);
            this.dragCommand = IdentityCommand.INSTANCE;
        }
        boolean result = this.dragCommand.canExecute() && this.dropCommand.canExecute();
        return result;
    }

    private boolean checkReferenceType(EReference reference, Collection<?> elements) {
        EClass eReferenceType = reference.getEReferenceType();
        for (Object o : elements) {
            if (eReferenceType.isInstance(o)) continue;
            return false;
        }
        return true;
    }

    protected boolean prepareDropCopyOn() {
        if (!this.checkReferenceType(this.linkItem.getReference(), this.collection)) {
            this.dragCommand = IdentityCommand.INSTANCE;
            this.dropCommand = UnexecutableCommand.INSTANCE;
            return false;
        }
        this.dragCommand = CopyCommand.create((EditingDomain)this.domain, (Collection)this.collection);
        if (this.dragCommand.canExecute() && this.dragCommand.canUndo()) {
            this.dragCommand.execute();
            this.isDragCommandExecuted = true;
            this.dropCommand = AddCommand.create((EditingDomain)this.domain, (Object)this.linkItem.getParent(), null, (Collection)this.dragCommand.getResult());
            if (this.analyzeForNonContainment(this.dropCommand)) {
                this.dropCommand.dispose();
                this.dropCommand = UnexecutableCommand.INSTANCE;
                this.dragCommand.undo();
                this.dragCommand.dispose();
                this.isDragCommandExecuted = false;
                this.dragCommand = IdentityCommand.INSTANCE;
            }
        } else {
            this.dropCommand = UnexecutableCommand.INSTANCE;
        }
        boolean result = this.dragCommand.canExecute() && this.dropCommand.canExecute();
        return result;
    }

    protected boolean prepareDropLinkOn() {
        this.dragCommand = IdentityCommand.INSTANCE;
        this.dropCommand = UnexecutableCommand.INSTANCE;
        return false;
    }
}

