/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.services.labelprovider.service.impl.LabelProviderServiceImpl;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.editors.StringEditor;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.papyrus.infra.widgets.messages.Messages;
import org.eclipse.papyrus.infra.widgets.providers.WorkspaceContentProvider;
import org.eclipse.papyrus.infra.widgets.util.FileUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class BrowseFileEditor
extends StringEditor {
    private Button button = null;
    private List<String> filterExtensions = new ArrayList<String>();
    private List<String> filterNames = new ArrayList<String>();
    private boolean allowWorkspace = true;
    private boolean allowFileSystem = true;
    private boolean readOnly = false;
    private MenuItem fileSystemMenuItem = null;
    private MenuItem workspaceMenuItem = null;

    public BrowseFileEditor(Composite parent, int style) {
        super(parent, style);
        ++((GridLayout)this.getLayout()).numColumns;
        this.button = factory.createButton((Composite)this, Messages.StringFileSelector_Browse, 8);
        this.button.setLayoutData((Object)new GridData());
        final Menu browseMenu = this.createButtonMenu();
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                browseMenu.setVisible(true);
            }
        });
    }

    private Menu createButtonMenu() {
        Menu browseMenu = new Menu((Control)this.button);
        this.fileSystemMenuItem = new MenuItem(browseMenu, 0);
        this.fileSystemMenuItem.setText("File system");
        this.fileSystemMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                File file = BrowseFileEditor.this.getFile(BrowseFileEditor.this.text.getText());
                FileDialog dialog = new FileDialog(BrowseFileEditor.this.getShell());
                if (BrowseFileEditor.this.labelText != null) {
                    dialog.setText(BrowseFileEditor.this.labelText);
                }
                dialog.setFileName(file.getAbsolutePath());
                dialog.setFilterExtensions(BrowseFileEditor.this.filterExtensions.toArray(new String[BrowseFileEditor.this.filterExtensions.size()]));
                dialog.setFilterNames(BrowseFileEditor.this.filterNames.toArray(new String[BrowseFileEditor.this.filterNames.size()]));
                String result = dialog.open();
                if (result == null) {
                    return;
                }
                BrowseFileEditor.this.setResult(result);
            }
        });
        this.workspaceMenuItem = new MenuItem(browseMenu, 0);
        this.workspaceMenuItem.setText("Workspace");
        this.workspaceMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object file;
                Object[] result;
                int code;
                LabelProviderServiceImpl labelProviderService = new LabelProviderServiceImpl();
                try {
                    labelProviderService.startService();
                }
                catch (ServiceException ex) {
                    Activator.log.error((Throwable)ex);
                }
                ILabelProvider labelProvider = labelProviderService.getLabelProvider();
                IFile currentFile = BrowseFileEditor.this.getIFile(BrowseFileEditor.this.text.getText());
                TreeSelectorDialog dialog = new TreeSelectorDialog(BrowseFileEditor.this.getShell());
                if (BrowseFileEditor.this.labelText != null) {
                    dialog.setTitle(BrowseFileEditor.this.labelText);
                }
                WorkspaceContentProvider contentProvider = new WorkspaceContentProvider();
                if (!BrowseFileEditor.this.filterExtensions.isEmpty() && !BrowseFileEditor.this.filterNames.isEmpty()) {
                    contentProvider.setExtensionFilters(new LinkedHashMap<String, String>());
                    int i = 0;
                    while (i < Math.min(BrowseFileEditor.this.filterNames.size(), BrowseFileEditor.this.filterExtensions.size())) {
                        contentProvider.addExtensionFilter(BrowseFileEditor.this.filterExtensions.get(i), BrowseFileEditor.this.filterNames.get(i));
                        ++i;
                    }
                }
                dialog.setContentProvider(contentProvider);
                dialog.setLabelProvider(labelProvider);
                if (currentFile != null && currentFile.exists()) {
                    dialog.setInitialSelections(new IFile[]{currentFile});
                }
                if ((code = dialog.open()) == 0 && (result = dialog.getResult()).length > 0 && (file = result[0]) instanceof IFile) {
                    BrowseFileEditor.this.setResult((IFile)file);
                }
            }
        });
        return browseMenu;
    }

    protected void setResult(IFile file) {
        this.text.setText(file.getFullPath().toString());
        this.notifyChange();
    }

    protected void setResult(File file) {
        this.text.setText(file.getAbsolutePath());
        this.notifyChange();
    }

    protected void setResult(String path) {
        this.text.setText(path);
        this.notifyChange();
    }

    protected IFile getIFile(String path) {
        return FileUtil.getIFile(path);
    }

    protected File getFile(String path) {
        return FileUtil.getFile(path);
    }

    public void setFilters(String[] filterExtensions, String[] filterNames) {
        if (filterExtensions.length != filterNames.length) {
            Activator.log.warn("FilterExtensions and FilterNames do not match");
        }
        this.setFilterNames(this.getFilterLabels(filterNames, filterExtensions));
        this.setFilterExtensions(filterExtensions);
    }

    protected String[] getFilterLabels(String[] filterNames, String[] filterExtensions) {
        int size = Math.min(filterNames.length, filterExtensions.length);
        String[] filters = new String[size];
        int i = 0;
        while (i < size) {
            filters[i] = String.valueOf(filterNames[i]) + " (" + filterExtensions[i] + ")";
            ++i;
        }
        return filters;
    }

    public void setFilterExtensions(String[] filterExtensions) {
        this.filterExtensions = Arrays.asList(filterExtensions);
    }

    public void setFilterNames(String[] filterNames) {
        this.filterNames = Arrays.asList(filterNames);
    }

    public void addFilteredExtension(String filteredExtension, String filterName) {
        if (filteredExtension != null) {
            if (filterName == null) {
                filterName = filteredExtension;
            }
            this.filterExtensions.add(filteredExtension);
            this.filterNames.add(filterName);
        }
    }

    @Override
    public Object getEditableType() {
        return String.class;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        this.readOnly = readOnly;
        this.updateButtons();
    }

    public void setAllowWorkspace(boolean allowWorkspace) {
        this.allowWorkspace = allowWorkspace;
        this.updateButtons();
    }

    public void setAllowFileSystem(boolean allowFileSystem) {
        this.allowFileSystem = allowFileSystem;
        this.updateButtons();
    }

    public void setButtonLabel(String label) {
        this.button.setText(label);
    }

    public String getButtonLabel() {
        return this.button.getText();
    }

    private void updateButtons() {
        boolean enableWorkspace = !this.readOnly && this.allowWorkspace;
        boolean enableFileSystem = !this.readOnly && this.allowFileSystem;
        this.fileSystemMenuItem.setEnabled(enableWorkspace);
        this.workspaceMenuItem.setEnabled(enableFileSystem);
    }
}

