/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.decoratormodel.internal.controlmode.commands;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.uml.decoratormodel.internal.controlmode.PackageRefactoringContext;
import org.eclipse.papyrus.uml.decoratormodel.internal.controlmode.commands.DirectionConstraint;
import org.eclipse.papyrus.uml.decoratormodel.internal.controlmode.messages.Messages;
import org.eclipse.papyrus.uml.decoratormodel.internal.controlmode.updaters.IRefactoringStep;

abstract class AbstractDecoratorModelRefactoringCommand
extends AbstractCommand {
    private final List<IRefactoringStep> steps = Lists.newArrayListWithExpectedSize((int)2);
    private final DirectionConstraint direction;
    private final URI decoratorModelURI;

    protected AbstractDecoratorModelRefactoringCommand(PackageRefactoringContext context, URI decoratorModelURI) {
        this(context, decoratorModelURI, DirectionConstraint.ALL);
    }

    protected AbstractDecoratorModelRefactoringCommand(PackageRefactoringContext context, URI decoratorModelURI, DirectionConstraint direction) {
        super(NLS.bind((String)Messages.AbstractDecoratorModelRefactoringCommand_0, (Object)decoratorModelURI), AbstractDecoratorModelRefactoringCommand.getIFiles(decoratorModelURI));
        this.direction = direction;
        this.decoratorModelURI = decoratorModelURI;
    }

    public AbstractDecoratorModelRefactoringCommand addStep(IRefactoringStep step) {
        this.steps.add(step);
        return this;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)this.steps.size());
        if (!this.direction.canRefactor()) {
            sub.done();
        } else {
            ResourceSet rset = this.getResourceSet();
            try {
                Resource resource = this.getResource(rset, this.decoratorModelURI);
                if (resource != null && resource.isLoaded()) {
                    boolean changed = false;
                    ListIterator<IRefactoringStep> iter = this.steps.listIterator();
                    while (iter.hasNext()) {
                        boolean bl = changed = iter.next().refactor(resource, (IProgressMonitor)sub.newChild(1)) || changed;
                    }
                    this.resourceRefactored(resource, changed);
                }
            }
            finally {
                this.disposeResourceSet(rset);
                sub.done();
            }
        }
        return CommandResult.newOKCommandResult();
    }

    protected abstract ResourceSet getResourceSet();

    protected abstract Resource getResource(ResourceSet var1, URI var2);

    protected abstract void resourceRefactored(Resource var1, boolean var2) throws ExecutionException;

    protected abstract void disposeResourceSet(ResourceSet var1);

    protected CommandResult doUndoWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)this.steps.size());
        if (!this.direction.canUnrefactor()) {
            sub.done();
        } else {
            ResourceSet rset = this.getResourceSet();
            try {
                Resource resource = this.getResource(rset, this.decoratorModelURI);
                if (resource != null && resource.isLoaded()) {
                    boolean changed = false;
                    ListIterator<IRefactoringStep> iter = this.steps.listIterator(this.steps.size());
                    while (iter.hasPrevious()) {
                        boolean bl = changed = iter.previous().unrefactor(resource, (IProgressMonitor)sub.newChild(1)) || changed;
                    }
                    this.resourceRefactored(resource, changed);
                }
            }
            finally {
                this.disposeResourceSet(rset);
                sub.done();
            }
        }
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doRedoWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.doExecuteWithResult(monitor, info);
    }

    private static List<IFile> getIFiles(URI decoratorModel) {
        return Collections.singletonList(ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(decoratorModel.toPlatformString(true))));
    }
}

