/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.network;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.matchers.util.Direction;
import org.eclipse.viatra.query.runtime.rete.index.GenericProjectionIndexer;
import org.eclipse.viatra.query.runtime.rete.index.ProjectionIndexer;
import org.eclipse.viatra.query.runtime.rete.network.BaseNode;
import org.eclipse.viatra.query.runtime.rete.network.NetworkStructureChangeSensitiveNode;
import org.eclipse.viatra.query.runtime.rete.network.Receiver;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.Supplier;
import org.eclipse.viatra.query.runtime.rete.network.communication.Timestamp;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.Mailbox;
import org.eclipse.viatra.query.runtime.rete.traceability.TraceInfo;

public abstract class StandardNode
extends BaseNode
implements Supplier,
NetworkStructureChangeSensitiveNode {
    protected final List<Receiver> children = CollectionsFactory.createObserverList();
    protected final List<Mailbox> childMailboxes = CollectionsFactory.createObserverList();

    public StandardNode(ReteContainer reteContainer) {
        super(reteContainer);
    }

    protected void propagateUpdate(Direction direction, Tuple updateElement, Timestamp timestamp) {
        for (Mailbox childMailbox : this.childMailboxes) {
            childMailbox.postMessage(direction, updateElement, timestamp);
        }
    }

    @Override
    public void appendChild(Receiver receiver) {
        this.children.add(receiver);
        this.childMailboxes.add(this.getCommunicationTracker().proxifyMailbox(this, receiver.getMailbox()));
    }

    @Override
    public void removeChild(Receiver receiver) {
        this.children.remove(receiver);
        Mailbox mailboxToRemove = null;
        for (Mailbox mailbox : this.childMailboxes) {
            if (mailbox.getReceiver() != receiver) continue;
            mailboxToRemove = mailbox;
            break;
        }
        assert (mailboxToRemove != null);
        this.childMailboxes.remove(mailboxToRemove);
    }

    @Override
    public void networkStructureChanged() {
        this.childMailboxes.clear();
        for (Receiver receiver : this.children) {
            this.childMailboxes.add(this.getCommunicationTracker().proxifyMailbox(this, receiver.getMailbox()));
        }
    }

    @Override
    public Collection<Receiver> getReceivers() {
        return this.children;
    }

    public Collection<Mailbox> getChildMailboxes() {
        return this.childMailboxes;
    }

    @Override
    public Set<Tuple> getPulledContents(boolean flush) {
        HashSet<Tuple> results = new HashSet<Tuple>();
        this.pullInto(results, flush);
        return results;
    }

    @Override
    public ProjectionIndexer constructIndex(TupleMask mask, TraceInfo ... traces) {
        GenericProjectionIndexer indexer = new GenericProjectionIndexer(this.reteContainer, mask);
        TraceInfo[] traceInfoArray = traces;
        int n = traces.length;
        int n2 = 0;
        while (n2 < n) {
            TraceInfo traceInfo = traceInfoArray[n2];
            indexer.assignTraceInfo(traceInfo);
            ++n2;
        }
        this.reteContainer.connectAndSynchronize(this, indexer);
        return indexer;
    }

    protected void issueError(String message, Exception ex) {
        if (ex == null) {
            this.reteContainer.getNetwork().getEngine().getLogger().error((Object)message);
        } else {
            this.reteContainer.getNetwork().getEngine().getLogger().error((Object)message, (Throwable)ex);
        }
    }
}

