/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.editparts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpel.common.ui.layouts.AlignedFlowLayout;
import org.eclipse.bpel.model.BPELExtensibleElement;
import org.eclipse.bpel.model.CompensationHandler;
import org.eclipse.bpel.model.FaultHandler;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.adapters.ICompensationHandlerHolder;
import org.eclipse.bpel.ui.adapters.IFaultHandlerHolder;
import org.eclipse.bpel.ui.adapters.ILabeledElement;
import org.eclipse.bpel.ui.editparts.LeafEditPart;
import org.eclipse.bpel.ui.editparts.borders.LeafBorder;
import org.eclipse.bpel.ui.editparts.figures.GradientFigure;
import org.eclipse.bpel.ui.figures.CenteredConnectionAnchor;
import org.eclipse.bpel.ui.figures.ILayoutAware;
import org.eclipse.bpel.ui.figures.InvokeHandlerLinker;
import org.eclipse.bpel.ui.util.BPELDragEditPartsTracker;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.bpel.ui.util.marker.BPELEditPartMarkerDecorator;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;

public class InvokeEditPart
extends LeafEditPart
implements ILayoutAware {
    private boolean showFH = false;
    private boolean showCH = false;
    private IFigure parentFigure;
    private IFigure auxilaryFigure;
    private InvokeHandlerLinker handlerLinker;

    @Override
    public DragTracker getDragTracker(Request request) {
        return new BPELDragEditPartsTracker((EditPart)this){

            protected boolean handleButtonDown(int button) {
                Point point = this.getLocation();
                if (InvokeEditPart.this.border.isPointInFaultImage(point.x, point.y)) {
                    InvokeEditPart.this.setShowFaultHandler(!InvokeEditPart.this.getShowFaultHandler());
                }
                if (InvokeEditPart.this.border.isPointInCompensationImage(point.x, point.y)) {
                    InvokeEditPart.this.setShowCompensationHandler(!InvokeEditPart.this.getShowCompensationHandler());
                }
                return super.handleButtonDown(button);
            }
        };
    }

    @Override
    public void refreshVisuals() {
        super.refreshVisuals();
        this.border.setShowFault(this.getFaultHandler() != null);
        this.border.setShowCompensation(this.getCompensationHandler() != null);
        this.auxilaryFigure.getInsets().top = ModelHelper.isHorizontalLayout(this.getModel()) ? this.contentFigure.getBounds().height + 10 : 0;
        this.getFigure().repaint();
    }

    @Override
    protected IFigure createFigure() {
        if (this.image == null) {
            ILabeledElement element = BPELUtil.adapt((Object)this.getActivity(), ILabeledElement.class);
            this.image = element.getSmallImage(this.getActivity());
        }
        this.imageLabel = new Label(this.image);
        this.nameLabel = new Label(this.getLabel());
        this.editPartMarkerDecorator = new BPELEditPartMarkerDecorator((EObject)this.getModel(), new LeafEditPart.LeafDecorationLayout());
        this.editPartMarkerDecorator.addMarkerMotionListener(this.getMarkerMotionListener());
        this.parentFigure = new Figure();
        AlignedFlowLayout layout = new AlignedFlowLayout();
        layout.setHorizontal(true);
        layout.setHorizontalSpacing(0);
        layout.setVerticalSpacing(0);
        this.parentFigure.setLayoutManager((LayoutManager)layout);
        GradientFigure gradient = new GradientFigure(this.getModel());
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setMinorAlignment(0);
        gradient.setLayoutManager((LayoutManager)flowLayout);
        gradient.setForegroundColor(BPELUIPlugin.INSTANCE.getColorRegistry().get("COLOR_BLACK"));
        gradient.add((IFigure)this.imageLabel);
        gradient.add((IFigure)this.nameLabel);
        gradient.addMouseMotionListener(this.getMouseMotionListener());
        this.contentFigure = gradient;
        this.parentFigure.add(this.contentFigure);
        this.auxilaryFigure = new Figure();
        layout = new AlignedFlowLayout();
        layout.setHorizontal(!ModelHelper.isHorizontalLayout(this.getModel()));
        this.auxilaryFigure.setBorder((Border)new MarginBorder(0, 0, 0, 0));
        this.auxilaryFigure.setLayoutManager((LayoutManager)layout);
        this.parentFigure.add(this.auxilaryFigure);
        this.border = new LeafBorder((IFigure)gradient);
        this.border.setEditPart(this);
        this.border.setShowFault(this.getFaultHandler() != null);
        this.border.setShowCompensation(this.getCompensationHandler() != null);
        gradient.setBorder((Border)this.border);
        return this.editPartMarkerDecorator.createFigure(this.parentFigure);
    }

    public void setShowFaultHandler(boolean showFaultHandler) {
        this.showFH = showFaultHandler;
        this.refresh();
    }

    public void setShowCompensationHandler(boolean showCompensationHandler) {
        this.showCH = showCompensationHandler;
        this.refresh();
    }

    public boolean getShowFaultHandler() {
        return this.showFH;
    }

    public boolean getShowCompensationHandler() {
        return this.showCH;
    }

    public FaultHandler getFaultHandler() {
        IFaultHandlerHolder holder = BPELUtil.adapt((Object)this.getActivity(), IFaultHandlerHolder.class);
        if (holder != null) {
            return holder.getFaultHandler(this.getActivity());
        }
        return null;
    }

    public CompensationHandler getCompensationHandler() {
        ICompensationHandlerHolder holder = BPELUtil.adapt((Object)this.getActivity(), ICompensationHandlerHolder.class);
        if (holder != null) {
            return holder.getCompensationHandler(this.getActivity());
        }
        return null;
    }

    @Override
    public ConnectionAnchor getConnectionAnchor(int location) {
        switch (location) {
            case 4: {
                return new CenteredConnectionAnchor(this.contentFigure, location, 8);
            }
            case 2: {
                return new CenteredConnectionAnchor(this.contentFigure, 6, 0);
            }
            case 3: {
                return new CenteredConnectionAnchor(this.contentFigure, 7, 0);
            }
        }
        return new CenteredConnectionAnchor(this.contentFigure, location, 0);
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        IFigure content = this.getContentPane(childEditPart);
        if (content != null) {
            if (content == this.auxilaryFigure && content.getChildren().size() > 0) {
                content.add(child, this.getIndexForChild(childEditPart));
            } else {
                content.add(child);
            }
        }
    }

    private int getIndexForChild(EditPart editPart) {
        return editPart.getModel() instanceof CompensationHandler ? 0 : 1;
    }

    protected void removeChildVisual(EditPart childEditPart) {
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        this.getContentPane(childEditPart).remove(child);
    }

    protected void reorderChild(EditPart child, int index) {
        IFigure childFigure = ((GraphicalEditPart)child).getFigure();
        LayoutManager layout = this.getContentPane(child).getLayoutManager();
        Object constraint = null;
        if (layout != null) {
            constraint = layout.getConstraint(childFigure);
        }
        this.removeChildVisual(child);
        List children = this.getChildren();
        children.remove(child);
        children.add(index, child);
        this.addChildVisual(child, index);
        this.setLayoutConstraint(child, childFigure, constraint);
    }

    public void setLayoutConstraint(EditPart child, IFigure childFigure, Object constraint) {
        this.getContentPane(child).setConstraint(childFigure, constraint);
    }

    @Override
    public IFigure getContentPane() {
        return this.contentFigure;
    }

    protected IFigure getContentPane(EditPart childEditPart) {
        Object model = childEditPart.getModel();
        if (model instanceof FaultHandler) {
            return this.auxilaryFigure;
        }
        if (model instanceof CompensationHandler) {
            return this.auxilaryFigure;
        }
        return this.contentFigure;
    }

    @Override
    protected List<BPELExtensibleElement> getModelChildren() {
        CompensationHandler compensationHandler;
        FaultHandler faultHandler;
        ArrayList<BPELExtensibleElement> children = new ArrayList<BPELExtensibleElement>();
        if (this.showFH && (faultHandler = this.getFaultHandler()) != null) {
            children.add(children.size(), (BPELExtensibleElement)faultHandler);
        }
        if (this.showCH && (compensationHandler = this.getCompensationHandler()) != null) {
            children.add(children.size(), (BPELExtensibleElement)compensationHandler);
        }
        return children;
    }

    @Override
    public IFigure getMainActivityFigure() {
        return this.contentFigure;
    }

    public void refresh() {
        super.refresh();
        this.getHandlerLinker().refreshHandlerLinks();
    }

    private InvokeHandlerLinker getHandlerLinker() {
        if (this.handlerLinker == null) {
            this.handlerLinker = new InvokeHandlerLinker(this);
        }
        return this.handlerLinker;
    }

    @Override
    protected void clearConnections() {
        super.clearConnections();
        this.getHandlerLinker().clearHandlerConnections();
    }

    @Override
    protected void handleModelChanged() {
        super.handleModelChanged();
        this.showCH = this.getCompensationHandler() != null;
        this.showFH = this.getFaultHandler() != null;
        this.refresh();
    }

    @Override
    public void switchLayout(boolean horizontal) {
        ((AlignedFlowLayout)this.auxilaryFigure.getLayoutManager()).setHorizontal(!horizontal);
    }
}

