/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.rewrite.astwriter;

import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleTypeTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplatedTypeTemplateParameter;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.ASTWriterVisitor;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.NodeWriter;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.Scribe;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.NodeCommentMap;

public class TemplateParameterWriter
extends NodeWriter {
    private static final String GREATER_THAN = ">";
    private static final String TEMPLATE_LESS_THAN = "template <";

    public TemplateParameterWriter(Scribe scribe, ASTWriterVisitor visitor, NodeCommentMap commentMap) {
        super(scribe, visitor, commentMap);
    }

    protected void writeTemplateParameter(ICPPASTTemplateParameter parameter) {
        if (parameter instanceof ICPPASTParameterDeclaration) {
            ((ICPPASTParameterDeclaration)parameter).accept(this.visitor);
        } else if (parameter instanceof ICPPASTSimpleTypeTemplateParameter) {
            ICPPASTSimpleTypeTemplateParameter simple = (ICPPASTSimpleTypeTemplateParameter)parameter;
            this.writeTemplateParameter(simple.getParameterType() == 1, simple.isParameterPack(), simple.getName(), simple.getDefaultType());
        } else if (parameter instanceof ICPPASTTemplatedTypeTemplateParameter) {
            this.writeTemplatedTypeTemplateParameter((ICPPASTTemplatedTypeTemplateParameter)parameter);
        }
    }

    private void writeTemplatedTypeTemplateParameter(ICPPASTTemplatedTypeTemplateParameter templated) {
        this.scribe.print(TEMPLATE_LESS_THAN);
        IASTNode[] params = templated.getTemplateParameters();
        this.writeNodeList(params);
        this.scribe.print(GREATER_THAN);
        this.scribe.printSpace();
        this.writeTemplateParameter(templated.getParameterType() == 1, templated.isParameterPack(), templated.getName(), templated.getDefaultValue());
    }

    private void writeTemplateParameter(boolean usesClass, boolean isVariadic, IASTName name, IASTNode defaultArgument) {
        this.scribe.print(usesClass ? "class" : "typename");
        if (isVariadic) {
            this.scribe.print("...");
        }
        this.scribe.printSpace();
        this.visitNodeIfNotNull(name);
        if (defaultArgument != null) {
            this.scribe.print(" = ");
            defaultArgument.accept(this.visitor);
        }
    }
}

