/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.explorer.repositories;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.eclipse.emf.cdo.internal.explorer.repositories.CDORepositoryImpl;
import org.eclipse.emf.cdo.server.CDOServerUtil;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.db.CDODBUtil;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.acceptor.IAcceptor;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.IDBConnectionProvider;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.h2.jdbcx.JdbcDataSource;

public class LocalCDORepository
extends CDORepositoryImpl {
    public static final String PROP_TCP_DISABLED = "tcpDisabled";
    public static final String PROP_TCP_PORT = "tcpPort";
    private boolean tcpDisabled;
    private int tcpPort;
    private IRepository repository;
    private IAcceptor tcpAcceptor;

    @Override
    public boolean isRemote() {
        return false;
    }

    @Override
    public boolean isClone() {
        return false;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public final String getConnectorType() {
        return "jvm";
    }

    @Override
    public final String getConnectorDescription() {
        return "local";
    }

    @Override
    public String getURI() {
        if (this.tcpDisabled) {
            return String.valueOf(this.getConnectorType()) + "://" + this.getConnectorDescription() + "/" + this.getName();
        }
        return "tcp://localhost:" + this.tcpPort + "/" + this.getName();
    }

    public final boolean isTCPDisabled() {
        return this.tcpDisabled;
    }

    public final int getTCPPort() {
        return this.tcpPort;
    }

    @Override
    protected void init(File folder, String type, Properties properties) {
        super.init(folder, type, properties);
        this.tcpDisabled = Boolean.parseBoolean(properties.getProperty(PROP_TCP_DISABLED));
        if (!this.tcpDisabled) {
            this.tcpPort = Integer.parseInt(properties.getProperty(PROP_TCP_PORT));
        }
    }

    @Override
    protected void collectProperties(Properties properties) {
        super.collectProperties(properties);
        properties.setProperty(PROP_TCP_DISABLED, Boolean.toString(this.tcpDisabled));
        properties.setProperty(PROP_TCP_PORT, Integer.toString(this.tcpPort));
    }

    @Override
    public CDOSession openSession() {
        String repositoryName = this.getName();
        File folder = new File(this.getFolder(), "db");
        JdbcDataSource dataSource = new JdbcDataSource();
        dataSource.setURL("jdbc:h2:" + folder);
        IMappingStrategy mappingStrategy = CDODBUtil.createHorizontalMappingStrategy((boolean)this.getVersioningMode().isSupportingAudits(), (boolean)this.getVersioningMode().isSupportingBranches(), (boolean)false);
        mappingStrategy.setProperties(this.getMappingStrategyProperties());
        IDBAdapter dbAdapter = DBUtil.getDBAdapter((String)"h2");
        IDBConnectionProvider connectionProvider = DBUtil.createConnectionProvider((DataSource)dataSource);
        IDBStore store = CDODBUtil.createStore((IMappingStrategy)mappingStrategy, (IDBAdapter)dbAdapter, (IDBConnectionProvider)connectionProvider);
        this.repository = CDOServerUtil.createRepository((String)repositoryName, (IStore)store, this.getRepositoryProperties());
        IManagedContainer container = this.getContainer();
        CDOServerUtil.addRepository((IManagedContainer)container, (IRepository)this.repository);
        Net4jUtil.getAcceptor((IManagedContainer)container, (String)this.getConnectorType(), (String)this.getConnectorDescription());
        if (!this.tcpDisabled) {
            this.tcpAcceptor = Net4jUtil.getAcceptor((IManagedContainer)container, (String)"tcp", (String)("0.0.0.0:" + this.tcpPort));
        }
        return super.openSession();
    }

    protected Map<String, String> getRepositoryProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("overrideUUID", "");
        props.put("supportingAudits", Boolean.toString(this.getVersioningMode().isSupportingAudits()));
        props.put("supportingBranches", Boolean.toString(this.getVersioningMode().isSupportingBranches()));
        props.put("idGenerationLocation", this.getIDGeneration().getLocation().toString());
        return props;
    }

    protected Map<String, String> getMappingStrategyProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("qualifiedNames", "true");
        props.put("copyOnBranch", "true");
        return props;
    }

    @Override
    protected void closeSession() {
        super.closeSession();
        LifecycleUtil.deactivate((Object)this.tcpAcceptor);
        this.tcpAcceptor = null;
        LifecycleUtil.deactivate((Object)this.repository);
        this.repository = null;
    }
}

