/*********************************************************************
* Copyright (c) 2005, 2019 SAP SE
*
* This program and the accompanying materials are made
* available under the terms of the Eclipse Public License 2.0
* which is available at https://www.eclipse.org/legal/epl-2.0/
*
* Contributors:
*    SAP SE - initial API, implementation and documentation
*
* SPDX-License-Identifier: EPL-2.0
**********************************************************************/
package org.eclipse.graphiti.ui.internal.policy;

import org.eclipse.draw2d.IFigure;
import org.eclipse.graphiti.platform.ga.IVisualState;
import org.eclipse.graphiti.platform.ga.IVisualStateHolder;
import org.eclipse.graphiti.ui.internal.config.AbstractConfigurationProviderHolder;
import org.eclipse.graphiti.ui.internal.config.IConfigurationProviderInternal;

/**
 * @noinstantiate This class is not intended to be instantiated by clients.
 * @noextend This class is not intended to be subclassed by clients.
 */
public class GFEditPolicyDelegate extends AbstractConfigurationProviderHolder {

	public GFEditPolicyDelegate(IConfigurationProviderInternal configurationProvider) {
		super(configurationProvider);
	}

	boolean isFigureOwnSelectionHandlingActive(IFigure figure) {
		if (figure instanceof IVisualStateHolder) {
			return true;
		} else {
			return false;
		}
	}

	boolean showPrimarySelection(IFigure figure) {
		if (figure instanceof IVisualStateHolder) {
			IVisualStateHolder visualStateHolder = (IVisualStateHolder) figure;
			visualStateHolder.getVisualState().setSelectionFeedback(IVisualState.SELECTION_PRIMARY);
			return true;
		} else {
			return false;
		}
	}

	boolean showSelection(IFigure figure) {
		if (figure instanceof IVisualStateHolder) {
			IVisualStateHolder visualStateHolder = (IVisualStateHolder) figure;
			visualStateHolder.getVisualState().setSelectionFeedback(IVisualState.SELECTION_SECONDARY);
			return true;
		} else {
			return false;
		}
	}

	boolean showOnHover(IFigure figure) {
		if (figure instanceof IVisualStateHolder) {
			IVisualStateHolder visualStateHolder = (IVisualStateHolder) figure;
			visualStateHolder.getVisualState().setSelectionFeedback(IVisualState.SELECTION_SECONDARY);
			return true;
		} else {
			return false;
		}
	}

	boolean hideSelection(IFigure figure) {
		if (figure instanceof IVisualStateHolder) {
			IVisualStateHolder visualStateHolder = (IVisualStateHolder) figure;
			visualStateHolder.getVisualState().setSelectionFeedback(IVisualState.SELECTION_FEEDBACK_OFF);
			return true;
		} else {
			return false;
		}
	}
}
