/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gcov.parser;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.linuxtools.internal.gcov.parser.Arc;
import org.eclipse.linuxtools.internal.gcov.parser.Block;
import org.eclipse.linuxtools.internal.gcov.parser.CoverageInfo;
import org.eclipse.linuxtools.internal.gcov.parser.Line;
import org.eclipse.linuxtools.internal.gcov.parser.SourceFile;

public class GcnoFunction
implements Serializable,
Comparable<GcnoFunction> {
    private static final long serialVersionUID = -4159055012321132651L;
    private final long ident;
    private final long cheksum;
    private final long firstLineNmbr;
    private final String name;
    private final String srcFile;
    private ArrayList<Block> functionBlocks = new ArrayList();
    private int numCounts = 0;
    private int numBlocks = 0;
    private final CoverageInfo cvrge = new CoverageInfo();

    public GcnoFunction(long fnctnIdent, long fnctnChksm, String fnctnName, String fnctnSrcFle, long fnctnFrstLnNmbr) {
        this.ident = fnctnIdent;
        this.cheksum = fnctnChksm;
        this.name = fnctnName;
        this.srcFile = fnctnSrcFle;
        this.firstLineNmbr = fnctnFrstLnNmbr;
    }

    @Override
    public int compareTo(GcnoFunction o) {
        if (this.getFirstLineNmbr() > o.getFirstLineNmbr()) {
            return 1;
        }
        if (this.getFirstLineNmbr() < o.getFirstLineNmbr()) {
            return -1;
        }
        return 0;
    }

    public void addLineCounts(ArrayList<SourceFile> srcs) {
        HashSet<Line> linesToCalculate = new HashSet<Line>();
        int i = 0;
        while (i != this.numBlocks) {
            Block blk = this.functionBlocks.get(i);
            SourceFile fileSrc = null;
            long[] enc = blk.getEncoding();
            int j = 0;
            int k = 0;
            while (j != blk.getLineNum()) {
                if (enc[k] == 0L) {
                    int srcn = (int)enc[++k];
                    for (SourceFile sf : srcs) {
                        if (sf.getIndex() != srcn) continue;
                        fileSrc = sf;
                        break;
                    }
                    ++j;
                } else if (fileSrc != null && enc[k] < (long)fileSrc.getLines().size()) {
                    Line line = fileSrc.getLines().get((int)enc[k]);
                    if (!line.exists()) {
                        this.cvrge.incLinesInstrumented();
                    }
                    if (line.getCount() == 0L && blk.getCount() != 0L) {
                        this.cvrge.incLinesExecuted();
                    }
                    line.setExists(true);
                    if (line.getBlocks().size() > 1) {
                        linesToCalculate.add(line);
                        line.setCount(1L);
                    } else {
                        line.setCount(line.getCount() + blk.getCount());
                    }
                }
                ++j;
                ++k;
            }
            ++i;
        }
        for (Line line : linesToCalculate) {
            long count = 0L;
            for (Block b : line.getBlocks()) {
                for (Arc arc : b.getEntryArcs()) {
                    if (line.hasBlock(arc.getSrcBlock())) continue;
                    count += arc.getCount();
                }
            }
            line.setCount(count);
        }
    }

    public void solveGraphFnctn() {
        ArrayList<Block> fnctnBlcks = this.functionBlocks;
        ArrayList<Block> validBlocks = new ArrayList<Block>();
        ArrayList<Block> invalidBlocks = new ArrayList<Block>();
        if (fnctnBlcks.size() >= 2) {
            if (fnctnBlcks.get(0).getNumPreds() == 0L) {
                fnctnBlcks.get(0).setNumPreds(50000L);
            }
            if (fnctnBlcks.get(fnctnBlcks.size() - 1).getNumSuccs() == 0L) {
                fnctnBlcks.get(fnctnBlcks.size() - 1).setNumSuccs(50000L);
            }
        }
        for (Block b : fnctnBlcks) {
            b.setInvalidChain(true);
            invalidBlocks.add(b);
        }
        while (!validBlocks.isEmpty() || !invalidBlocks.isEmpty()) {
            if (!invalidBlocks.isEmpty()) {
                int i = invalidBlocks.size() - 1;
                while (i >= 0) {
                    Block invb = (Block)invalidBlocks.get(i);
                    long total = 0L;
                    invalidBlocks.remove(i);
                    invb.setInvalidChain(false);
                    if (invb.getNumPreds() == 0L || invb.getNumSuccs() == 0L) {
                        if (invb.getNumSuccs() == 0L) {
                            ArrayList<Arc> extArcs = invb.getExitArcs();
                            for (Arc arc : extArcs) {
                                total += arc.getCount();
                            }
                        }
                        if (invb.getNumPreds() == 0L && total == 0L) {
                            ArrayList<Arc> entrArcs = invb.getEntryArcs();
                            for (Arc arc : entrArcs) {
                                total += arc.getCount();
                            }
                        }
                        invb.setCount(total);
                        invb.setCountValid(true);
                        invb.setValidChain(true);
                        validBlocks.add(invb);
                    }
                    --i;
                }
            }
            while (!validBlocks.isEmpty()) {
                int last = validBlocks.size() - 1;
                Block vb = (Block)validBlocks.get(last);
                Arc invarc = null;
                int total = 0;
                validBlocks.remove(last);
                vb.setValidChain(false);
                if (vb.getNumSuccs() == 1L) {
                    total = (int)vb.getCount();
                    for (Arc extAr : vb.getExitArcs()) {
                        total = (int)((long)total - extAr.getCount());
                        if (extAr.isCountValid()) continue;
                        invarc = extAr;
                    }
                    Block blcksdst = invarc.getDstnatnBlock();
                    invarc.setCountValid(true);
                    invarc.setCount(total);
                    vb.decNumSuccs();
                    blcksdst.decNumPreds();
                    if (blcksdst.isCountValid()) {
                        if (blcksdst.getNumPreds() == 1L && !blcksdst.isValidChain()) {
                            blcksdst.setValidChain(true);
                            validBlocks.add(blcksdst);
                        }
                    } else if (blcksdst.getNumPreds() == 0L && !blcksdst.isInvalidChain()) {
                        blcksdst.setInvalidChain(true);
                        invalidBlocks.add(blcksdst);
                    }
                }
                if (vb.getNumPreds() != 1L) continue;
                total = (int)vb.getCount();
                invarc = null;
                for (Arc entrAr : vb.getEntryArcs()) {
                    total = (int)((long)total - entrAr.getCount());
                    if (entrAr.isCountValid()) continue;
                    invarc = entrAr;
                }
                Block blcksrc = invarc.getSrcBlock();
                invarc.setCountValid(true);
                invarc.setCount(total);
                vb.decNumPreds();
                blcksrc.decNumSuccs();
                if (blcksrc.isCountValid()) {
                    if (blcksrc.getNumSuccs() != 1L || blcksrc.isInvalidChain()) continue;
                    blcksrc.setValidChain(true);
                    validBlocks.add(blcksrc);
                    continue;
                }
                if (blcksrc.getNumSuccs() != 0L || blcksrc.isInvalidChain()) continue;
                blcksrc.setInvalidChain(true);
                invalidBlocks.add(blcksrc);
            }
        }
    }

    public long getIdent() {
        return this.ident;
    }

    public long getCheksum() {
        return this.cheksum;
    }

    public String getName() {
        return this.name;
    }

    public String getSrcFile() {
        return this.srcFile;
    }

    public long getFirstLineNmbr() {
        return this.firstLineNmbr;
    }

    public ArrayList<Block> getFunctionBlocks() {
        return this.functionBlocks;
    }

    public Block getFunctionBlock(int i) {
        return this.functionBlocks.get(i);
    }

    public void setFunctionBlocks(ArrayList<Block> functionBlocks) {
        this.functionBlocks = functionBlocks;
    }

    public void incNumCounts() {
        ++this.numCounts;
    }

    public int getNumCounts() {
        return this.numCounts;
    }

    public int getNumBlocks() {
        return this.numBlocks;
    }

    public void setNumBlocks(int numBlocks) {
        this.numBlocks = numBlocks;
    }

    public CoverageInfo getCvrge() {
        return this.cvrge;
    }
}

