/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.pom;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputSource;
import org.apache.maven.model.Model;
import org.apache.maven.project.MavenProject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.m2e.core.ui.internal.util.XmlUtils;
import org.eclipse.m2e.editor.internal.MarkerHoverControl;
import org.eclipse.m2e.editor.internal.Messages;
import org.eclipse.m2e.editor.pom.PomHyperlinkDetector;
import org.eclipse.m2e.editor.pom.PomTemplateContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class PomTextHover
implements ITextHover,
ITextHoverExtension,
ITextHoverExtension2 {
    public PomTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        if (hoverRegion instanceof PomHyperlinkDetector.ExpressionRegion) {
            return PomTextHover.getLabelForRegion((PomHyperlinkDetector.ExpressionRegion)hoverRegion).toString();
        }
        if (hoverRegion instanceof PomHyperlinkDetector.ManagedArtifactRegion) {
            PomHyperlinkDetector.ManagedArtifactRegion region = (PomHyperlinkDetector.ManagedArtifactRegion)hoverRegion;
            return PomTextHover.getLabelForRegion(region).toString();
        }
        return null;
    }

    public static StyledString getLabelForRegion(PomHyperlinkDetector.ManagedArtifactRegion region) {
        MavenProject mavprj = region.project;
        if (mavprj != null) {
            String version = null;
            if (region.isDependency) {
                version = PomTemplateContext.searchDM(mavprj, region.groupId, region.artifactId);
            }
            if (region.isPlugin) {
                version = PomTemplateContext.searchPM(mavprj, region.groupId, region.artifactId);
            }
            StyledString ret = new StyledString();
            if (version != null) {
                ret.append(Messages.PomTextHover_managed_version);
                ret.append(version, StyledString.DECORATIONS_STYLER);
            } else {
                ret.append(Messages.PomTextHover_managed_version_missing);
            }
            InputLocation openLocation = PomHyperlinkDetector.findLocationForManagedArtifact(region, mavprj);
            if (openLocation != null) {
                InputSource source = openLocation.getSource();
                if (source != null) {
                    ret.append(" ");
                    ret.append(NLS.bind((String)Messages.PomTextHover_managed_location, (Object)source.getModelId()));
                }
            } else {
                ret.append(" ");
                ret.append(Messages.PomTextHover_managed_location_missing);
            }
            return ret;
        }
        return new StyledString("");
    }

    public static StyledString getLabelForRegion(PomHyperlinkDetector.ExpressionRegion region) {
        MavenProject mavprj = region.project;
        if (mavprj != null) {
            InputSource source;
            InputLocation location;
            String value = PomTemplateContext.simpleInterpolate(region.project, "${" + region.property + "}");
            String loc = null;
            Model mdl = mavprj.getModel();
            if (mdl.getProperties() != null && mdl.getProperties().containsKey(region.property) && mdl.getLocation((Object)"properties") != null && (location = mdl.getLocation((Object)"properties").getLocation((Object)region.property)) != null && (source = location.getSource()) != null) {
                loc = source.getModelId();
            }
            StyledString ret = new StyledString();
            ret.append(Messages.PomTextHover_eval1);
            ret.append(value, StyledString.DECORATIONS_STYLER);
            if (loc != null) {
                ret.append(" ");
                ret.append(NLS.bind((String)Messages.PomTextHover_eval2, loc));
            }
            return ret;
        }
        return new StyledString("");
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        ISourceViewer sourceViewer;
        IAnnotationModel model;
        IDocument document = textViewer.getDocument();
        if (document == null) {
            return null;
        }
        IRegion[] regs = new IRegion[2];
        XmlUtils.performOnCurrentElement((IDocument)document, (int)offset, (node, structured) -> {
            PomHyperlinkDetector.ExpressionRegion region = PomHyperlinkDetector.findExpressionRegion(node, textViewer, offset);
            if (region != null) {
                iRegionArray[0] = region;
                return;
            }
            PomHyperlinkDetector.ManagedArtifactRegion manReg = PomHyperlinkDetector.findManagedArtifactRegion(node, textViewer, offset);
            if (manReg != null) {
                iRegionArray[1] = manReg;
                return;
            }
        });
        CompoundRegion toRet = new CompoundRegion(textViewer, offset);
        if (regs[0] != null) {
            toRet.addRegion(regs[0]);
        }
        if (regs[1] != null) {
            toRet.addRegion(regs[1]);
        }
        if (textViewer instanceof ISourceViewer && (model = (sourceViewer = (ISourceViewer)textViewer).getAnnotationModel()) != null) {
            Iterator it = model.getAnnotationIterator();
            while (it.hasNext()) {
                Position pos;
                Annotation ann = (Annotation)it.next();
                if (!(ann instanceof MarkerAnnotation) || !(pos = sourceViewer.getAnnotationModel().getPosition(ann)).includes(offset)) continue;
                toRet.addRegion(new PomHyperlinkDetector.MarkerRegion(pos.getOffset(), pos.getLength(), (MarkerAnnotation)ann));
            }
        }
        return toRet.getRegions().size() > 0 ? toRet : null;
    }

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        return hoverRegion;
    }

    public IInformationControlCreator getHoverControlCreator() {
        return parent -> new MarkerHoverControl(parent);
    }

    public static class CompoundRegion
    implements IRegion {
        private int length = Integer.MIN_VALUE;
        private int offset = Integer.MAX_VALUE;
        private final List<IRegion> regions = new ArrayList<IRegion>();
        public final ITextViewer textViewer;
        public final int textOffset;

        public CompoundRegion(ITextViewer textViewer, int textOffset) {
            this.textViewer = textViewer;
            this.textOffset = textOffset;
        }

        public int getLength() {
            return this.length;
        }

        public int getOffset() {
            return this.offset;
        }

        public void addRegion(IRegion region) {
            this.regions.add(region);
            int start = Math.min(region.getOffset(), this.offset);
            int end = Math.max(region.getOffset() + region.getLength(), this.offset + this.length);
            this.offset = start;
            this.length = end - start;
        }

        public List<IRegion> getRegions() {
            return this.regions;
        }
    }
}

