/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;
import org.eclipse.aether.version.Version;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ICallable;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.IMavenExecutionContext;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.pde.BNDInstructions;
import org.eclipse.m2e.pde.CacheManager;
import org.eclipse.m2e.pde.MavenSourceBundle;
import org.eclipse.m2e.pde.MavenTargetBundle;
import org.eclipse.m2e.pde.MissingMetadataMode;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.core.target.TargetFeature;
import org.eclipse.pde.internal.core.target.AbstractBundleContainer;

public class MavenTargetLocation
extends AbstractBundleContainer {
    public static final String ELEMENT_CLASSIFIER = "classifier";
    public static final String ELEMENT_TYPE = "type";
    public static final String ELEMENT_VERSION = "version";
    public static final String ELEMENT_ARTIFACT_ID = "artifactId";
    public static final String ELEMENT_GROUP_ID = "groupId";
    public static final String ELEMENT_INSTRUCTIONS = "instructions";
    public static final String ELEMENT_EXCLUDED = "exclude";
    public static final String ATTRIBUTE_INSTRUCTIONS_REFERENCE = "reference";
    public static final String ATTRIBUTE_DEPENDENCY_SCOPE = "includeDependencyScope";
    public static final String ATTRIBUTE_INCLUDE_SOURCE = "includeSource";
    public static final String ATTRIBUTE_MISSING_META_DATA = "missingManifest";
    public static final String DEFAULT_DEPENDENCY_SCOPE = "";
    public static final MissingMetadataMode DEFAULT_METADATA_MODE = MissingMetadataMode.GENERATE;
    public static final String DEFAULT_PACKAGE_TYPE = "jar";
    public static final String DEPENDENCYNODE_IS_ROOT = "dependencynode.root";
    public static final String DEPENDENCYNODE_PARENT = "dependencynode.parent";
    private final String artifactId;
    private final String groupId;
    private final String version;
    private final String artifactType;
    private final String classifier;
    private final String dependencyScope;
    private final MissingMetadataMode metadataMode;
    private Map<org.eclipse.aether.artifact.Artifact, TargetBundle> targetBundles;
    private List<DependencyNode> dependencyNodes;
    private final Set<org.eclipse.aether.artifact.Artifact> ignoredArtifacts = new HashSet<org.eclipse.aether.artifact.Artifact>();
    private final Set<String> excludedArtifacts = new HashSet<String>();
    private final Set<org.eclipse.aether.artifact.Artifact> failedArtifacts = new HashSet<org.eclipse.aether.artifact.Artifact>();
    private final Map<String, BNDInstructions> instructionsMap = new LinkedHashMap<String, BNDInstructions>();
    private final boolean includeSource;

    public MavenTargetLocation(String groupId, String artifactId, String version, String artifactType, String classifier, MissingMetadataMode metadataMode, String dependencyScope, boolean includeSource, Collection<BNDInstructions> instructions, Collection<String> excludes) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.artifactType = artifactType;
        this.classifier = classifier;
        this.metadataMode = metadataMode;
        this.dependencyScope = dependencyScope;
        this.includeSource = includeSource;
        for (BNDInstructions instr : instructions) {
            this.instructionsMap.put(instr.getKey(), instr);
        }
        this.excludedArtifacts.addAll(excludes);
    }

    protected TargetBundle[] resolveBundles(ITargetDefinition definition, IProgressMonitor monitor) throws CoreException {
        if (this.targetBundles == null) {
            CacheManager cacheManager = CacheManager.forTargetHandle(definition.getHandle());
            this.ignoredArtifacts.clear();
            this.targetBundles = new HashMap<org.eclipse.aether.artifact.Artifact, TargetBundle>();
            IMaven maven = MavenPlugin.getMaven();
            final List repositories = maven.getArtifactRepositories();
            final org.eclipse.aether.artifact.Artifact artifact = RepositoryUtils.toArtifact((Artifact)maven.resolve(this.getGroupId(), this.getArtifactId(), this.getVersion(), this.getArtifactType(), this.getClassifier(), repositories, monitor));
            if (artifact != null) {
                if (this.dependencyScope != null && !this.dependencyScope.isBlank()) {
                    IMavenExecutionContext context = maven.createExecutionContext();
                    PreorderNodeListGenerator dependecies = (PreorderNodeListGenerator)context.execute((ICallable)new ICallable<PreorderNodeListGenerator>(){

                        public PreorderNodeListGenerator call(IMavenExecutionContext context, IProgressMonitor monitor) throws CoreException {
                            try {
                                CollectRequest collectRequest = new CollectRequest();
                                collectRequest.setRoot(new Dependency(artifact, MavenTargetLocation.this.dependencyScope));
                                collectRequest.setRepositories(RepositoryUtils.toRepos((List)repositories));
                                RepositorySystem repoSystem = MavenPluginActivator.getDefault().getRepositorySystem();
                                DependencyNode node = repoSystem.collectDependencies(context.getRepositorySession(), collectRequest).getRoot();
                                node.setData((Object)MavenTargetLocation.DEPENDENCYNODE_IS_ROOT, (Object)true);
                                node.setData((Object)MavenTargetLocation.DEPENDENCYNODE_PARENT, (Object)MavenTargetLocation.this);
                                DependencyRequest dependencyRequest = new DependencyRequest();
                                dependencyRequest.setRoot(node);
                                repoSystem.resolveDependencies(context.getRepositorySession(), dependencyRequest);
                                PreorderNodeListGenerator nlg = new PreorderNodeListGenerator();
                                node.accept((DependencyVisitor)nlg);
                                return nlg;
                            }
                            catch (RepositoryException e) {
                                throw new CoreException((IStatus)new Status(4, MavenTargetLocation.class.getPackage().getName(), "Resolving dependencies failed", (Throwable)e));
                            }
                            catch (RuntimeException e) {
                                throw new CoreException((IStatus)new Status(4, MavenTargetLocation.class.getPackage().getName(), "Internal error", (Throwable)e));
                            }
                        }
                    }, monitor);
                    for (org.eclipse.aether.artifact.Artifact a : dependecies.getArtifacts(true)) {
                        this.addBundleForArtifact(a, cacheManager, maven);
                    }
                    this.dependencyNodes = dependecies.getNodes();
                } else {
                    this.addBundleForArtifact(artifact, cacheManager, maven);
                }
            }
        }
        TargetBundle[] bundles = (TargetBundle[])this.targetBundles.entrySet().stream().filter(e -> !this.isExcluded((org.eclipse.aether.artifact.Artifact)e.getKey())).map(Map.Entry::getValue).toArray(TargetBundle[]::new);
        return bundles;
    }

    private void addBundleForArtifact(org.eclipse.aether.artifact.Artifact artifact, CacheManager cacheManager, IMaven maven) {
        MavenTargetBundle bundle;
        IStatus status;
        BNDInstructions bndInstructions = this.instructionsMap.get(MavenTargetLocation.getKey(artifact));
        if (bndInstructions == null) {
            bndInstructions = this.instructionsMap.get(DEFAULT_DEPENDENCY_SCOPE);
        }
        if ((status = (bundle = cacheManager.getTargetBundle(artifact, bndInstructions, this.metadataMode)).getStatus()).isOK()) {
            this.targetBundles.put(artifact, bundle);
            if (this.includeSource) {
                try {
                    org.eclipse.aether.artifact.Artifact resolve = RepositoryUtils.toArtifact((Artifact)maven.resolve(artifact.getGroupId(), artifact.getArtifactId(), artifact.getBaseVersion(), artifact.getExtension(), "sources", maven.getArtifactRepositories(), (IProgressMonitor)new NullProgressMonitor()));
                    this.targetBundles.put(resolve, new MavenSourceBundle(bundle.getBundleInfo(), resolve, cacheManager));
                }
                catch (Exception exception) {}
            }
        } else if (status.matches(8)) {
            this.ignoredArtifacts.add(artifact);
        } else {
            this.failedArtifacts.add(artifact);
            this.targetBundles.put(artifact, bundle);
        }
    }

    public MavenTargetLocation update(IProgressMonitor monitor) throws CoreException {
        List artifactRepositories;
        List remoteRepositories;
        VersionRangeRequest request;
        DefaultArtifact artifact = new DefaultArtifact(String.valueOf(this.getGroupId()) + ":" + this.getArtifactId() + ":(0,]");
        IMaven maven = MavenPlugin.getMaven();
        final RepositorySystem repoSystem = MavenPluginActivator.getDefault().getRepositorySystem();
        IMavenExecutionContext context = maven.createExecutionContext();
        VersionRangeResult result = (VersionRangeResult)context.execute((ICallable)new ICallable<VersionRangeResult>(request = new VersionRangeRequest((org.eclipse.aether.artifact.Artifact)artifact, remoteRepositories = RepositoryUtils.toRepos((List)(artifactRepositories = maven.getArtifactRepositories())), null)){
            private final /* synthetic */ VersionRangeRequest val$request;
            {
                this.val$request = versionRangeRequest;
            }

            public VersionRangeResult call(IMavenExecutionContext context, IProgressMonitor monitor) throws CoreException {
                RepositorySystemSession session = context.getRepositorySession();
                try {
                    return repoSystem.resolveVersionRange(session, this.val$request);
                }
                catch (VersionRangeResolutionException e) {
                    throw new CoreException((IStatus)new Status(4, MavenTargetLocation.class.getPackage().getName(), "Resolving latest version failed", (Throwable)e));
                }
            }
        }, monitor);
        Version highestVersion = result.getHighestVersion();
        if (highestVersion == null || highestVersion.toString().equals(this.version)) {
            return null;
        }
        return new MavenTargetLocation(this.groupId, this.artifactId, highestVersion.toString(), this.artifactType, this.classifier, this.metadataMode, this.dependencyScope, this.includeSource, this.instructionsMap.values(), this.excludedArtifacts);
    }

    public MavenTargetLocation withInstructions(Collection<BNDInstructions> instructions) {
        return new MavenTargetLocation(this.groupId, this.artifactId, this.version, this.artifactType, this.classifier, this.metadataMode, this.dependencyScope, this.includeSource, instructions, this.excludedArtifacts);
    }

    public BNDInstructions getInstructions(org.eclipse.aether.artifact.Artifact artifact) {
        String key = MavenTargetLocation.getKey(artifact);
        BNDInstructions bnd = this.instructionsMap.get(key);
        if (bnd == null) {
            return new BNDInstructions(key, null);
        }
        return bnd;
    }

    private static String getKey(org.eclipse.aether.artifact.Artifact artifact) {
        if (artifact == null) {
            return DEFAULT_DEPENDENCY_SCOPE;
        }
        String key = String.valueOf(artifact.getGroupId()) + ":" + artifact.getArtifactId();
        String classifier = artifact.getClassifier();
        if (classifier != null) {
            key = String.valueOf(key) + ":" + classifier;
        }
        key = String.valueOf(key) + ":" + artifact.getBaseVersion();
        return key;
    }

    public int getDependencyCount() {
        if (this.targetBundles == null) {
            return -1;
        }
        return this.targetBundles.size() - 1;
    }

    public List<DependencyNode> getDependencyNodes() {
        return this.dependencyNodes;
    }

    protected TargetFeature[] resolveFeatures(ITargetDefinition definition, IProgressMonitor monitor) throws CoreException {
        return new TargetFeature[0];
    }

    public String getType() {
        return "Maven";
    }

    public String getLocation(boolean resolve) throws CoreException {
        return System.getProperty("java.io.tmpdir");
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.artifactId, this.artifactType, this.dependencyNodes, this.dependencyScope, this.failedArtifacts, this.groupId, this.ignoredArtifacts, this.metadataMode, this.targetBundles, this.version});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        MavenTargetLocation other = (MavenTargetLocation)((Object)obj);
        return Objects.equals(this.artifactId, other.artifactId) && Objects.equals(this.artifactType, other.artifactType) && Objects.equals(this.dependencyNodes, other.dependencyNodes) && Objects.equals(this.dependencyScope, other.dependencyScope) && Objects.equals(this.failedArtifacts, other.failedArtifacts) && Objects.equals(this.groupId, other.groupId) && Objects.equals(this.ignoredArtifacts, other.ignoredArtifacts) && this.metadataMode == other.metadataMode && Objects.equals(this.targetBundles, other.targetBundles) && Objects.equals(this.version, other.version);
    }

    public boolean isIncludeSource() {
        return this.includeSource;
    }

    public String serialize() {
        StringBuilder xml = new StringBuilder();
        xml.append("<location");
        MavenTargetLocation.attribute(xml, ELEMENT_TYPE, this.getType());
        MavenTargetLocation.attribute(xml, ATTRIBUTE_MISSING_META_DATA, this.metadataMode.name().toLowerCase());
        MavenTargetLocation.attribute(xml, ATTRIBUTE_DEPENDENCY_SCOPE, this.dependencyScope);
        MavenTargetLocation.attribute(xml, ATTRIBUTE_INCLUDE_SOURCE, this.includeSource ? "true" : DEFAULT_DEPENDENCY_SCOPE);
        xml.append(">");
        MavenTargetLocation.element(xml, ELEMENT_GROUP_ID, this.groupId);
        MavenTargetLocation.element(xml, ELEMENT_ARTIFACT_ID, this.artifactId);
        MavenTargetLocation.element(xml, ELEMENT_VERSION, this.version);
        MavenTargetLocation.element(xml, ELEMENT_TYPE, this.artifactType);
        MavenTargetLocation.element(xml, ELEMENT_CLASSIFIER, this.classifier);
        this.instructionsMap.values().stream().filter(Predicate.not(BNDInstructions::isEmpty)).sorted(Comparator.comparing(BNDInstructions::getKey)).forEach(bnd -> {
            String instructions = bnd.getInstructions();
            xml.append("<instructions");
            MavenTargetLocation.attribute(xml, ATTRIBUTE_INSTRUCTIONS_REFERENCE, bnd.getKey());
            xml.append("><![CDATA[\r\n");
            xml.append(instructions);
            xml.append("\r\n]]></instructions>");
        });
        this.excludedArtifacts.stream().sorted().forEach(ignored -> MavenTargetLocation.element(xml, ELEMENT_EXCLUDED, ignored));
        xml.append("</location>");
        return xml.toString();
    }

    private static void element(StringBuilder xml, String name, String value) {
        if (value != null && !value.isBlank()) {
            xml.append('<');
            xml.append(name);
            xml.append('>');
            xml.append(value);
            xml.append("</");
            xml.append(name);
            xml.append('>');
        }
    }

    private static void attribute(StringBuilder xml, String name, String value) {
        if (value != null && !value.isBlank()) {
            xml.append(' ');
            xml.append(name);
            xml.append('=');
            xml.append('\"');
            xml.append(value);
            xml.append('\"');
        }
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public MissingMetadataMode getMetadataMode() {
        if (this.metadataMode == null) {
            return DEFAULT_METADATA_MODE;
        }
        return this.metadataMode;
    }

    public void refresh() {
        this.dependencyNodes = null;
        this.targetBundles = null;
        this.clearResolutionStatus();
    }

    public String getArtifactType() {
        if (this.artifactType != null && !this.artifactType.trim().isEmpty()) {
            return this.artifactType;
        }
        return DEFAULT_PACKAGE_TYPE;
    }

    public String getDependencyScope() {
        if (this.dependencyScope != null && !this.dependencyScope.trim().isEmpty()) {
            return this.dependencyScope;
        }
        return DEFAULT_DEPENDENCY_SCOPE;
    }

    public boolean isIgnored(org.eclipse.aether.artifact.Artifact artifact) {
        return this.ignoredArtifacts.contains(artifact);
    }

    public boolean isFailed(org.eclipse.aether.artifact.Artifact artifact) {
        return this.failedArtifacts.contains(artifact);
    }

    public boolean isExcluded(org.eclipse.aether.artifact.Artifact artifact) {
        return this.excludedArtifacts.contains(MavenTargetLocation.getKey(artifact));
    }

    public void setExcluded(org.eclipse.aether.artifact.Artifact artifact, boolean disabled) {
        if (disabled) {
            this.excludedArtifacts.add(MavenTargetLocation.getKey(artifact));
        } else {
            this.excludedArtifacts.remove(MavenTargetLocation.getKey(artifact));
        }
    }

    public MavenTargetBundle getMavenTargetBundle(org.eclipse.aether.artifact.Artifact artifact) {
        TargetBundle targetBundle = this.targetBundles.get(artifact);
        if (targetBundle instanceof MavenTargetBundle) {
            return (MavenTargetBundle)targetBundle;
        }
        return null;
    }

    public Collection<String> getExcludes() {
        return Collections.unmodifiableCollection(this.excludedArtifacts);
    }

    public Collection<BNDInstructions> getInstructions() {
        return Collections.unmodifiableCollection(this.instructionsMap.values());
    }
}

