/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.browser.core;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.modisco.infra.browser.Messages;
import org.eclipse.modisco.infra.browser.MoDiscoBrowserPlugin;
import org.eclipse.modisco.infra.browser.core.InstancesForMetaclasses;
import org.eclipse.modisco.infra.browser.editors.BrowserConfiguration;
import org.eclipse.modisco.infra.browser.uicore.internal.customization.CustomizationEngine;
import org.eclipse.modisco.infra.common.core.internal.utils.ModelUtils;
import org.eclipse.modisco.infra.facet.Facet;
import org.eclipse.modisco.infra.facet.core.adapters.instances.MetaclassInstancesAdapterFactoryWithFacet;
import org.eclipse.modisco.util.emf.core.internal.allinstances.MetaclassInstances;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstancesForMetaclass {
    private final ArrayList<InstancesForMetaclass> subclasses = new ArrayList();
    private final EClass eClass;
    private final InstancesForMetaclasses instancesForMetaclasses;
    private final BrowserConfiguration browserConfiguration;
    private ArrayList<EObject> cachedElements = null;
    private int cachedElementsModCount = -1;
    private ArrayList<EObject> cachedDerivedElements = null;
    private int cachedDerivedElementsModCount = -1;
    private final Collection<Resource> fResources;
    private final Object cacheLock = new Object();
    private String classQualifiedName = null;
    private Object parent;

    public InstancesForMetaclass(EClass eClass, InstancesForMetaclasses instancesForMetaclasses, BrowserConfiguration browserConfiguration, Collection<Resource> resources) {
        this.eClass = eClass;
        this.instancesForMetaclasses = instancesForMetaclasses;
        this.browserConfiguration = browserConfiguration;
        this.fResources = resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<EObject> getElements() {
        Object object = this.cacheLock;
        synchronized (object) {
            if (this.cachedElements == null || this.cachedElementsModCount != this.browserConfiguration.getAppearanceConfiguration().getModCount()) {
                ArrayList<Resource> resources;
                CustomizationEngine customizationEngine = this.browserConfiguration.getAppearanceConfiguration().getCustomizationEngine();
                MetaclassInstancesAdapterFactoryWithFacet.getInstance().setFacetContext(this.browserConfiguration.getAppearanceConfiguration().getFacetContext());
                ArrayList visibleElements = new ArrayList();
                InstancesForMetaclass instancesForMetaclass = this;
                synchronized (instancesForMetaclass) {
                    resources = new ArrayList<Resource>(this.fResources);
                }
                for (Resource resource : resources) {
                    MetaclassInstances instances = (MetaclassInstances)MetaclassInstancesAdapterFactoryWithFacet.getInstance().adapt((Notifier)resource, MetaclassInstances.class);
                    Collection elements = instances.getInstances(this.eClass, false);
                    customizationEngine.filterVisible(elements, visibleElements);
                }
                this.cachedElements = visibleElements;
                this.cachedElementsModCount = this.browserConfiguration.getAppearanceConfiguration().getModCount();
            }
        }
        return this.cachedElements;
    }

    public synchronized ArrayList<EObject> getDerivedElements() {
        if (this.cachedDerivedElements == null || this.cachedDerivedElementsModCount != this.browserConfiguration.getAppearanceConfiguration().getModCount()) {
            CustomizationEngine customizationEngine = this.browserConfiguration.getAppearanceConfiguration().getCustomizationEngine();
            MetaclassInstancesAdapterFactoryWithFacet.getInstance().setFacetContext(this.browserConfiguration.getAppearanceConfiguration().getFacetContext());
            ArrayList visibleElements = new ArrayList();
            for (Resource resource : this.fResources) {
                MetaclassInstances instances = (MetaclassInstances)MetaclassInstancesAdapterFactoryWithFacet.getInstance().adapt((Notifier)resource, MetaclassInstances.class);
                Collection elements = instances.getInstances(this.eClass, true);
                customizationEngine.filterVisible(elements, visibleElements);
            }
            this.cachedDerivedElements = visibleElements;
            this.cachedDerivedElementsModCount = this.browserConfiguration.getAppearanceConfiguration().getModCount();
        }
        return this.cachedDerivedElements;
    }

    public int size() {
        return this.getElements().size();
    }

    public int totalSize() {
        return this.getDerivedElements().size();
    }

    public EClass getEClass() {
        return this.eClass;
    }

    public synchronized String getClassQualifiedName() {
        if (this.classQualifiedName == null) {
            this.classQualifiedName = ModelUtils.getMetaclassQualifiedName((EClassifier)this.getEClass());
        }
        return this.classQualifiedName;
    }

    public void setParent(Object parent) {
        this.parent = parent;
    }

    public Object getParent() {
        return this.parent;
    }

    public synchronized void buildParentsSubclasses() {
        EList superTypes = this.eClass.getESuperTypes();
        for (EClass superclass : superTypes) {
            InstancesForMetaclass instancesForSuperclass = this.instancesForMetaclasses.getInstancesForMetaclass(superclass);
            if (instancesForSuperclass != null) {
                instancesForSuperclass.addSubclass(this);
                continue;
            }
            if (this.eClass instanceof Facet) continue;
            MoDiscoBrowserPlugin.logWarning(NLS.bind((String)Messages.InstancesForMetaclass_notFound, (Object)ModelUtils.getMetaclassQualifiedName((EClassifier)superclass)));
        }
    }

    public synchronized void clearSubclasses() {
        this.subclasses.clear();
    }

    public synchronized InstancesForMetaclass[] getSubclasses() {
        return this.subclasses.toArray(new InstancesForMetaclass[this.subclasses.size()]);
    }

    private synchronized void addSubclass(InstancesForMetaclass instancesForMetaclass) {
        this.subclasses.add(instancesForMetaclass);
    }

    public String toString() {
        return String.valueOf(this.getClassQualifiedName()) + " " + this.size();
    }
}

