/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.discovery.ui.internal.launch.parametersdisplay;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.modisco.facet.widgets.celleditors.ICompositeEditorFactory;
import org.eclipse.modisco.facet.widgets.celleditors.core.composite.registry.ICompositeEditorFactoriesRegistry;
import org.eclipse.modisco.infra.discovery.ui.internal.celleditors.composite.ComposedCellEditor;
import org.eclipse.modisco.infra.discovery.ui.internal.celleditors.composite.IComposedCellEditorListener;
import org.eclipse.modisco.infra.discovery.ui.internal.launch.data.DiscovererParameterDisplay;
import org.eclipse.modisco.infra.discovery.ui.internal.launch.parametersdisplay.IEditingSupportListener;
import org.eclipse.swt.widgets.Composite;

public class ParametersTableEditingSupport
extends EditingSupport {
    private final List<IEditingSupportListener> listeners = new ArrayList<IEditingSupportListener>();

    public ParametersTableEditingSupport(TableViewer viewer) {
        super((ColumnViewer)viewer);
    }

    public void addListener(IEditingSupportListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(IEditingSupportListener listener) {
        this.listeners.remove(listener);
    }

    public void fireCellEditorOpened() {
        for (IEditingSupportListener listener : new ArrayList<IEditingSupportListener>(this.listeners)) {
            listener.cellEditorOpened();
        }
    }

    public void fireCellEditorClosed() {
        for (IEditingSupportListener listener : new ArrayList<IEditingSupportListener>(this.listeners)) {
            listener.cellEditorClosed();
        }
    }

    protected boolean canEdit(Object element) {
        Class type = ((DiscovererParameterDisplay)element).getParameterDescription().getType();
        return ICompositeEditorFactoriesRegistry.INSTANCE.hasCompositeEditorFactory(type);
    }

    protected CellEditor getCellEditor(Object element) {
        ComposedCellEditor cellEditor = null;
        Class type = ((DiscovererParameterDisplay)element).getParameterDescription().getType();
        if (ICompositeEditorFactoriesRegistry.INSTANCE.hasCompositeEditorFactory(type)) {
            ICompositeEditorFactory factory = ICompositeEditorFactoriesRegistry.INSTANCE.getCompositeEditorFactory(type);
            cellEditor = new ComposedCellEditor((Composite)((TableViewer)this.getViewer()).getTable(), factory);
        }
        if (cellEditor == null) {
            return null;
        }
        this.fireCellEditorOpened();
        cellEditor.addListener(new IComposedCellEditorListener(){

            public void deactivated() {
                ParametersTableEditingSupport.this.fireCellEditorClosed();
            }
        });
        return cellEditor;
    }

    protected Object getValue(Object element) {
        return ((DiscovererParameterDisplay)element).getValue();
    }

    protected void setValue(Object element, Object value) {
        ((DiscovererParameterDisplay)element).setValue(value);
        this.getViewer().update(element, null);
    }
}

