/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.ui.gist;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.HandlerEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.op.CloneOperation;
import org.eclipse.egit.core.op.ConnectProviderOperation;
import org.eclipse.egit.core.settings.GitSettings;
import org.eclipse.egit.ui.Activator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.mylyn.internal.github.core.gist.GistAttribute;
import org.eclipse.mylyn.internal.github.ui.TaskDataHandler;
import org.eclipse.mylyn.internal.github.ui.gist.Messages;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class CloneGistHandler
extends TaskDataHandler {
    public static final String ID = "org.eclipse.mylyn.github.ui.command.cloneGist";

    public static String getGistName(TaskData data) {
        return "gist-" + data.getTaskId();
    }

    private static IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private static RepositoryUtil getRepoUtil() {
        return RepositoryUtil.getInstance();
    }

    @Override
    public boolean isEnabled(TaskData data) {
        String id = CloneGistHandler.getGistName(data);
        return !CloneGistHandler.getWorkspaceRoot().getProject(id).exists() && !CloneGistHandler.getRepoUtil().getConfiguredRepositories().contains(id);
    }

    private File getParentDirectory() {
        String destinationDir = RepositoryUtil.getDefaultRepositoryDir();
        File parentDir = new File(destinationDir);
        if (!parentDir.exists() || !parentDir.isDirectory()) {
            parentDir = ResourcesPlugin.getWorkspace().getRoot().getRawLocation().toFile();
        }
        return parentDir;
    }

    private void createProject(File workDir, String name, Repository repository, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = null;
        String projectName = null;
        File projectFile = new File(workDir, ".project");
        if (projectFile.exists()) {
            description = ResourcesPlugin.getWorkspace().loadProjectDescription(Path.fromOSString((String)projectFile.getAbsolutePath()));
            projectName = description.getName();
        } else {
            description = ResourcesPlugin.getWorkspace().newProjectDescription(name);
            description.setLocation(Path.fromOSString((String)workDir.getAbsolutePath()));
            projectName = name;
        }
        monitor.setTaskName(Messages.CloneGistHandler_TaskCreatingProject);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        project.create(description, monitor);
        project.open(128, monitor);
        monitor.setTaskName(Messages.CloneGistHandler_TaskConnectingProject);
        new ConnectProviderOperation(project, repository.getDirectory()).execute(monitor);
    }

    private CloneOperation createCloneOperation(TaskData data, String name) throws IOException, URISyntaxException {
        String pullUrl = data.getRoot().getAttribute(GistAttribute.CLONE_URL.getMetadata().getId()).getValue();
        URIish uri = new URIish(pullUrl);
        int timeout = GitSettings.getRemoteConnectionTimeout();
        File workDir = new File(this.getParentDirectory(), name);
        if (CloneGistHandler.getRepoUtil().getConfiguredRepositories().contains(new File(workDir, ".git").getAbsolutePath())) {
            throw new IOException(MessageFormat.format(Messages.CloneGistHandler_ErrorRepoExists, name));
        }
        return new CloneOperation(uri, true, null, workDir, "refs/heads/master", "origin", timeout);
    }

    private Job createCloneJob(final ExecutionEvent event, final TaskData data) {
        Job job = new Job(Messages.CloneGistHandler_TaskCloning){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        final String name = CloneGistHandler.getGistName(data);
                        CloneOperation operation = CloneGistHandler.this.createCloneOperation(data, name);
                        operation.addPostCloneTask(new CloneOperation.PostCloneTask(){

                            public void execute(Repository repository, IProgressMonitor monitor) throws CoreException {
                                if (monitor.isCanceled()) {
                                    return;
                                }
                                monitor.setTaskName(Messages.CloneGistHandler_TaskRegisteringRepository);
                                CloneGistHandler.getRepoUtil().addConfiguredRepository(repository.getDirectory());
                            }
                        });
                        operation.addPostCloneTask(new CloneOperation.PostCloneTask(){

                            public void execute(final Repository repository, IProgressMonitor monitor) throws CoreException {
                                IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                                    public void run(IProgressMonitor monitor) throws CoreException {
                                        if (monitor.isCanceled()) {
                                            return;
                                        }
                                        CloneGistHandler.this.createProject(repository.getDirectory().getParentFile(), name, repository, monitor);
                                    }
                                };
                                ResourcesPlugin.getWorkspace().run(runnable, monitor);
                            }
                        });
                        operation.run(monitor);
                    }
                    catch (Exception e) {
                        CloneGistHandler.this.displayError(event, e);
                        Activator.logError((String)"Error cloning gist", (Throwable)e);
                        CloneGistHandler.this.fireHandlerChanged(new HandlerEvent((IHandler)CloneGistHandler.this, true, false));
                    }
                }
                finally {
                    CloneGistHandler.this.fireHandlerChanged(new HandlerEvent((IHandler)CloneGistHandler.this, true, false));
                }
                return Status.OK_STATUS;
            }
        };
        return job;
    }

    private void displayError(final ExecutionEvent event, Exception exception) {
        final Throwable cause = exception.getCause() != null ? exception.getCause() : exception;
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ErrorDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)Messages.CloneGistHandler_ErrorTitle, (String)Messages.CloneGistHandler_ErrorMessage, (IStatus)Activator.createErrorStatus((String)cause.getLocalizedMessage(), (Throwable)cause));
            }
        });
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        TaskData data = this.getTaskData(event);
        if (data != null) {
            this.schedule(this.createCloneJob(event, data), event);
        }
        return null;
    }
}

