/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.graphiti.lookup;

import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.util.ResultRunnable;
import org.eclipse.reddeer.gef.GEFLayerException;
import org.eclipse.reddeer.workbench.impl.editor.DefaultEditor;
import org.eclipse.ui.IEditorPart;

public class DiagramEditorLookup {
    protected final Logger log = Logger.getLogger(this.getClass());
    private static DiagramEditorLookup instance;

    private DiagramEditorLookup() {
    }

    public static DiagramEditorLookup getInstance() {
        if (instance == null) {
            instance = new DiagramEditorLookup();
        }
        return instance;
    }

    public DiagramEditor findDiagramEditor() {
        return this.findDiagramEditor(new ActiveEditor().getIEditorPart());
    }

    public DiagramEditor findDiagramEditor(final IEditorPart editorPart) {
        DiagramEditor diagramEditor = (DiagramEditor)Display.syncExec((ResultRunnable)new ResultRunnable<DiagramEditor>(){

            public DiagramEditor run() {
                return (DiagramEditor)editorPart.getAdapter(DiagramEditor.class);
            }
        });
        if (diagramEditor == null) {
            throw new GEFLayerException("Cannot find diagram editor in a given editor part");
        }
        return diagramEditor;
    }

    private class ActiveEditor
    extends DefaultEditor {
        public IEditorPart getIEditorPart() {
            return this.getEditorPart();
        }
    }
}

