/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.properties.sections.common;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.sirius.editor.properties.ViewpointPropertySheetPage;
import org.eclipse.sirius.editor.properties.sections.common.AbstractViewpointPropertySection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class AbstractCheckBoxPropertySection
extends AbstractViewpointPropertySection {
    protected Button checkbox;
    protected CLabel nameLabel;
    protected Composite composite;

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        if (tabbedPropertySheetPage instanceof ViewpointPropertySheetPage) {
            super.createControls(parent, (ViewpointPropertySheetPage)tabbedPropertySheetPage);
        } else {
            super.createControls(parent, tabbedPropertySheetPage);
        }
        this.composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.checkbox = this.getWidgetFactory().createButton(this.composite, "", 32);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 232);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.checkbox.setLayoutData((Object)data);
        this.nameLabel = this.getWidgetFactory().createCLabel(this.composite, this.getLabelText());
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.checkbox, -25);
        data.top = new FormAttachment((Control)this.checkbox, 0, 0x1000000);
        this.nameLabel.setLayoutData((Object)data);
        this.checkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractCheckBoxPropertySection.this.handleSelectionModified();
            }
        });
    }

    public void aboutToBeShown() {
        super.aboutToBeShown();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.composite, "org.eclipse.sirius." + this.eObject.eClass().getName());
    }

    @Override
    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        this.nameLabel.setText(this.getLabelText());
    }

    protected void handleSelectionModified() {
        String newText = String.valueOf(this.checkbox.getSelection());
        boolean equals = this.isEqual(newText);
        if (!equals) {
            EditingDomain editingDomain = ((IEditingDomainProvider)this.getPart()).getEditingDomain();
            Object value = this.getFeatureValue(newText);
            if (this.eObjectList.size() == 1) {
                editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)editingDomain, (Object)this.eObject, (Object)this.getFeature(), (Object)value));
            } else {
                CompoundCommand compoundCommand = new CompoundCommand();
                for (EObject nextObject : this.eObjectList) {
                    compoundCommand.append(SetCommand.create((EditingDomain)editingDomain, (Object)nextObject, (Object)this.getFeature(), (Object)value));
                }
                editingDomain.getCommandStack().execute((Command)compoundCommand);
            }
        }
    }

    public void refresh() {
        if (this.getFeatureAsText() != null) {
            this.checkbox.setSelection(Boolean.parseBoolean(this.getFeatureAsText()));
        }
    }

    protected abstract boolean isEqual(String var1);

    protected abstract EAttribute getFeature();

    protected String getDefaultFeatureAsText() {
        String value = new String();
        if (this.eObject.eGet((EStructuralFeature)this.getFeature()) != null) {
            value = this.eObject.eGet((EStructuralFeature)this.getFeature()).toString();
        }
        return value;
    }

    protected String getFeatureAsText() {
        EAttribute eFeature = this.getFeature();
        IItemPropertyDescriptor propertyDescriptor = this.getPropertyDescriptor((EStructuralFeature)eFeature);
        if (propertyDescriptor != null) {
            return propertyDescriptor.getLabelProvider((Object)this.eObject).getText(this.eObject.eGet((EStructuralFeature)eFeature));
        }
        return this.getDefaultFeatureAsText();
    }

    protected abstract Object getFeatureValue(String var1);

    protected abstract String getDefaultLabelText();

    protected String getLabelText() {
        EAttribute eFeature;
        IItemPropertyDescriptor propertyDescriptor;
        if (this.eObject != null && (propertyDescriptor = this.getPropertyDescriptor((EStructuralFeature)(eFeature = this.getFeature()))) != null) {
            return propertyDescriptor.getDisplayName((Object)this.eObject);
        }
        return this.getDefaultLabelText();
    }

    @Override
    protected void makeReadonly() {
        this.checkbox.setEnabled(false);
    }

    @Override
    protected void makeWrittable() {
        this.checkbox.setEnabled(true);
    }
}

