/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.plan;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.exceptions.LocalSearchException;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ILocalSearchAdaptable;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ILocalSearchAdapter;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.ISearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.plan.SearchPlan;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;

public class SearchPlanExecutor
implements ILocalSearchAdaptable {
    private int currentOperation;
    private final List<ISearchOperation.ISearchOperationExecutor> operations;
    private final SearchPlan plan;
    private final ISearchContext context;
    private final List<ILocalSearchAdapter> adapters = new CopyOnWriteArrayList<ILocalSearchAdapter>();

    public Map<Integer, PVariable> getVariableMapping() {
        return this.plan.getVariableMapping();
    }

    public int getCurrentOperation() {
        return this.currentOperation;
    }

    public SearchPlan getSearchPlan() {
        return this.plan;
    }

    public TupleMask getParameterMask() {
        return this.plan.getParameterMask();
    }

    @Override
    public void addAdapters(List<ILocalSearchAdapter> adapters) {
        for (ILocalSearchAdapter adapter : adapters) {
            if (this.adapters.contains(adapter)) continue;
            this.adapters.add(adapter);
            adapter.adapterRegistered(this);
        }
    }

    @Override
    public void removeAdapters(List<ILocalSearchAdapter> adapters) {
        for (ILocalSearchAdapter adapter : adapters) {
            if (!this.adapters.remove(adapter)) continue;
            adapter.adapterUnregistered(this);
        }
    }

    public SearchPlanExecutor(SearchPlan plan, ISearchContext context) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (String)"Context cannot be null");
        this.plan = plan;
        this.context = context;
        this.operations = plan.getOperations().stream().map(ISearchOperation::createExecutor).collect(Collectors.toList());
        this.currentOperation = -1;
    }

    private void init(MatchingFrame frame) {
        if (this.currentOperation == -1) {
            ++this.currentOperation;
            ISearchOperation.ISearchOperationExecutor operation = this.operations.get(this.currentOperation);
            if (!this.adapters.isEmpty()) {
                for (ILocalSearchAdapter adapter : this.adapters) {
                    adapter.executorInitializing(this.plan, frame);
                }
            }
            operation.onInitialize(frame, this.context);
        } else if (this.currentOperation == this.operations.size()) {
            --this.currentOperation;
        } else {
            throw new LocalSearchException("Error while executing search plan");
        }
    }

    public double cost() {
        return 0.0;
    }

    public boolean execute(MatchingFrame frame) {
        boolean matchFound;
        int upperBound = this.operations.size() - 1;
        this.init(frame);
        this.operationSelected(frame, this.currentOperation, false);
        while (this.currentOperation >= 0 && this.currentOperation <= upperBound) {
            ISearchOperation.ISearchOperationExecutor operation;
            if (this.operations.get(this.currentOperation).execute(frame, this.context)) {
                this.operationExecuted(frame, this.currentOperation, true);
                ++this.currentOperation;
                this.operationSelected(frame, this.currentOperation, false);
                if (this.currentOperation > upperBound) continue;
                operation = this.operations.get(this.currentOperation);
                operation.onInitialize(frame, this.context);
                continue;
            }
            this.operationExecuted(frame, this.currentOperation, false);
            operation = this.operations.get(this.currentOperation);
            operation.onBacktrack(frame, this.context);
            --this.currentOperation;
            this.operationSelected(frame, this.currentOperation, true);
        }
        boolean bl = matchFound = this.currentOperation > upperBound;
        if (matchFound && !this.adapters.isEmpty()) {
            for (ILocalSearchAdapter adapter : this.adapters) {
                adapter.matchFound(this.plan, frame);
            }
        }
        return matchFound;
    }

    public void resetPlan() {
        this.currentOperation = -1;
    }

    public void printDebugInformation() {
        int i = 0;
        while (i < this.operations.size()) {
            Logger.getRootLogger().debug((Object)("[" + i + "]\t" + this.operations.get(i).toString()));
            ++i;
        }
    }

    private void operationExecuted(MatchingFrame frame, int operationIndex, boolean isSuccessful) {
        if (!this.adapters.isEmpty()) {
            for (ILocalSearchAdapter adapter : this.adapters) {
                adapter.operationExecuted(this.plan, this.operations.get(operationIndex).getOperation(), frame, isSuccessful);
            }
        }
    }

    private void operationSelected(MatchingFrame frame, int operationIndex, boolean isBacktrack) {
        if (!this.adapters.isEmpty() && operationIndex >= 0 && operationIndex < this.operations.size()) {
            for (ILocalSearchAdapter adapter : this.adapters) {
                adapter.operationSelected(this.plan, this.operations.get(operationIndex).getOperation(), frame, isBacktrack);
            }
        }
    }

    public ISearchContext getContext() {
        return this.context;
    }

    @Override
    public List<ILocalSearchAdapter> getAdapters() {
        return Collections.unmodifiableList(this.adapters);
    }

    @Override
    public void addAdapter(ILocalSearchAdapter adapter) {
        this.addAdapters(Collections.singletonList(adapter));
    }

    @Override
    public void removeAdapter(ILocalSearchAdapter adapter) {
        this.removeAdapters(Collections.singletonList(adapter));
    }

    public String toString() {
        if (this.operations == null) {
            return "Unspecified plan";
        }
        return this.operations.stream().map(Object::toString).collect(Collectors.joining("\n"));
    }
}

