/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.databinding.model;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.wb.internal.core.databinding.model.AstObjectInfo;
import org.eclipse.wb.internal.core.databinding.model.AstObjectInfoVisitor;
import org.eclipse.wb.internal.core.utils.check.Assert;

public class CodeGenerationSupport {
    private final boolean m_useGenerics;
    private final Set<String> m_variables = Sets.newHashSet();
    private final Set<AstObjectInfo> m_models = Sets.newHashSet();

    public CodeGenerationSupport(boolean useGenerics) {
        this.m_useGenerics = useGenerics;
    }

    public CodeGenerationSupport(boolean useGenerics, AstObjectInfo rootModelObject) throws Exception {
        this.m_useGenerics = useGenerics;
        rootModelObject.accept(new AstObjectInfoVisitor(){

            @Override
            public void visit(AstObjectInfo object) throws Exception {
                String variable = object.getVariableIdentifier();
                if (variable != null) {
                    CodeGenerationSupport.this.m_variables.add(variable);
                }
            }
        });
    }

    public boolean useGenerics() {
        return this.m_useGenerics;
    }

    public void addSourceCode(AstObjectInfo modelObject, List<String> lines) throws Exception {
        if (!this.m_models.contains(modelObject)) {
            this.m_models.add(modelObject);
            modelObject.addSourceCode(lines, this);
            Assert.isNotNull((Object)modelObject.getVariableIdentifier());
        }
    }

    public boolean addModel(AstObjectInfo modelObject) {
        return this.m_models.add(modelObject);
    }

    public String generateLocalName(String ... names) throws Exception {
        String baseVariable;
        String variable = baseVariable = CodeGenerationSupport.createName(names);
        int variableIndex = 1;
        while (this.m_variables.contains(variable)) {
            variable = String.valueOf(baseVariable) + "_" + Integer.toString(variableIndex++);
        }
        this.m_variables.add(variable);
        return variable;
    }

    private static String createName(String[] names) {
        Assert.isTrue((names.length > 0 ? 1 : 0) != 0);
        int i = 0;
        while (i < names.length) {
            names[i] = CodeGenerationSupport.convertName(names[i]);
            ++i;
        }
        return StringUtils.uncapitalize((String)StringUtils.join((Object[])names));
    }

    private static String convertName(String name) {
        if (name.startsWith("m_")) {
            name = name.substring(2);
        }
        name = StringUtils.remove((String)name, (char)'.');
        name = StringUtils.remove((String)name, (char)'\"');
        name = StringUtils.remove((String)name, (char)'(');
        name = StringUtils.remove((String)name, (char)')');
        return StringUtils.capitalize((String)name);
    }
}

