"use strict";
/* --------------------------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for license information.
 * ------------------------------------------------------------------------------------------ */
Object.defineProperty(exports, "__esModule", { value: true });
const assert = require("assert");
const main_1 = require("../main");
suite('Browser IPC Reader / Writer', () => {
    test('Simple request message with response', (done) => {
        const worker = new Worker('/dist/worker.js');
        const reader = new main_1.BrowserMessageReader(worker);
        const writer = new main_1.BrowserMessageWriter(worker);
        reader.listen((message) => {
            const response = message;
            assert.strictEqual(response.result, 42);
            done();
        });
        const request = {
            jsonrpc: '2.0',
            id: 1,
            method: 'example'
        };
        writer.write(request);
    });
});
//# sourceMappingURL=test.js.map