/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.popup;

import java.io.File;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.wst.ws.internal.converter.IIFile2UriConverter;
import org.eclipse.wst.ws.internal.explorer.LaunchOption;
import org.eclipse.wst.ws.internal.explorer.WSExplorerLauncherCommand;
import org.eclipse.wst.ws.internal.explorer.plugin.ExplorerPlugin;
import org.eclipse.wst.ws.internal.monitor.GetMonitorCommand;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;
import org.eclipse.wst.ws.internal.plugin.WSPlugin;
import org.eclipse.wst.ws.internal.ui.utils.AdapterUtils;
import org.eclipse.wst.ws.internal.wsfinder.WSDLURLStringWrapper;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.internal.impl.ServiceImpl;
import org.eclipse.wst.wsdl.util.WSDLResourceImpl;

public class PopupTestWSDL
extends Action
implements IActionDelegate {
    protected IStructuredSelection selection = null;

    public PopupTestWSDL() {
        super(ExplorerPlugin.getMessage("%POPUP_TEST_WSDL"));
    }

    public void run() {
        String stateLocation = ExplorerPlugin.getInstance().getPluginStateLocation();
        String defaultFavoritesLocation = ExplorerPlugin.getInstance().getDefaultFavoritesLocation();
        WSExplorerLauncherCommand command = new WSExplorerLauncherCommand();
        command.setForceLaunchOutsideIDE(false);
        Vector launchOptions = new Vector();
        if (this.selection != null) {
            Iterator it = this.selection.iterator();
            while (it.hasNext()) {
                Definition definition;
                String wsdlURL = null;
                Object object = it.next();
                if (object instanceof IResource) {
                    File wsdlFile = ((IResource)object).getLocation().toFile();
                    try {
                        wsdlURL = wsdlFile.toURL().toString();
                    }
                    catch (MalformedURLException malformedURLException) {
                        wsdlURL = wsdlFile.toString();
                    }
                    if (object instanceof IFile) {
                        wsdlURL = this.getConvertedURIFromIFile((IFile)object, wsdlURL);
                    }
                } else if (Platform.getAdapterManager().hasAdapter(object, WSDLURLStringWrapper.class.getName())) {
                    Object adaptedObject = Platform.getAdapterManager().loadAdapter(object, WSDLURLStringWrapper.class.getName());
                    WSDLURLStringWrapper wrapper = (WSDLURLStringWrapper)adaptedObject;
                    wsdlURL = wrapper.getWSDLURLString();
                } else if (object instanceof ServiceImpl) {
                    ServiceImpl serviceImpl = (ServiceImpl)object;
                    definition = serviceImpl.getEnclosingDefinition();
                    wsdlURL = this.getConvertedURIFromURI(definition.getLocation());
                } else if (object instanceof WSDLResourceImpl) {
                    WSDLResourceImpl WSDLRImpl = (WSDLResourceImpl)object;
                    definition = WSDLRImpl.getDefinition();
                    wsdlURL = this.getConvertedURIFromURI(definition.getLocation());
                } else {
                    wsdlURL = object instanceof String ? (String)object : AdapterUtils.getAdaptedWSDL(object);
                }
                if (wsdlURL == null) continue;
                this.addLaunchOptions(launchOptions, wsdlURL, stateLocation, defaultFavoritesLocation);
            }
        }
        command.setLaunchOptions(launchOptions.toArray(new LaunchOption[0]));
        command.execute();
    }

    protected void addLaunchOptions(Vector launchOptions, String wsdlURL, String stateLocation, String defaultFavoritesLocation) {
        GetMonitorCommand getMonitorCmd = new GetMonitorCommand();
        getMonitorCmd.setMonitorService(true);
        getMonitorCmd.setCreate(false);
        getMonitorCmd.setWebServicesParser(new WebServicesParser());
        getMonitorCmd.setWsdlURI(wsdlURL);
        getMonitorCmd.execute(null, null);
        List endpoints = getMonitorCmd.getEndpoints();
        Iterator endpointsIt = endpoints.iterator();
        while (endpointsIt.hasNext()) {
            launchOptions.add(new LaunchOption("webServiceEndpoint", (String)endpointsIt.next()));
        }
        launchOptions.add(new LaunchOption("wsdl", wsdlURL));
        launchOptions.add(new LaunchOption("stateLocation", stateLocation));
        launchOptions.add(new LaunchOption("defaultFavoritesLocation", defaultFavoritesLocation));
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : null;
    }

    private String getConvertedURIFromIFile(IFile file, String defaultURI) {
        IIFile2UriConverter converter;
        String convertedLocation = null;
        boolean allowBaseConversionOnFailure = true;
        if (file != null && file.exists() && (converter = WSPlugin.getInstance().getIFile2UriConverter()) != null) {
            convertedLocation = converter.convert(file);
            allowBaseConversionOnFailure = converter.allowBaseConversionOnFailure();
        }
        if (convertedLocation == null && allowBaseConversionOnFailure) {
            return defaultURI;
        }
        return convertedLocation;
    }

    private String getConvertedURIFromURI(String originalURI) {
        IFile file = null;
        if (originalURI != null) {
            String platformResource = "platform:/resource";
            if (originalURI.startsWith(platformResource)) {
                file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(originalURI.substring(platformResource.length())));
            } else if (originalURI.startsWith("file:")) {
                String filePath = PopupTestWSDL.convertToRelative(originalURI);
                file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filePath));
            }
        }
        return this.getConvertedURIFromIFile(file, originalURI);
    }

    public static String convertToRelative(String uri) {
        String file = "file:/";
        String fileL = "file:";
        String root = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
        root = String.valueOf(file) + root;
        String rootL = String.valueOf(fileL) + root;
        if (uri.startsWith(root) || uri.startsWith(rootL)) {
            return uri.substring(root.length());
        }
        return uri;
    }
}

