/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.immutables.value.Value;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.Device;
import org.mandas.docker.client.messages.ImmutableHostConfig;
import org.mandas.docker.client.messages.LogConfig;
import org.mandas.docker.client.messages.PortBinding;
import org.mandas.docker.client.messages.mount.Mount;

@JsonDeserialize(builder=ImmutableHostConfig.Builder.class)
@Value.Immutable
@Value.Enclosing
public interface HostConfig {
    @JsonProperty(value="Binds")
    @Nullable
    public List<String> binds();

    @JsonProperty(value="BlkioWeight")
    @Nullable
    public Integer blkioWeight();

    @JsonProperty(value="BlkioWeightDevice")
    @Nullable
    public List<BlkioWeightDevice> blkioWeightDevice();

    @JsonProperty(value="BlkioDeviceReadBps")
    @Nullable
    public List<BlkioDeviceRate> blkioDeviceReadBps();

    @JsonProperty(value="BlkioDeviceWriteBps")
    @Nullable
    public List<BlkioDeviceRate> blkioDeviceWriteBps();

    @JsonProperty(value="BlkioDeviceReadIOps")
    @Nullable
    public List<BlkioDeviceRate> blkioDeviceReadIOps();

    @JsonProperty(value="BlkioDeviceWriteIOps")
    @Nullable
    public List<BlkioDeviceRate> blkioDeviceWriteIOps();

    @JsonProperty(value="ContainerIDFile")
    @Nullable
    public String containerIdFile();

    @JsonProperty(value="LxcConf")
    @Nullable
    public List<LxcConfParameter> lxcConf();

    @JsonProperty(value="Privileged")
    @Nullable
    public Boolean privileged();

    @JsonProperty(value="PortBindings")
    @Nullable
    public Map<String, List<PortBinding>> portBindings();

    @JsonProperty(value="Links")
    @Nullable
    public List<String> links();

    @JsonProperty(value="PublishAllPorts")
    @Nullable
    public Boolean publishAllPorts();

    @JsonProperty(value="Dns")
    @Nullable
    public List<String> dns();

    @JsonProperty(value="DnsOptions")
    @Nullable
    public List<String> dnsOptions();

    @JsonProperty(value="DnsSearch")
    @Nullable
    public List<String> dnsSearch();

    @JsonProperty(value="ExtraHosts")
    @Nullable
    public List<String> extraHosts();

    @JsonProperty(value="GroupAdd")
    @Nullable
    public List<String> groupAdd();

    @JsonProperty(value="VolumesFrom")
    @Nullable
    public List<String> volumesFrom();

    @JsonProperty(value="CapAdd")
    @Nullable
    public List<String> capAdd();

    @JsonProperty(value="CapDrop")
    @Nullable
    public List<String> capDrop();

    @JsonProperty(value="NetworkMode")
    @Nullable
    public String networkMode();

    @JsonProperty(value="SecurityOpt")
    @Nullable
    public List<String> securityOpt();

    @JsonProperty(value="Devices")
    @Nullable
    public List<Device> devices();

    @JsonProperty(value="Memory")
    @Nullable
    public Long memory();

    @JsonProperty(value="MemorySwap")
    @Nullable
    public Long memorySwap();

    @JsonProperty(value="KernelMemory")
    @Nullable
    public Long kernelMemory();

    @JsonProperty(value="MemorySwappiness")
    @Nullable
    public Integer memorySwappiness();

    @JsonProperty(value="MemoryReservation")
    @Nullable
    public Long memoryReservation();

    @JsonProperty(value="NanoCpus")
    @Nullable
    public Long nanoCpus();

    @JsonProperty(value="CpuPeriod")
    @Nullable
    public Long cpuPeriod();

    @JsonProperty(value="CpuShares")
    @Nullable
    public Long cpuShares();

    @JsonProperty(value="CpusetCpus")
    @Nullable
    public String cpusetCpus();

    @JsonProperty(value="CpusetMems")
    @Nullable
    public String cpusetMems();

    @JsonProperty(value="CpuQuota")
    @Nullable
    public Long cpuQuota();

    @JsonProperty(value="CgroupParent")
    @Nullable
    public String cgroupParent();

    @JsonProperty(value="RestartPolicy")
    @Nullable
    public RestartPolicy restartPolicy();

    @JsonProperty(value="LogConfig")
    @Nullable
    public LogConfig logConfig();

    @JsonProperty(value="IpcMode")
    @Nullable
    public String ipcMode();

    @JsonProperty(value="Ulimits")
    @Nullable
    public List<Ulimit> ulimits();

    @JsonProperty(value="PidMode")
    @Nullable
    public String pidMode();

    @JsonProperty(value="ShmSize")
    @Nullable
    public Long shmSize();

    @JsonProperty(value="OomKillDisable")
    @Nullable
    public Boolean oomKillDisable();

    @JsonProperty(value="OomScoreAdj")
    @Nullable
    public Integer oomScoreAdj();

    @JsonProperty(value="AutoRemove")
    @Nullable
    public Boolean autoRemove();

    @JsonProperty(value="PidsLimit")
    @Nullable
    public Integer pidsLimit();

    @JsonProperty(value="Tmpfs")
    @Nullable
    public Map<String, String> tmpfs();

    @JsonProperty(value="ReadonlyRootfs")
    @Nullable
    public Boolean readonlyRootfs();

    @JsonProperty(value="StorageOpt")
    @Nullable
    public Map<String, String> storageOpt();

    @JsonProperty(value="Runtime")
    @Nullable
    public String runtime();

    @JsonProperty(value="Mounts")
    @Nullable
    public List<Mount> mounts();

    @JsonProperty(value="Init")
    @Nullable
    public Boolean init();

    @JsonProperty(value="Sysctls")
    public Map<String, String> sysctls();

    @JsonProperty(value="Capabilities")
    @Nullable
    public List<String> capabilities();

    @JsonProperty(value="DeviceRequests")
    @Nullable
    public List<DeviceRequest> deviceRequests();

    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    default public Builder toBuilder() {
        return ImmutableHostConfig.builder().from(this);
    }

    public static Builder builder() {
        return ImmutableHostConfig.builder();
    }

    @Value.Check
    default public void check() {
        if (this.extraHosts() != null) {
            for (String extraHost : this.extraHosts()) {
                if (extraHost.contains(":")) continue;
                throw new IllegalArgumentException(String.format("extra host arg '%s' must contain a ':'", extraHost));
            }
        }
    }

    @JsonDeserialize(builder=ImmutableHostConfig.Bind.Builder.class)
    @Value.Immutable
    public static interface Bind {
        public String to();

        public String from();

        @Value.Default
        default public boolean readOnly() {
            return false;
        }

        @Nullable
        public Boolean noCopy();

        @Nullable
        public Boolean selinuxLabeling();

        public static Builder builder() {
            return ImmutableHostConfig.Bind.builder();
        }

        @JsonIgnore
        @Value.Derived
        default public String representation() {
            String optionsValue;
            if (this.to() == null || "".equals(this.to().trim())) {
                return "";
            }
            if (this.from() == null || "".equals(this.from().trim())) {
                return this.to();
            }
            String bind = this.from() + ":" + this.to();
            ArrayList<String> options = new ArrayList<String>();
            if (this.readOnly()) {
                options.add("ro");
            }
            if (this.noCopy() != null && this.noCopy().booleanValue()) {
                options.add("nocopy");
            }
            if (this.selinuxLabeling() != null) {
                if (Boolean.TRUE.equals(this.selinuxLabeling())) {
                    options.add("z");
                } else {
                    options.add("Z");
                }
            }
            return (optionsValue = options.stream().collect(Collectors.joining(","))).isEmpty() ? bind : bind + ":" + optionsValue;
        }

        public static interface Builder {
            public Builder to(String var1);

            public Builder from(String var1);

            public Builder readOnly(boolean var1);

            public Builder noCopy(Boolean var1);

            public Builder selinuxLabeling(Boolean var1);

            public Bind build();
        }
    }

    @JsonDeserialize(builder=ImmutableHostConfig.BlkioDeviceRate.Builder.class)
    @Value.Immutable
    public static interface BlkioDeviceRate {
        @JsonProperty(value="Path")
        public String path();

        @JsonProperty(value="Rate")
        public Integer rate();

        public static Builder builder() {
            return ImmutableHostConfig.BlkioDeviceRate.builder();
        }

        public static interface Builder {
            public Builder path(String var1);

            public Builder rate(Integer var1);

            public BlkioDeviceRate build();
        }
    }

    @JsonDeserialize(builder=ImmutableHostConfig.BlkioWeightDevice.Builder.class)
    @Value.Immutable
    public static interface BlkioWeightDevice {
        @JsonProperty(value="Path")
        public String path();

        @JsonProperty(value="Weight")
        public Integer weight();

        public static Builder builder() {
            return ImmutableHostConfig.BlkioWeightDevice.builder();
        }

        public static interface Builder {
            public Builder path(String var1);

            public Builder weight(Integer var1);

            public BlkioWeightDevice build();
        }
    }

    public static interface Builder {
        public Builder binds(Iterable<String> var1);

        public Builder binds(String ... var1);

        default public Builder binds(Bind ... binds) {
            List<String> bindsValue = Arrays.stream(binds).map(Bind::representation).collect(Collectors.toList());
            return this.binds(bindsValue.toArray(new String[bindsValue.size()]));
        }

        public Builder blkioWeight(Integer var1);

        public Builder blkioWeightDevice(Iterable<? extends BlkioWeightDevice> var1);

        public Builder blkioDeviceReadBps(Iterable<? extends BlkioDeviceRate> var1);

        public Builder blkioDeviceWriteBps(Iterable<? extends BlkioDeviceRate> var1);

        public Builder blkioDeviceReadIOps(Iterable<? extends BlkioDeviceRate> var1);

        public Builder blkioDeviceWriteIOps(Iterable<? extends BlkioDeviceRate> var1);

        public Builder containerIdFile(String var1);

        public Builder lxcConf(Iterable<? extends LxcConfParameter> var1);

        public Builder lxcConf(LxcConfParameter ... var1);

        public Builder privileged(Boolean var1);

        public Builder portBindings(Map<String, ? extends List<PortBinding>> var1);

        public Builder links(Iterable<String> var1);

        public Builder links(String ... var1);

        public Builder publishAllPorts(Boolean var1);

        public Builder dns(Iterable<String> var1);

        public Builder dns(String ... var1);

        public Builder dnsOptions(Iterable<String> var1);

        public Builder dnsOptions(String ... var1);

        public Builder dnsSearch(Iterable<String> var1);

        public Builder dnsSearch(String ... var1);

        public Builder extraHosts(Iterable<String> var1);

        public Builder extraHosts(String ... var1);

        public Builder groupAdd(Iterable<String> var1);

        public Builder groupAdd(String ... var1);

        public Builder volumesFrom(Iterable<String> var1);

        public Builder volumesFrom(String ... var1);

        public Builder capAdd(Iterable<String> var1);

        public Builder capAdd(String ... var1);

        public Builder capDrop(Iterable<String> var1);

        public Builder capDrop(String ... var1);

        public Builder networkMode(String var1);

        public Builder securityOpt(Iterable<String> var1);

        public Builder securityOpt(String ... var1);

        public Builder devices(Iterable<? extends Device> var1);

        public Builder devices(Device ... var1);

        public Builder memory(Long var1);

        public Builder memorySwap(Long var1);

        public Builder memorySwappiness(Integer var1);

        public Builder kernelMemory(Long var1);

        public Builder memoryReservation(Long var1);

        public Builder nanoCpus(Long var1);

        public Builder cpuPeriod(Long var1);

        public Builder cpuShares(Long var1);

        public Builder cpusetCpus(String var1);

        public Builder cpusetMems(String var1);

        public Builder cpuQuota(Long var1);

        public Builder cgroupParent(String var1);

        public Builder restartPolicy(RestartPolicy var1);

        public Builder logConfig(LogConfig var1);

        public Builder ipcMode(String var1);

        public Builder ulimits(Iterable<? extends Ulimit> var1);

        public Builder pidMode(String var1);

        default public Builder containerPidMode(String container) {
            this.pidMode("container:" + container);
            return this;
        }

        default public Builder hostPidMode() {
            this.pidMode("host");
            return this;
        }

        public Builder shmSize(Long var1);

        public Builder oomKillDisable(Boolean var1);

        public Builder oomScoreAdj(Integer var1);

        public Builder autoRemove(Boolean var1);

        public Builder pidsLimit(Integer var1);

        public Builder tmpfs(Map<String, ? extends String> var1);

        public Builder readonlyRootfs(Boolean var1);

        public Builder storageOpt(Map<String, ? extends String> var1);

        public Builder runtime(String var1);

        public Builder mounts(Iterable<? extends Mount> var1);

        public Builder mounts(Mount ... var1);

        public Builder init(Boolean var1);

        public Builder sysctls(Map<String, ? extends String> var1);

        public Builder addSysctl(String var1, String var2);

        public Builder capabilities(Iterable<String> var1);

        public Builder deviceRequests(Iterable<? extends DeviceRequest> var1);

        public HostConfig build();
    }

    @JsonDeserialize(builder=ImmutableHostConfig.DeviceRequest.Builder.class)
    @Value.Immutable
    public static interface DeviceRequest {
        @JsonProperty(value="Driver")
        public String driver();

        @JsonProperty(value="Count")
        public Integer count();

        @JsonProperty(value="DeviceIDs")
        public List<String> deviceIds();

        @JsonProperty(value="Capabilities")
        public List<String> capabilities();

        @JsonProperty(value="Options")
        public Map<String, String> options();

        public static Builder builder() {
            return ImmutableHostConfig.DeviceRequest.builder();
        }

        public static interface Builder {
            public Builder driver(String var1);

            public Builder count(Integer var1);

            public Builder deviceIds(Iterable<String> var1);

            public Builder capabilities(Iterable<String> var1);

            public Builder options(Map<String, ? extends String> var1);

            public DeviceRequest build();
        }
    }

    @JsonDeserialize(builder=ImmutableHostConfig.LxcConfParameter.Builder.class)
    @Value.Immutable
    public static interface LxcConfParameter {
        @JsonProperty(value="Key")
        public String key();

        @JsonProperty(value="Value")
        public String value();
    }

    @JsonDeserialize(builder=ImmutableHostConfig.RestartPolicy.Builder.class)
    @Value.Immutable
    public static interface RestartPolicy {
        @JsonProperty(value="Name")
        public String name();

        @JsonProperty(value="MaximumRetryCount")
        @Nullable
        public Integer maxRetryCount();

        public static RestartPolicy always() {
            return ImmutableHostConfig.RestartPolicy.builder().name("always").build();
        }

        public static RestartPolicy unlessStopped() {
            return ImmutableHostConfig.RestartPolicy.builder().name("unless-stopped").build();
        }

        public static RestartPolicy onFailure(Integer maxRetryCount) {
            return ImmutableHostConfig.RestartPolicy.builder().name("on-failure").maxRetryCount(maxRetryCount).build();
        }
    }

    @JsonDeserialize(builder=ImmutableHostConfig.Ulimit.Builder.class)
    @Value.Immutable
    public static interface Ulimit {
        @JsonProperty(value="Name")
        public String name();

        @JsonProperty(value="Soft")
        public Long soft();

        @JsonProperty(value="Hard")
        public Long hard();

        public static Builder builder() {
            return ImmutableHostConfig.Ulimit.builder();
        }

        public static interface Builder {
            public Builder name(String var1);

            public Builder soft(Long var1);

            public Builder hard(Long var1);

            public Ulimit build();
        }
    }
}

