/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.common.ui.decorator;

import org.eclipse.bpel.common.ui.decorator.IMarkerConstants;
import org.eclipse.draw2d.AbstractHintLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class DecorationLayout
extends AbstractHintLayout {
    protected IFigure center;
    protected IFigure left;
    protected IFigure top;
    protected IFigure bottom;
    protected IFigure right;
    protected IFigure topLeft;
    protected IFigure topRight;
    protected IFigure bottomLeft;
    protected IFigure bottomRight;

    protected Point calculateLocation(int locationHint, IFigure container, Dimension childDimension) {
        Rectangle area = container.getClientArea();
        switch (locationHint) {
            case 2: {
                return new Point(area.x + area.width / 2 - childDimension.width / 2, area.y + area.height / 2 - childDimension.height / 2);
            }
            case 8: {
                return new Point(area.x + area.width / 2 - childDimension.width / 2, area.y);
            }
            case 32: {
                return new Point(area.x + area.width / 2 - childDimension.width / 2, area.y + area.height - childDimension.height);
            }
            case 1: {
                return new Point(area.x, area.y + area.height / 2 - childDimension.width / 2);
            }
            case 4: {
                return new Point(area.x + area.width - childDimension.width, area.y + area.height / 2 - childDimension.height / 2);
            }
            case 9: {
                return new Point(area.x, area.y);
            }
            case 12: {
                return new Point(area.x + area.width - childDimension.width, area.y);
            }
            case 33: {
                return new Point(area.x, area.y + area.height - childDimension.height);
            }
            case 36: {
                return new Point(area.x + area.width - childDimension.width, area.y + area.height - childDimension.height);
            }
        }
        return new Point(area.x, area.y);
    }

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        return new Dimension(0, 0);
    }

    public void layout(IFigure container) {
        Dimension d;
        Rectangle rect = new Rectangle();
        if (this.top != null && this.top.isVisible()) {
            d = this.top.getPreferredSize(-1, -1);
            rect.setLocation(this.calculateLocation(IMarkerConstants.TOP, container, d));
            rect.setSize(d);
            this.top.setBounds(rect);
        }
        if (this.bottom != null && this.bottom.isVisible()) {
            d = this.bottom.getPreferredSize(-1, -1);
            rect.setLocation(this.calculateLocation(IMarkerConstants.BOTTOM, container, d));
            rect.setSize(d);
            this.bottom.setBounds(rect);
        }
        if (this.left != null && this.left.isVisible()) {
            d = this.left.getPreferredSize(-1, -1);
            rect.setLocation(this.calculateLocation(IMarkerConstants.LEFT, container, d));
            rect.setSize(d);
            this.left.setBounds(rect);
        }
        if (this.right != null && this.right.isVisible()) {
            d = this.right.getPreferredSize(-1, -1);
            rect.setLocation(this.calculateLocation(IMarkerConstants.RIGHT, container, d));
            rect.setSize(d);
            this.right.setBounds(rect);
        }
        if (this.center != null && this.center.isVisible()) {
            d = this.center.getPreferredSize(-1, -1);
            rect.setLocation(this.calculateLocation(IMarkerConstants.CENTER, container, d));
            rect.setSize(d);
            this.center.setBounds(rect);
        }
        if (this.topLeft != null && this.topLeft.isVisible()) {
            d = this.topLeft.getPreferredSize(-1, -1);
            rect.setLocation(this.calculateLocation(IMarkerConstants.TOP_LEFT, container, d));
            rect.setSize(d);
            this.topLeft.setBounds(rect);
        }
        if (this.topRight != null && this.topRight.isVisible()) {
            d = this.topRight.getPreferredSize(-1, -1);
            rect.setLocation(this.calculateLocation(IMarkerConstants.TOP_RIGHT, container, d));
            rect.setSize(d);
            this.topRight.setBounds(rect);
        }
        if (this.bottomLeft != null && this.bottomLeft.isVisible()) {
            d = this.bottomLeft.getPreferredSize(-1, -1);
            rect.setLocation(this.calculateLocation(IMarkerConstants.BOTTOM_LEFT, container, d));
            rect.setSize(d);
            this.bottomLeft.setBounds(rect);
        }
        if (this.bottomRight != null && this.bottomRight.isVisible()) {
            d = this.bottomRight.getPreferredSize(-1, -1);
            rect.setLocation(this.calculateLocation(IMarkerConstants.BOTTOM_RIGHT, container, d));
            rect.setSize(d);
            this.bottomRight.setBounds(rect);
        }
    }

    public void remove(IFigure child) {
        if (this.center == child) {
            this.center = null;
        } else if (this.top == child) {
            this.top = null;
        } else if (this.bottom == child) {
            this.bottom = null;
        } else if (this.right == child) {
            this.right = null;
        } else if (this.left == child) {
            this.left = null;
        } else if (this.topLeft == child) {
            this.topLeft = null;
        } else if (this.topRight == child) {
            this.topRight = null;
        } else if (this.bottomLeft == child) {
            this.bottomLeft = null;
        } else if (this.bottomRight == child) {
            this.bottomRight = null;
        }
    }

    public void setConstraint(IFigure child, Object constraint) {
        this.remove(child);
        super.setConstraint(child, constraint);
        if (constraint == null) {
            return;
        }
        switch ((Integer)constraint) {
            case 2: {
                this.center = child;
                break;
            }
            case 8: {
                this.top = child;
                break;
            }
            case 32: {
                this.bottom = child;
                break;
            }
            case 4: {
                this.right = child;
                break;
            }
            case 1: {
                this.left = child;
                break;
            }
            case 9: {
                this.topLeft = child;
                break;
            }
            case 12: {
                this.topRight = child;
                break;
            }
            case 33: {
                this.bottomLeft = child;
                break;
            }
            case 36: {
                this.bottomRight = child;
                break;
            }
        }
    }
}

