/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.build;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IConsoleParser;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.build.CBuildConfiguration;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.dom.ast.gnu.c.GCCLanguage;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.GPPLanguage;
import org.eclipse.cdt.core.envvar.EnvironmentVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.internal.core.build.Messages;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class StandardBuildConfiguration
extends CBuildConfiguration {
    public static final String BUILD_CONTAINER = "stdbuild.build.container";
    public static final String BUILD_COMMAND = "stdbuild.build.command";
    public static final String CLEAN_COMMAND = "stdbuild.clean.command";
    private static final String[] DEFAULT_BUILD_COMMAND = new String[]{"make"};
    private static final String[] DEFAULT_CLEAN_COMMAND = new String[]{"make", "clean"};
    private String[] buildCommand = DEFAULT_BUILD_COMMAND;
    private String[] cleanCommand = DEFAULT_CLEAN_COMMAND;
    private IContainer buildContainer;
    private IEnvironmentVariable[] envVars;

    public StandardBuildConfiguration(IBuildConfiguration config, String name) throws CoreException {
        super(config, name);
        this.applyProperties();
        this.setupEnvVars();
    }

    public StandardBuildConfiguration(IBuildConfiguration config, String name, IToolChain toolChain, String launchMode) throws CoreException {
        super(config, name, toolChain, launchMode);
        this.setupEnvVars();
    }

    private void applyProperties() {
        String buildCmd;
        String container = this.getProperty(BUILD_CONTAINER);
        if (container != null && !container.trim().isEmpty()) {
            Path containerLoc = new Path(container);
            this.buildContainer = containerLoc.segmentCount() == 1 ? ResourcesPlugin.getWorkspace().getRoot().getProject(containerLoc.segment(0)) : ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)containerLoc);
        }
        this.buildCommand = (buildCmd = this.getProperty(BUILD_COMMAND)) != null && !buildCmd.trim().isEmpty() ? buildCmd.split(" ") : DEFAULT_BUILD_COMMAND;
        String cleanCmd = this.getProperty(CLEAN_COMMAND);
        this.cleanCommand = cleanCmd != null && !cleanCmd.trim().isEmpty() ? cleanCmd.split(" ") : DEFAULT_CLEAN_COMMAND;
    }

    private void setupEnvVars() throws CoreException {
        String mode;
        String[] cxx;
        IToolChain toolchain = this.getToolChain();
        ArrayList<EnvironmentVariable> vars = new ArrayList<EnvironmentVariable>();
        String[] cc = toolchain.getCompileCommands(GCCLanguage.getDefault());
        if (cc != null && cc.length > 0) {
            vars.add(new EnvironmentVariable("CC", cc[0]));
        }
        if ((cxx = toolchain.getCompileCommands(GPPLanguage.getDefault())) != null && cxx.length > 0) {
            vars.add(new EnvironmentVariable("CXX", cxx[0]));
        }
        if ((mode = this.getLaunchMode()) != null && !mode.isEmpty()) {
            vars.add(new EnvironmentVariable("BUILD_MODE", mode));
        }
        this.envVars = vars.toArray(new IEnvironmentVariable[0]);
    }

    @Override
    public IEnvironmentVariable[] getVariables() {
        return this.envVars;
    }

    public void setBuildContainer(IContainer buildContainer) {
        this.buildContainer = buildContainer;
        this.setProperty(BUILD_CONTAINER, buildContainer.getFullPath().toString());
    }

    public void setBuildCommand(String[] buildCommand) {
        if (buildCommand != null) {
            this.buildCommand = buildCommand;
            this.setProperty(BUILD_COMMAND, String.join((CharSequence)" ", buildCommand));
        } else {
            this.buildCommand = DEFAULT_BUILD_COMMAND;
            this.removeProperty(BUILD_COMMAND);
        }
    }

    public void setCleanCommand(String[] cleanCommand) {
        if (cleanCommand != null) {
            this.cleanCommand = cleanCommand;
            this.setProperty(CLEAN_COMMAND, String.join((CharSequence)" ", cleanCommand));
        } else {
            this.cleanCommand = DEFAULT_CLEAN_COMMAND;
            this.removeProperty(CLEAN_COMMAND);
        }
    }

    private void createBuildContainer(IContainer container, IProgressMonitor monitor) throws CoreException {
        IContainer parent = container.getParent();
        if (!(parent instanceof IProject) && !parent.exists()) {
            this.createBuildContainer(parent, monitor);
        }
        if (container instanceof IFolder) {
            ((IFolder)container).create(1025, true, monitor);
        }
    }

    @Override
    public IContainer getBuildContainer() throws CoreException {
        if (this.buildContainer == null) {
            return super.getBuildContainer();
        }
        if (!(this.buildContainer instanceof IProject) && !this.buildContainer.exists()) {
            this.createBuildContainer(this.buildContainer, (IProgressMonitor)new NullProgressMonitor());
        }
        return this.buildContainer != null ? this.buildContainer : super.getBuildContainer();
    }

    public IContainer getDefaultBuildContainer() throws CoreException {
        return super.getBuildContainer();
    }

    @Override
    public String getProperty(String name) {
        String prop = super.getProperty(name);
        if (prop != null) {
            return prop;
        }
        switch (name) {
            case "stdbuild.build.container": {
                try {
                    return this.getBuildContainer().getFullPath().toString();
                }
                catch (CoreException e) {
                    CCorePlugin.log(e.getStatus());
                    return null;
                }
            }
            case "stdbuild.build.command": {
                return String.join((CharSequence)" ", this.buildCommand);
            }
            case "stdbuild.clean.command": {
                return String.join((CharSequence)" ", this.cleanCommand);
            }
        }
        return null;
    }

    @Override
    public boolean setProperties(Map<String, String> properties) {
        if (!super.setProperties(properties)) {
            return false;
        }
        this.applyProperties();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IProject[] build(int kind, Map<String, String> args, IConsole console, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        try {
            project.deleteMarkers("org.eclipse.cdt.core.problem", false, 2);
            ConsoleOutputStream outStream = console.getOutputStream();
            java.nio.file.Path buildDir = this.getBuildDirectory();
            outStream.write(String.format(Messages.StandardBuildConfiguration_0, buildDir.toString()));
            ArrayList<String> command = new ArrayList<String>();
            command.add(this.buildCommand[0]);
            if (!this.getBuildContainer().equals((Object)this.getProject())) {
                java.nio.file.Path makefile = Paths.get(this.getProject().getFile("Makefile").getLocationURI());
                java.nio.file.Path relative = this.getBuildDirectory().relativize(makefile);
                command.add("-f");
                command.add(relative.toString());
            }
            int i = 1;
            while (true) {
                if (i >= this.buildCommand.length) {
                    Throwable throwable = null;
                    Object var10_14 = null;
                    try (ErrorParserManager epm = new ErrorParserManager(project, this.getProject().getLocationURI(), (IMarkerGenerator)this, this.getToolChain().getErrorParserIds());){
                        epm.setOutputStream(console.getOutputStream());
                        console.getOutputStream().write(String.format("%s\n", String.join((CharSequence)" ", command)));
                        Path workingDir = new Path(this.getBuildDirectory().toString());
                        Process p = this.startBuildProcess(command, this.envVars, (IPath)workingDir, console, monitor);
                        if (p == null) {
                            console.getErrorStream().write(String.format(Messages.StandardBuildConfiguration_Failure, ""));
                            return null;
                        }
                        IConsoleParser[] consoleParsers = new IConsoleParser[]{epm, this};
                        this.watchProcess(p, consoleParsers);
                        project.refreshLocal(2, monitor);
                        outStream.write(String.format(Messages.StandardBuildConfiguration_1, epm.getErrorCount(), epm.getWarningCount(), buildDir.toString()));
                        return new IProject[]{project};
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                            throw throwable;
                        }
                        if (throwable == throwable2) throw throwable;
                        throwable.addSuppressed(throwable2);
                        throw throwable;
                    }
                }
                command.add(this.buildCommand[i]);
                ++i;
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", "Building " + project.getName(), (Throwable)e));
        }
    }

    @Override
    public void clean(IConsole console, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        try {
            project.deleteMarkers("org.eclipse.cdt.core.problem", false, 2);
            ConsoleOutputStream outStream = console.getOutputStream();
            java.nio.file.Path buildDir = this.getBuildDirectory();
            outStream.write(String.format(Messages.StandardBuildConfiguration_0, buildDir.toString()));
            ArrayList<String> command = new ArrayList<String>();
            List<String> buildCommand = this.cleanCommand != null ? Arrays.asList(this.cleanCommand) : Arrays.asList(DEFAULT_CLEAN_COMMAND);
            command.add(buildCommand.get(0));
            if (!this.getBuildContainer().equals((Object)this.getProject())) {
                java.nio.file.Path makefile = Paths.get(this.getProject().getFile("Makefile").getLocationURI());
                java.nio.file.Path relative = this.getBuildDirectory().relativize(makefile);
                command.add("-f");
                command.add(relative.toString());
            }
            int i = 1;
            while (i < buildCommand.size()) {
                command.add(buildCommand.get(i));
                ++i;
            }
            outStream.write(String.format("%s\n", String.join((CharSequence)" ", command)));
            Path workingDir = new Path(this.getBuildDirectory().toString());
            Process p = this.startBuildProcess(command, this.envVars, (IPath)workingDir, console, monitor);
            if (p == null) {
                console.getErrorStream().write(String.format(Messages.StandardBuildConfiguration_Failure, ""));
                return;
            }
            this.watchProcess(p, console);
            outStream.write(Messages.CBuildConfiguration_BuildComplete);
            project.refreshLocal(2, monitor);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", "Building " + project.getName(), (Throwable)e));
        }
    }
}

