/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.refactoring.code.flow;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCatchHandler;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTryBlockStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.corext.refactoring.code.flow.LocalVariableIndex;
import org.eclipse.core.runtime.Assert;

public class FlowContext
extends LocalVariableIndex {
    public static final ComputeMode MERGE = new ComputeMode();
    public static final ComputeMode ARGUMENTS = new ComputeMode();
    public static final ComputeMode RETURN_VALUES = new ComputeMode();
    private boolean fConsiderAccessMode;
    private boolean fLoopReentranceMode;
    private ComputeMode fComputeMode;
    private IVariable[] fLocals;
    private final List<ICPPASTCatchHandler[]> fExceptionStack = new ArrayList<ICPPASTCatchHandler[]>(3);

    public FlowContext(IASTFunctionDefinition functionDefinition) {
        super(functionDefinition);
    }

    public void setConsiderAccessMode(boolean b) {
        this.fConsiderAccessMode = b;
    }

    public void setComputeMode(ComputeMode mode) {
        this.fComputeMode = mode;
    }

    void setLoopReentranceMode(boolean b) {
        this.fLoopReentranceMode = b;
    }

    int getArrayLength() {
        return this.getNumLocalVariables();
    }

    boolean considerAccessMode() {
        return this.fConsiderAccessMode;
    }

    boolean isLoopReentranceMode() {
        return this.fLoopReentranceMode;
    }

    boolean computeMerge() {
        return this.fComputeMode == MERGE;
    }

    boolean computeArguments() {
        return this.fComputeMode == ARGUMENTS;
    }

    boolean computeReturnValues() {
        return this.fComputeMode == RETURN_VALUES;
    }

    public IVariable getLocalFromIndex(int index) {
        if (this.fLocals == null || index > this.fLocals.length) {
            return null;
        }
        return this.fLocals[index];
    }

    void manageLocal(IVariable localVariable) {
        int index = this.getIndexFromLocal(localVariable);
        if (index >= 0) {
            if (this.fLocals == null) {
                this.fLocals = new IVariable[this.getNumLocalVariables()];
            }
            this.fLocals[index] = localVariable;
        }
    }

    void pushExceptions(ICPPASTTryBlockStatement node) {
        ICPPASTCatchHandler[] catchHandlers = node.getCatchHandlers();
        this.fExceptionStack.add(catchHandlers);
    }

    void popExceptions() {
        Assert.isTrue((this.fExceptionStack.size() > 0 ? 1 : 0) != 0);
        this.fExceptionStack.remove(this.fExceptionStack.size() - 1);
    }

    boolean isExceptionCaught(IType exceptionType) {
        Iterator<ICPPASTCatchHandler[]> iterator = this.fExceptionStack.iterator();
        while (iterator.hasNext()) {
            ICPPASTCatchHandler[] catchHandlers;
            ICPPASTCatchHandler[] iCPPASTCatchHandlerArray = catchHandlers = iterator.next();
            int n = catchHandlers.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPASTCatchHandler catchHandler = iCPPASTCatchHandlerArray[n2];
                if (catchHandler.isCatchAll()) {
                    return true;
                }
                IASTDeclaration caughtException = catchHandler.getDeclaration();
                if (caughtException instanceof IASTSimpleDeclaration) {
                    IASTDeclarator[] declarators = ((IASTSimpleDeclaration)caughtException).getDeclarators();
                    IType caughtType = CPPVisitor.createType((IASTDeclarator)declarators[0]);
                    while (caughtType != null) {
                        if (!caughtType.isSameType(exceptionType)) continue;
                        return true;
                    }
                }
                ++n2;
            }
        }
        return false;
    }

    private static class ComputeMode {
        private ComputeMode() {
        }
    }
}

