/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.testing.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.testing.Messages;
import org.eclipse.dltk.internal.testing.ui.TestMethodSelectionDialog;
import org.eclipse.dltk.internal.ui.actions.SelectionConverter;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.testing.DLTKTestingMessages;
import org.eclipse.dltk.testing.DLTKTestingPlugin;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;

public class GotoReferencedTestAction
implements IWorkbenchWindowActionDelegate {
    ISelection fSelection;
    IWorkbenchWindow fWorkbench;

    private void run(IStructuredSelection selection) {
        IModelElement[] elements = this.getSelectedElements(selection);
        if (elements.length == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)DLTKTestingMessages.GotoReferencedTestAction_dialog_title, (String)DLTKTestingMessages.GotoReferencedTestAction_dialog_message);
            return;
        }
        try {
            this.run(elements);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)DLTKTestingMessages.GotoReferencedTestAction_dialog_title, (String)DLTKTestingMessages.GotoReferencedTestAction_dialog_error, (IStatus)e.getStatus());
        }
    }

    private void run(ITextSelection ITextSelection2) {
        try {
            int type;
            ScriptEditor editor = this.getActiveEditor();
            if (editor == null) {
                return;
            }
            IModelElement element = SelectionConverter.getElementAtOffset((IEditorPart)editor);
            int n = type = element != null ? element.getElementType() : -1;
            if (type != 9 && type != 7 && (element = SelectionConverter.getElementAtOffset((IEditorPart)editor)) == null) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)DLTKTestingMessages.GotoReferencedTestAction_dialog_title, (String)DLTKTestingMessages.GotoReferencedTestAction_dialog_error_nomethod);
                return;
            }
            this.run((IModelElement[])new IMember[]{(IMember)element});
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)DLTKTestingMessages.GotoReferencedTestAction_dialog_title, (String)DLTKTestingMessages.GotoReferencedTestAction_dialog_error, (IStatus)e.getStatus());
        }
    }

    private void run(IModelElement[] elements) throws PartInitException, ModelException {
        IModelElement element = elements[0];
        TestMethodSelectionDialog dialog = new TestMethodSelectionDialog(this.getShell(), element);
        dialog.setTitle(DLTKTestingMessages.GotoReferencedTestAction_selectdialog_title);
        String msg = Messages.format(DLTKTestingMessages.GotoReferencedTestAction_dialog_select_message, element.getElementName());
        dialog.setMessage(msg);
        if (dialog.open() == 1) {
            return;
        }
        Object result = dialog.getFirstResult();
        if (result == null) {
            return;
        }
        this.openElement((IModelElement)result);
    }

    private void openElement(IModelElement result) throws ModelException, PartInitException {
        IEditorPart part = DLTKUIPlugin.openInEditor((IModelElement)result);
        EditorUtility.revealInEditor((IEditorPart)part, (IModelElement)result);
    }

    private IModelElement[] getSelectedElements(IStructuredSelection selection) {
        List elements = selection.toList();
        int size = elements.size();
        if (size == 0) {
            return new IModelElement[0];
        }
        ArrayList<Object> result = new ArrayList<Object>(size);
        int i = 0;
        while (i < size) {
            Object e = elements.get(i);
            if (e instanceof ISourceModule) {
                ISourceModule unit = (ISourceModule)e;
                IType[] types = new IType[]{};
                try {
                    types = unit.getTypes();
                }
                catch (ModelException modelException) {
                    // empty catch block
                }
                int j = 0;
                while (j < types.length) {
                    result.add(types[j]);
                    ++j;
                }
            } else if (e instanceof IMethod || e instanceof IType || e instanceof IField) {
                result.add((IModelElement)e);
            } else {
                return new IModelElement[0];
            }
            ++i;
        }
        return result.toArray(new IModelElement[result.size()]);
    }

    public void run(IAction action) {
        if (this.fSelection instanceof IStructuredSelection) {
            this.run((IStructuredSelection)this.fSelection);
        } else if (this.fSelection instanceof ITextSelection) {
            this.run((ITextSelection)this.fSelection);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = selection;
        action.setEnabled(this.getActiveEditor() != null);
    }

    private Shell getShell() {
        if (this.fWorkbench != null) {
            return this.fWorkbench.getShell();
        }
        return DLTKTestingPlugin.getActiveWorkbenchShell();
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.fWorkbench = window;
    }

    private ScriptEditor getActiveEditor() {
        IEditorPart editor = this.fWorkbench.getActivePage().getActiveEditor();
        if (editor instanceof ScriptEditor) {
            return (ScriptEditor)editor;
        }
        return null;
    }
}

