/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dawn.graphiti.notifications;

import java.util.List;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.dawn.editors.IDawnEditor;
import org.eclipse.emf.cdo.dawn.gmf.appearance.DawnAppearancer;
import org.eclipse.emf.cdo.dawn.gmf.synchronize.DawnConflictHelper;
import org.eclipse.emf.cdo.dawn.gmf.util.DawnDiagramUpdater;
import org.eclipse.emf.cdo.dawn.graphiti.util.DawnGraphitiUtil;
import org.eclipse.emf.cdo.dawn.helper.DawnEditorHelper;
import org.eclipse.emf.cdo.dawn.notifications.BasicDawnTransactionHandler;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.transaction.CDOTransactionConflictEvent;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.util.InvalidObjectException;
import org.eclipse.emf.cdo.view.CDOViewInvalidationEvent;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.swt.widgets.Display;

public class DawnGraphitiHandler
extends BasicDawnTransactionHandler {
    public DawnGraphitiHandler(IDawnEditor editor) {
        super(editor);
    }

    public void handleViewInvalidationEvent(CDOViewInvalidationEvent event) {
        this.editor.getDawnEditorSupport().refresh();
    }

    public void handleTransactionConflictEvent(CDOTransactionConflictEvent event) {
        CDOTransactionConflictEvent cdoTransactionConflictEvent = event;
        CDOObject cdoObject = cdoTransactionConflictEvent.getConflictingObject();
        EObject element = CDOUtil.getEObject((EObject)cdoObject);
        List<PictogramElement> pictgramElements = DawnGraphitiUtil.getPictgramElements(((DiagramEditor)this.editor).getDiagramTypeProvider().getDiagram(), element);
        GraphicalViewer graphicalViewer = ((DiagramEditor)this.editor).getGraphicalViewer();
        for (PictogramElement pictgramElement : pictgramElements) {
            final EditPart editpart = DawnGraphitiUtil.getEditpart(pictgramElement, (EditPart)graphicalViewer.getRootEditPart());
            if (!DawnConflictHelper.isConflicted((EObject)cdoObject)) continue;
            DawnEditorHelper.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    int typeConflictLocallyDeleted = 1;
                    DawnAppearancer.setEditPartConflicted((EditPart)editpart, (int)typeConflictLocallyDeleted);
                }
            });
        }
    }

    public void modifyingObject(CDOTransaction transaction, CDOObject object, CDOFeatureDelta featureDelta) {
        super.modifyingObject(transaction, object, featureDelta);
        this.editor.getDawnEditorSupport().refresh();
    }

    public void attachingObject(CDOTransaction transaction, CDOObject object) {
        super.attachingObject(transaction, object);
        this.editor.getDawnEditorSupport().refresh();
    }

    public void adjustDeletedEdges(final CDOViewInvalidationEvent e) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                for (CDOObject obj : e.getDetachedObjects()) {
                    final EObject view = CDOUtil.getEObject((EObject)obj);
                    if (!(view instanceof Edge)) continue;
                    EditingDomain editingDomain = ((IEditingDomainProvider)view.eResource().getResourceSet()).getEditingDomain();
                    editingDomain.getCommandStack().execute((Command)new RecordingCommand((TransactionalEditingDomain)editingDomain){

                        protected void doExecute() {
                            try {
                                ((Edge)view).setTarget(null);
                            }
                            catch (InvalidObjectException invalidObjectException) {
                                // empty catch block
                            }
                            try {
                                ((Edge)view).setSource(null);
                            }
                            catch (InvalidObjectException invalidObjectException) {
                                // empty catch block
                            }
                        }
                    });
                }
            }
        });
    }

    private void handleObject(CDOObject dirtyObject) {
        if (dirtyObject.cdoInvalid()) {
            return;
        }
        EObject element = CDOUtil.getEObject((EObject)dirtyObject);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                RootEditPart rootEditPart = ((DiagramEditor)DawnGraphitiHandler.this.editor).getGraphicalViewer().getRootEditPart();
                DawnDiagramUpdater.refreshEditPart((EditPart)rootEditPart);
            }
        });
        if (DawnConflictHelper.isConflicted((EObject)dirtyObject)) {
            return;
        }
    }

    protected void refresh(CDOObject object) {
        DawnDiagramUpdater.refreshEditPart((EditPart)((DiagramEditor)this.editor).getGraphicalViewer().getRootEditPart());
    }
}

