/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.internal.ui.actions.EditingDomainAction;
import org.eclipse.emf.cdo.internal.ui.messages.Messages;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredSelection;

public class AutoReleaseLockExemptionAction
extends EditingDomainAction {
    public static final String ID = "AutoReleaseLockExemption";
    private static final String TITLE = Messages.getString("AutoReleaseLockExemptionAction.1");
    private CDOObject selectedObject;

    public AutoReleaseLockExemptionAction() {
        super(TITLE);
        this.setId(ID);
    }

    public void selectionChanged(IStructuredSelection selection) {
        Object element;
        this.selectedObject = null;
        if (selection != null && selection.size() == 1 && (element = selection.getFirstElement()) instanceof EObject) {
            EObject object = (EObject)element;
            this.selectedObject = CDOUtil.getCDOObject((EObject)object);
        }
    }

    public boolean init() {
        if (this.selectedObject != null && this.selectedObject.cdoWriteLock().isLocked()) {
            CDOTransaction transaction = (CDOTransaction)this.selectedObject.cdoView();
            this.setChecked(transaction.options().isAutoReleaseLocksExemption((EObject)this.selectedObject));
            return true;
        }
        return false;
    }

    @Override
    public void update() {
        this.setEnabled(true);
    }

    protected void doRun(IProgressMonitor progressMonitor) throws Exception {
        if (this.selectedObject != null) {
            CDOTransaction transaction = (CDOTransaction)this.selectedObject.cdoView();
            if (transaction.options().isAutoReleaseLocksExemption((EObject)this.selectedObject)) {
                transaction.options().removeAutoReleaseLocksExemptions(false, new EObject[]{this.selectedObject});
            } else {
                transaction.options().addAutoReleaseLocksExemptions(false, new EObject[]{this.selectedObject});
            }
        }
        this.update();
    }
}

