/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.egit.ui.internal.merge;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ICompareContainer;
import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.compare.IResourceProvider;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.RemoteResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.internal.CompareCoreUtils;
import org.eclipse.egit.core.internal.efs.EgitFileSystem;
import org.eclipse.egit.core.internal.efs.HiddenResources;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCache;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCacheEntry;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffData;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.internal.storage.GitFileRevision;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.merge.MergeInputMode;
import org.eclipse.egit.ui.internal.revision.EditableRevision;
import org.eclipse.egit.ui.internal.revision.FileRevisionTypedElement;
import org.eclipse.egit.ui.internal.revision.GitCompareFileRevisionEditorInput;
import org.eclipse.egit.ui.internal.revision.ResourceEditableRevision;
import org.eclipse.egit.ui.internal.synchronize.compare.LocalNonWorkspaceTypedElement;
import org.eclipse.emf.compare.egit.internal.merge.DirCacheResourceVariantTreeProvider;
import org.eclipse.emf.compare.egit.internal.merge.GitResourceVariantTreeProvider;
import org.eclipse.emf.compare.egit.internal.merge.GitResourceVariantTreeSubscriber;
import org.eclipse.emf.compare.egit.internal.merge.LogicalModels;
import org.eclipse.emf.compare.egit.ui.internal.EMFCompareEGitUIMessages;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.attributes.Attribute;
import org.eclipse.jgit.attributes.Attributes;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberMergeContext;
import org.eclipse.team.core.subscribers.SubscriberResourceMappingContext;
import org.eclipse.team.core.subscribers.SubscriberScopeManager;
import org.eclipse.team.internal.ui.synchronize.EditableSharedDocumentAdapter;
import org.eclipse.team.internal.ui.synchronize.LocalResourceTypedElement;
import org.eclipse.team.ui.mapping.ISynchronizationCompareAdapter;
import org.eclipse.ui.PlatformUI;

public class ModelGitMergeEditorInput
extends CompareEditorInput {
    private static final String LABELPATTERN = "{0} - {1}";
    private static final Image FOLDER_IMAGE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    private static final Image PROJECT_IMAGE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
    private final MergeInputMode mode;
    private final boolean useWorkspace;
    private final boolean useOurs;
    private final IPath[] locations;
    private List<IFile> toDelete;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$jgit$lib$RepositoryState;

    public ModelGitMergeEditorInput(MergeInputMode mode, IPath ... locations) {
        super(new CompareConfiguration());
        this.useWorkspace = !MergeInputMode.STAGE_2.equals((Object)mode);
        this.useOurs = MergeInputMode.MERGED_OURS.equals((Object)mode);
        this.mode = mode;
        this.locations = locations;
        CompareConfiguration config = this.getCompareConfiguration();
        config.setLeftEditable(true);
    }

    public Object getAdapter(Class adapter) {
        Object selectedEdition;
        if ((adapter == IFile.class || adapter == IResource.class) && ModelGitMergeEditorInput.isUIThread() && (selectedEdition = this.getSelectedEdition()) instanceof DiffNode) {
            DiffNode diffNode = (DiffNode)selectedEdition;
            ITypedElement element = diffNode.getLeft();
            IFile resource = null;
            if (element instanceof HiddenResourceTypedElement) {
                resource = ((HiddenResourceTypedElement)element).getRealFile();
            }
            if (element instanceof IResourceProvider) {
                resource = ((IResourceProvider)element).getResource();
            }
            if (resource != null && adapter.isInstance(resource)) {
                return resource;
            }
        }
        return super.getAdapter(adapter);
    }

    private static boolean isUIThread() {
        return Display.getCurrent() != null;
    }

    /*
     * Exception decompiling
     */
    protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void checkCanceled(IProgressMonitor monitor) throws InterruptedException {
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
    }

    private ICompareInput prepareCompareInput(Repository repository, List<String> filterPaths, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            DirCacheResourceVariantTreeProvider variantTreeProvider = new DirCacheResourceVariantTreeProvider(repository, this.useWorkspace);
            GitResourceVariantTreeSubscriber subscriber = new GitResourceVariantTreeSubscriber((GitResourceVariantTreeProvider)variantTreeProvider);
            this.checkCanceled(monitor);
            LinkedHashSet<IProject> projects = new LinkedHashSet<IProject>();
            IResource[] iResourceArray = subscriber.roots();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource root = iResourceArray[n2];
                projects.add(root.getProject());
                ++n2;
            }
            LinkedHashSet<IResource> resourcesInOperation = new LinkedHashSet<IResource>();
            boolean outOfWS = false;
            IPath[] iPathArray = this.locations;
            int n3 = this.locations.length;
            int n4 = 0;
            while (n4 < n3) {
                IPath path = iPathArray[n4];
                boolean foundMatchInWS = false;
                Iterator projectIterator = projects.iterator();
                while (!foundMatchInWS && projectIterator.hasNext()) {
                    IProject project = (IProject)projectIterator.next();
                    IPath projectLocation = project.getLocation();
                    if (projectLocation.equals((Object)path)) {
                        resourcesInOperation.addAll(this.getConflictingFilesFrom((IContainer)project));
                        foundMatchInWS = true;
                        continue;
                    }
                    if (!project.getLocation().isPrefixOf(path)) continue;
                    IResource resource = ResourceUtil.getResourceForLocation((IPath)path, (boolean)false);
                    if (resource instanceof IContainer) {
                        resourcesInOperation.addAll(this.getConflictingFilesFrom((IContainer)resource));
                    } else {
                        resourcesInOperation.add(resource);
                    }
                    foundMatchInWS = true;
                }
                if (!foundMatchInWS) {
                    if (!resourcesInOperation.isEmpty()) break;
                    outOfWS = true;
                } else if (outOfWS) break;
                ++n4;
            }
            this.checkCanceled(monitor);
            if (!resourcesInOperation.isEmpty() && outOfWS) {
                throw new InvocationTargetException(new IllegalStateException(EMFCompareEGitUIMessages.getString("GitMergeEditorInput_OutOfWSResources")));
            }
            if (!resourcesInOperation.isEmpty()) {
                ISynchronizationCompareAdapter compareAdapter;
                SubscriberResourceMappingContext remoteMappingContext = new SubscriberResourceMappingContext((Subscriber)subscriber, true);
                Set model = null;
                for (IResource comparedResource : resourcesInOperation) {
                    model = LogicalModels.discoverModel((IResource)comparedResource, (ResourceMappingContext)remoteMappingContext);
                    if (model.isEmpty()) continue;
                    if (model.containsAll(resourcesInOperation)) break;
                    throw new RuntimeException(EMFCompareEGitUIMessages.getString("GitMergeEditorInput_MultipleModels"));
                }
                if ((compareAdapter = (ISynchronizationCompareAdapter)LogicalModels.findAdapter(model, ISynchronizationCompareAdapter.class)) != null) {
                    Set allMappings = LogicalModels.getResourceMappings((Set)model, (ResourceMappingContext)remoteMappingContext);
                    this.checkCanceled(monitor);
                    ISynchronizationContext synchronizationContext = this.prepareSynchronizationContext(repository, (Subscriber)subscriber, allMappings, (RemoteResourceMappingContext)remoteMappingContext);
                    Object modelObject = ((ResourceMapping)allMappings.iterator().next()).getModelObject();
                    if (compareAdapter.hasCompareInput(synchronizationContext, modelObject)) {
                        return compareAdapter.asCompareInput(synchronizationContext, modelObject);
                    }
                }
            }
        }
        catch (IOException | CoreException e) {
            throw new InvocationTargetException(e);
        }
        return null;
    }

    private Set<IResource> getConflictingFilesFrom(IContainer container) throws IOException {
        LinkedHashSet<IResource> conflictingResources = new LinkedHashSet<IResource>();
        RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)container);
        if (mapping == null) {
            return conflictingResources;
        }
        IndexDiffCacheEntry indexDiffCacheEntry = IndexDiffCache.getInstance().getIndexDiffCacheEntry(mapping.getRepository());
        if (indexDiffCacheEntry == null) {
            return conflictingResources;
        }
        IndexDiffData indexDiffData = indexDiffCacheEntry.getIndexDiff();
        if (indexDiffData != null) {
            IPath containerPath = container.getLocation();
            File workTree = mapping.getWorkTree();
            if (workTree != null) {
                Path workDirPrefix = new Path(workTree.getCanonicalPath());
                for (String conflicting : indexDiffData.getConflicting()) {
                    IPath resourcePath = workDirPrefix.append(conflicting);
                    if (!containerPath.isPrefixOf(resourcePath)) continue;
                    IPath containerRelativePath = resourcePath.removeFirstSegments(containerPath.segmentCount());
                    conflictingResources.add((IResource)container.getFile(containerRelativePath));
                }
            }
        }
        return conflictingResources;
    }

    private ISynchronizationContext prepareSynchronizationContext(Repository repository, Subscriber subscriber, Set<ResourceMapping> allModelMappings, RemoteResourceMappingContext mappingContext) throws CoreException, OperationCanceledException, InterruptedException {
        ResourceMapping[] mappings = allModelMappings.toArray(new ResourceMapping[allModelMappings.size()]);
        InternalSubscriberScopeManager manager = new InternalSubscriberScopeManager(subscriber.getName(), mappings, subscriber, mappingContext, true, repository);
        manager.initialize((IProgressMonitor)new NullProgressMonitor());
        GitSynchronizationContext context = new GitSynchronizationContext(subscriber, (ISynchronizationScopeManager)manager);
        Job.getJobManager().join((Object)context, (IProgressMonitor)new NullProgressMonitor());
        return context;
    }

    private RevCommit getLeftCommit(RevWalk revWalk, Repository repository) throws InvocationTargetException {
        try {
            ObjectId head = repository.resolve("HEAD");
            if (head == null) {
                throw new IOException(NLS.bind((String)EMFCompareEGitUIMessages.getString("ValidationUtils_CanNotResolveRefMessage"), (Object)"HEAD"));
            }
            return revWalk.parseCommit((AnyObjectId)head);
        }
        catch (IOException e) {
            throw new InvocationTargetException(e);
        }
    }

    private void setLabels(Repository repository, RevCommit rightCommit, RevCommit leftCommit, RevCommit ancestorCommit, boolean unknownAncestor) throws InvocationTargetException {
        String fullBranch;
        CompareConfiguration config = this.getCompareConfiguration();
        config.setRightLabel(NLS.bind((String)LABELPATTERN, (Object)rightCommit.getShortMessage(), (Object)CompareUtils.truncatedRevision((String)rightCommit.name())));
        if (!this.useWorkspace) {
            config.setLeftLabel(NLS.bind((String)LABELPATTERN, (Object)leftCommit.getShortMessage(), (Object)CompareUtils.truncatedRevision((String)leftCommit.name())));
        } else if (this.useOurs) {
            config.setLeftLabel(UIText.GitMergeEditorInput_WorkspaceOursHeader);
        } else {
            config.setLeftLabel(UIText.GitMergeEditorInput_WorkspaceHeader);
        }
        if (ancestorCommit != null) {
            config.setAncestorLabel(NLS.bind((String)LABELPATTERN, (Object)ancestorCommit.getShortMessage(), (Object)CompareUtils.truncatedRevision((String)ancestorCommit.name())));
        } else if (unknownAncestor) {
            config.setAncestorLabel(NLS.bind((String)UIText.GitMergeEditorInput_AncestorUnknownHeader, (Object)CompareUtils.truncatedRevision((String)rightCommit.name())));
        }
        try {
            fullBranch = repository.getFullBranch();
        }
        catch (IOException e) {
            throw new InvocationTargetException(e);
        }
        this.setTitle(NLS.bind((String)UIText.GitMergeEditorInput_MergeEditorTitle, (Object[])new Object[]{RepositoryUtil.getInstance().getRepositoryName(repository), rightCommit.getShortMessage(), fullBranch}));
    }

    protected void contentsCreated() {
        super.contentsCreated();
        this.getNavigator().selectChange(true);
    }

    protected void handleDispose() {
        super.handleDispose();
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ModelGitMergeEditorInput.this.cleanUp();
            }
        });
    }

    private void cleanUp() {
        if (this.toDelete == null || this.toDelete.isEmpty()) {
            return;
        }
        final List<IFile> toClean = this.toDelete;
        this.toDelete = null;
        Job job = new Job(UIText.GitMergeEditorInput_ResourceCleanupJobName){

            public boolean shouldSchedule() {
                return super.shouldSchedule() && !PlatformUI.getWorkbench().isClosing();
            }

            public boolean shouldRun() {
                return super.shouldRun() && !PlatformUI.getWorkbench().isClosing();
            }

            protected IStatus run(IProgressMonitor monitor) {
                IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor m) throws CoreException {
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)m, (int)toClean.size());
                        for (IFile tmp : toClean) {
                            if (PlatformUI.getWorkbench().isClosing()) {
                                return;
                            }
                            try {
                                tmp.delete(true, (IProgressMonitor)progress.newChild(1));
                            }
                            catch (CoreException coreException) {
                                // empty catch block
                            }
                        }
                    }
                };
                try {
                    ResourcesPlugin.getWorkspace().run(runnable, null, 1, monitor);
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setUser(false);
        job.schedule();
    }

    private IDiffContainer buildDiffContainer(final Repository repository, RevCommit headCommit, RevCommit ancestorCommit, List<String> filterPaths, RevWalk rw, IProgressMonitor monitor) throws IOException, InterruptedException {
        monitor.setTaskName(UIText.GitMergeEditorInput_CalculatingDiffTaskName);
        DiffNode result = new DiffNode(12);
        MergeCommand.ConflictStyle style = null;
        try {
            Throwable throwable = null;
            Object var10_12 = null;
            try (TreeWalk tw = new TreeWalk(repository);){
                int dirCacheIndex = tw.addTree((AbstractTreeIterator)new DirCacheIterator(repository.readDirCache()));
                FileTreeIterator fIter = new FileTreeIterator(repository);
                int fileTreeIndex = tw.addTree((AbstractTreeIterator)fIter);
                fIter.setDirCacheIterator(tw, dirCacheIndex);
                int repositoryTreeIndex = tw.addTree((AnyObjectId)rw.parseTree((AnyObjectId)repository.resolve("HEAD")));
                if (!filterPaths.isEmpty()) {
                    if (filterPaths.size() > 1) {
                        tw.setFilter(PathFilterGroup.createFromStrings(filterPaths));
                    } else {
                        String path = filterPaths.get(0);
                        if (!path.isEmpty()) {
                            tw.setFilter(PathFilterGroup.createFromStrings((String[])new String[]{path}));
                        }
                    }
                }
                tw.setRecursive(true);
                while (tw.next()) {
                    ResourceEditableRevision left;
                    boolean useWorkingTree;
                    ITypedElement right;
                    boolean modified;
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    final String gitPath = tw.getPathString();
                    monitor.setTaskName(gitPath);
                    FileTreeIterator fit = (FileTreeIterator)tw.getTree(fileTreeIndex, FileTreeIterator.class);
                    if (fit == null) continue;
                    DirCacheIterator dit = (DirCacheIterator)tw.getTree(dirCacheIndex, DirCacheIterator.class);
                    DirCacheEntry dirCacheEntry = dit == null ? null : dit.getDirCacheEntry();
                    boolean conflicting = dirCacheEntry != null && dirCacheEntry.getStage() > 0;
                    AbstractTreeIterator rt = tw.getTree(repositoryTreeIndex, AbstractTreeIterator.class);
                    boolean bl = modified = rt != null && !fit.getEntryObjectId().equals((AnyObjectId)rt.getEntryObjectId());
                    if (!conflicting && !modified) continue;
                    String encoding = null;
                    if (conflicting) {
                        GitFileRevision revision = GitFileRevision.inIndex((Repository)repository, (String)gitPath, (int)3);
                        encoding = CompareCoreUtils.getResourceEncoding((Repository)repository, (String)gitPath);
                        right = new FileRevisionTypedElement((IFileRevision)revision, encoding);
                    } else {
                        right = CompareUtils.getFileRevisionTypedElement((String)gitPath, (RevCommit)headCommit, (Repository)repository);
                    }
                    if (right instanceof GitCompareFileRevisionEditorInput.EmptyTypedElement) continue;
                    Path repositoryPath = new Path(repository.getWorkTree().getAbsolutePath());
                    IPath location = repositoryPath.append(gitPath);
                    assert (location != null);
                    final IFile file = ResourceUtil.getFileForLocation((IPath)location, (boolean)false);
                    boolean bl2 = useWorkingTree = !conflicting || this.useWorkspace;
                    if (!useWorkingTree && conflicting && dirCacheEntry != null) {
                        boolean bl3 = useWorkingTree = !Instant.EPOCH.equals(dirCacheEntry.getLastModifiedInstant());
                    }
                    if (useWorkingTree) {
                        Object item;
                        Attribute markerSize;
                        Attributes attributes;
                        boolean useOursFilter = conflicting && this.useOurs;
                        int conflictMarkerSize = 7;
                        if (useOursFilter && (useOursFilter = (attributes = tw.getAttributes()).canBeContentMerged()) && (markerSize = attributes.get("conflict-marker-size")) != null && Attribute.State.CUSTOM.equals((Object)markerSize.getState())) {
                            try {
                                conflictMarkerSize = Integer.parseUnsignedInt(markerSize.getValue());
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (useOursFilter) {
                            boolean useDiff3Style;
                            if (style == null) {
                                style = (MergeCommand.ConflictStyle)repository.getConfig().getEnum("merge", null, "conflictStyle", (Enum)MergeCommand.ConflictStyle.MERGE);
                            }
                            String filter = String.valueOf((useDiff3Style = MergeCommand.ConflictStyle.DIFF3.equals(style)) ? (char)'O' : 'o') + Integer.toString(conflictMarkerSize);
                            URI uri = EgitFileSystem.createURI((Repository)repository, (String)gitPath, (String)("WORKTREE:" + filter));
                            Charset rscEncoding = null;
                            if (file != null) {
                                if (encoding == null) {
                                    encoding = CompareCoreUtils.getResourceEncoding((IResource)file);
                                }
                                try {
                                    rscEncoding = Charset.forName(encoding);
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    // empty catch block
                                }
                            }
                            item = this.createWithHiddenResource(uri, tw.getNameString(), file, rscEncoding);
                            if (file != null) {
                                item.setSharedDocumentListener((EditableSharedDocumentAdapter.ISharedDocumentAdapterListener)new LocalResourceSaver((LocalResourceTypedElement)item){

                                    @Override
                                    protected void save() throws CoreException {
                                        super.save();
                                        file.refreshLocal(0, null);
                                    }
                                });
                            } else {
                                item.setSharedDocumentListener((EditableSharedDocumentAdapter.ISharedDocumentAdapterListener)new LocalResourceSaver((LocalResourceTypedElement)item));
                            }
                        } else {
                            item = file != null ? new LocalResourceTypedElement((IResource)file) : new LocalNonWorkspaceTypedElement(repository, location);
                            item.setSharedDocumentListener((EditableSharedDocumentAdapter.ISharedDocumentAdapterListener)new LocalResourceSaver((LocalResourceTypedElement)item));
                        }
                        left = item;
                    } else {
                        IFile rsc;
                        IFile iFile = rsc = file != null ? file : this.createHiddenResource(location.toFile().toURI(), tw.getNameString(), null);
                        assert (rsc != null);
                        GitFileRevision rev = GitFileRevision.inIndex((Repository)repository, (String)gitPath, (int)2);
                        ICompareContainer runnableContext = this.getContainer();
                        if (runnableContext == null) {
                            runnableContext = PlatformUI.getWorkbench().getProgressService();
                            assert (runnableContext != null);
                        }
                        left = new ResourceEditableRevision((IFileRevision)rev, rsc, (IRunnableContext)runnableContext);
                        ((EditableRevision)left).addContentChangeListener(new IContentChangeListener(){

                            public void contentChanged(IContentChangeNotifier source) {
                                ModelGitMergeEditorInput.this.updateIndexTimestamp(repository, gitPath);
                            }
                        });
                        try {
                            ((EditableRevision)left).cacheContents(monitor);
                        }
                        catch (CoreException e) {
                            throw new IOException(e.getMessage(), e);
                        }
                    }
                    int kind = 0;
                    if (conflicting) {
                        kind = 12;
                    } else if (modified) {
                        kind = 16;
                    }
                    IDiffContainer fileParent = this.getFileParent((IDiffContainer)result, (IPath)repositoryPath, file, location);
                    ITypedElement ancestor = null;
                    if (ancestorCommit != null) {
                        ancestor = CompareUtils.getFileRevisionTypedElement((String)gitPath, (RevCommit)ancestorCommit, (Repository)repository);
                    }
                    if (ancestor instanceof GitCompareFileRevisionEditorInput.EmptyTypedElement) {
                        ancestor = null;
                    }
                    new DiffNode(fileParent, kind, ancestor, (ITypedElement)left, right);
                }
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (URISyntaxException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private LocalResourceTypedElement createWithHiddenResource(URI uri, String name, IFile file, Charset encoding) throws IOException {
        IFile tmp = this.createHiddenResource(uri, name, encoding);
        return new HiddenResourceTypedElement(tmp, file);
    }

    private IFile createHiddenResource(URI uri, String name, Charset encoding) throws IOException {
        try {
            IFile tmp = HiddenResources.INSTANCE.createFile(uri, name, encoding, null);
            if (this.toDelete == null) {
                this.toDelete = new ArrayList<IFile>();
            }
            this.toDelete.add(tmp);
            return tmp;
        }
        catch (CoreException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private void updateIndexTimestamp(Repository repository, String gitPath) {
        DirCache cache = null;
        try {
            try {
                cache = repository.lockDirCache();
                DirCacheEditor editor = cache.editor();
                editor.add(new DirCacheEditor.PathEdit(gitPath){
                    private boolean done;

                    public void apply(DirCacheEntry ent) {
                        if (!this.done && ent.getStage() > 0) {
                            ent.setLastModified(Instant.now());
                            this.done = true;
                        }
                    }
                });
                editor.commit();
            }
            catch (IOException e) {
                Activator.logError((String)MessageFormat.format(UIText.GitMergeEditorInput_ErrorUpdatingIndex, gitPath), (Throwable)e);
                if (cache != null) {
                    cache.unlock();
                }
            }
        }
        finally {
            if (cache != null) {
                cache.unlock();
            }
        }
    }

    private IDiffContainer getFileParent(IDiffContainer root, IPath repositoryPath, IFile file, IPath location) {
        IProject project;
        IPath projectLocation;
        int projectSegment = -1;
        String projectName = null;
        if (file != null && (projectLocation = (project = file.getProject()).getLocation()) != null) {
            IPath projectPath = project.getLocation().makeRelativeTo(repositoryPath);
            projectSegment = projectPath.segmentCount() - 1;
            projectName = project.getName();
        }
        IPath path = location.makeRelativeTo(repositoryPath);
        IDiffContainer child = root;
        int i = 0;
        while (i < path.segmentCount() - 1) {
            child = i == projectSegment ? this.getOrCreateChild(child, projectName, true) : this.getOrCreateChild(child, path.segment(i), false);
            ++i;
        }
        return child;
    }

    private DiffNode getOrCreateChild(IDiffContainer parent, final String name, final boolean projectMode) {
        Object child;
        IDiffElement[] iDiffElementArray = parent.getChildren();
        int n = iDiffElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            child = iDiffElementArray[n2];
            if (child.getName().equals(name)) {
                return (DiffNode)child;
            }
            ++n2;
        }
        child = new DiffNode(parent, 0){

            public String getName() {
                return name;
            }

            public Image getImage() {
                if (projectMode) {
                    return PROJECT_IMAGE;
                }
                return FOLDER_IMAGE;
            }
        };
        return child;
    }

    private String readFile(File directory, String fileName) throws IOException {
        byte[] content = IO.readFully((File)new File(directory, fileName));
        int end = content.length;
        while (end > 0 && content[end - 1] == 10) {
            --end;
        }
        return RawParseUtils.decode((byte[])content, (int)0, (int)end);
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$jgit$lib$RepositoryState() {
        if ($SWITCH_TABLE$org$eclipse$jgit$lib$RepositoryState != null) {
            return $SWITCH_TABLE$org$eclipse$jgit$lib$RepositoryState;
        }
        int[] nArray = new int[RepositoryState.values().length];
        try {
            nArray[RepositoryState.APPLY.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RepositoryState.BARE.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RepositoryState.BISECTING.ordinal()] = 14;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RepositoryState.CHERRY_PICKING.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RepositoryState.CHERRY_PICKING_RESOLVED.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RepositoryState.MERGING.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RepositoryState.MERGING_RESOLVED.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RepositoryState.REBASING.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RepositoryState.REBASING_INTERACTIVE.ordinal()] = 13;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RepositoryState.REBASING_MERGE.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RepositoryState.REBASING_REBASING.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RepositoryState.REVERTING.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RepositoryState.REVERTING_RESOLVED.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RepositoryState.SAFE.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$eclipse$jgit$lib$RepositoryState = nArray;
        return nArray;
    }

    private static class GitSynchronizationContext
    extends SubscriberMergeContext {
        public GitSynchronizationContext(Subscriber subscriber, ISynchronizationScopeManager scopeManager) {
            super(subscriber, scopeManager);
            this.initialize();
        }

        public void markAsMerged(IDiff node, boolean inSyncHint, IProgressMonitor monitor) throws CoreException {
        }

        public void reject(IDiff diff, IProgressMonitor monitor) throws CoreException {
        }

        protected void makeInSync(IDiff diff, IProgressMonitor monitor) throws CoreException {
        }

        public void dispose() {
            super.dispose();
        }
    }

    private static class HiddenResourceTypedElement
    extends LocalResourceTypedElement {
        private final IFile realFile;

        public HiddenResourceTypedElement(IFile file, IFile realFile) {
            super((IResource)file);
            this.realFile = realFile;
        }

        public IFile getRealFile() {
            return this.realFile;
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        public int hashCode() {
            return super.hashCode();
        }
    }

    private static final class InternalSubscriberScopeManager
    extends SubscriberScopeManager {
        private final Repository repository;

        public InternalSubscriberScopeManager(String name, ResourceMapping[] inputMappings, Subscriber subscriber, RemoteResourceMappingContext context, boolean consultModels, Repository repository) {
            super(name, inputMappings, subscriber, context, consultModels);
            this.repository = repository;
        }

        public ISchedulingRule getSchedulingRule() {
            return RuleUtil.getRule((Repository)this.repository);
        }
    }

    private static class LocalResourceSaver
    implements EditableSharedDocumentAdapter.ISharedDocumentAdapterListener {
        LocalResourceTypedElement element;

        public LocalResourceSaver(LocalResourceTypedElement element) {
            this.element = element;
        }

        protected void save() throws CoreException {
            this.element.saveDocument(true, null);
            this.refreshIndexDiff();
        }

        private void refreshIndexDiff() {
            IResource resource = this.element.getResource();
            if (resource != null && HiddenResources.INSTANCE.isHiddenProject((IResource)resource.getProject())) {
                IndexDiffCacheEntry indexDiffCacheForRepository;
                String gitPath = null;
                Repository repository = null;
                URI uri = resource.getLocationURI();
                if ("file".equals(uri.getScheme())) {
                    Path location = new Path(uri.getSchemeSpecificPart());
                    repository = ResourceUtil.getRepository((IPath)location);
                    if (repository != null && (location = ResourceUtil.getRepositoryRelativePath((IPath)location, (Repository)repository)) != null) {
                        gitPath = location.toPortableString();
                    }
                } else {
                    repository = HiddenResources.INSTANCE.getRepository(uri);
                    if (repository != null) {
                        gitPath = HiddenResources.INSTANCE.getGitPath(uri);
                    }
                }
                if (gitPath != null && repository != null && (indexDiffCacheForRepository = IndexDiffCache.getInstance().getIndexDiffCacheEntry(repository)) != null) {
                    indexDiffCacheForRepository.refreshFiles(Collections.singletonList(gitPath));
                }
            }
        }

        public void handleDocumentConnected() {
        }

        public void handleDocumentDisconnected() {
        }

        public void handleDocumentFlushed() {
            try {
                this.save();
            }
            catch (CoreException e) {
                Activator.handleStatus((IStatus)e.getStatus(), (boolean)true);
            }
        }

        public void handleDocumentDeleted() {
        }

        public void handleDocumentSaved() {
        }
    }
}

