/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.binary;

import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jpt.common.core.internal.resource.java.binary.BinaryAnnotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.RelationshipMappingAnnotation2_0;
import org.eclipse.jpt.jpa.core.resource.java.CascadeType;
import org.eclipse.jpt.jpa.core.resource.java.FetchType;

abstract class BinaryRelationshipMappingAnnotation
extends BinaryAnnotation
implements RelationshipMappingAnnotation2_0 {
    String targetEntity = this.buildTargetEntity();
    FetchType fetch = this.buildFetch();
    boolean cascadeAll;
    boolean cascadeMerge;
    boolean cascadePersist;
    boolean cascadeRefresh;
    boolean cascadeRemove;
    boolean cascadeDetach;

    BinaryRelationshipMappingAnnotation(JavaResourceAnnotatedElement parent, IAnnotation jdtAnnotation) {
        super((JavaResourceModel)parent, jdtAnnotation);
        this.initializeCascadeTypes(this.buildCascadeTypes());
    }

    protected void initializeCascadeTypes(CascadeType[] cascadeTypes) {
        this.cascadeAll = ArrayTools.contains((Object[])cascadeTypes, (Object)((Object)CascadeType.ALL));
        this.cascadeMerge = ArrayTools.contains((Object[])cascadeTypes, (Object)((Object)CascadeType.MERGE));
        this.cascadePersist = ArrayTools.contains((Object[])cascadeTypes, (Object)((Object)CascadeType.PERSIST));
        this.cascadeRefresh = ArrayTools.contains((Object[])cascadeTypes, (Object)((Object)CascadeType.REFRESH));
        this.cascadeRemove = ArrayTools.contains((Object[])cascadeTypes, (Object)((Object)CascadeType.REMOVE));
        this.cascadeDetach = ArrayTools.contains((Object[])cascadeTypes, (Object)((Object)CascadeType.DETACH));
    }

    public void update() {
        super.update();
        this.setTargetEntity_(this.buildTargetEntity());
        this.setFetch_(this.buildFetch());
        this.updateCascadeTypes(this.buildCascadeTypes());
    }

    protected void updateCascadeTypes(CascadeType[] cascadeTypes) {
        this.setCascadeAll_(ArrayTools.contains((Object[])cascadeTypes, (Object)((Object)CascadeType.ALL)));
        this.setCascadeMerge_(ArrayTools.contains((Object[])cascadeTypes, (Object)((Object)CascadeType.MERGE)));
        this.setCascadePersist_(ArrayTools.contains((Object[])cascadeTypes, (Object)((Object)CascadeType.PERSIST)));
        this.setCascadeRefresh_(ArrayTools.contains((Object[])cascadeTypes, (Object)((Object)CascadeType.REFRESH)));
        this.setCascadeRemove_(ArrayTools.contains((Object[])cascadeTypes, (Object)((Object)CascadeType.REMOVE)));
        this.setCascadeDetach_(ArrayTools.contains((Object[])cascadeTypes, (Object)((Object)CascadeType.DETACH)));
    }

    @Override
    public String getTargetEntity() {
        return this.targetEntity;
    }

    @Override
    public void setTargetEntity(String targetEntity) {
        throw new UnsupportedOperationException();
    }

    private void setTargetEntity_(String targetEntity) {
        String old = this.targetEntity;
        this.targetEntity = targetEntity;
        this.firePropertyChanged("targetEntity", old, targetEntity);
    }

    private String buildTargetEntity() {
        return (String)this.getJdtMemberValue(this.getTargetEntityElementName());
    }

    abstract String getTargetEntityElementName();

    @Override
    public TextRange getTargetEntityTextRange() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getFullyQualifiedTargetEntityClassName() {
        return this.targetEntity;
    }

    @Override
    public FetchType getFetch() {
        return this.fetch;
    }

    @Override
    public void setFetch(FetchType fetch) {
        throw new UnsupportedOperationException();
    }

    private void setFetch_(FetchType fetch) {
        FetchType old = this.fetch;
        this.fetch = fetch;
        this.firePropertyChanged("fetch", (Object)old, (Object)fetch);
    }

    private FetchType buildFetch() {
        return FetchType.fromJavaAnnotationValue(this.getJdtMemberValue(this.getFetchElementName()));
    }

    abstract String getFetchElementName();

    @Override
    public TextRange getFetchTextRange() {
        throw new UnsupportedOperationException();
    }

    private CascadeType[] buildCascadeTypes() {
        return CascadeType.fromJavaAnnotationValues(this.getJdtMemberValues(this.getCascadeElementName()));
    }

    abstract String getCascadeElementName();

    @Override
    public TextRange getCascadeTextRange() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCascadeAll() {
        return this.cascadeAll;
    }

    @Override
    public void setCascadeAll(boolean cascadeAll) {
        throw new UnsupportedOperationException();
    }

    private void setCascadeAll_(boolean cascadeAll) {
        boolean old = this.cascadeAll;
        this.cascadeAll = cascadeAll;
        this.firePropertyChanged("cascadeAll", old, cascadeAll);
    }

    @Override
    public boolean isCascadeMerge() {
        return this.cascadeMerge;
    }

    @Override
    public void setCascadeMerge(boolean cascadeMerge) {
        throw new UnsupportedOperationException();
    }

    private void setCascadeMerge_(boolean cascadeMerge) {
        boolean old = this.cascadeMerge;
        this.cascadeMerge = cascadeMerge;
        this.firePropertyChanged("cascadeMerge", old, cascadeMerge);
    }

    @Override
    public boolean isCascadePersist() {
        return this.cascadePersist;
    }

    @Override
    public void setCascadePersist(boolean cascadePersist) {
        throw new UnsupportedOperationException();
    }

    private void setCascadePersist_(boolean cascadePersist) {
        boolean old = this.cascadePersist;
        this.cascadePersist = cascadePersist;
        this.firePropertyChanged("cascadePersist", old, cascadePersist);
    }

    @Override
    public boolean isCascadeRefresh() {
        return this.cascadeRefresh;
    }

    @Override
    public void setCascadeRefresh(boolean cascadeRefresh) {
        throw new UnsupportedOperationException();
    }

    private void setCascadeRefresh_(boolean cascadeRefresh) {
        boolean old = this.cascadeRefresh;
        this.cascadeRefresh = cascadeRefresh;
        this.firePropertyChanged("cascadeRefresh", old, cascadeRefresh);
    }

    @Override
    public boolean isCascadeRemove() {
        return this.cascadeRemove;
    }

    @Override
    public void setCascadeRemove(boolean cascadeRemove) {
        throw new UnsupportedOperationException();
    }

    private void setCascadeRemove_(boolean cascadeRemove) {
        boolean old = this.cascadeRemove;
        this.cascadeRemove = cascadeRemove;
        this.firePropertyChanged("cascadeRemove", old, cascadeRemove);
    }

    @Override
    public boolean isCascadeDetach() {
        return this.cascadeDetach;
    }

    @Override
    public void setCascadeDetach(boolean cascadeDetach) {
        throw new UnsupportedOperationException();
    }

    private void setCascadeDetach_(boolean cascadeDetach) {
        boolean old = this.cascadeDetach;
        this.cascadeDetach = cascadeDetach;
        this.firePropertyChanged("cascadeDetach", old, cascadeDetach);
    }
}

