/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.Query;
import org.apache.maven.index.ArtifactContext;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.Field;
import org.apache.maven.index.FlatSearchRequest;
import org.apache.maven.index.FlatSearchResponse;
import org.apache.maven.index.GroupedSearchRequest;
import org.apache.maven.index.GroupedSearchResponse;
import org.apache.maven.index.Indexer;
import org.apache.maven.index.IndexerEngine;
import org.apache.maven.index.IteratorSearchRequest;
import org.apache.maven.index.IteratorSearchResponse;
import org.apache.maven.index.MAVEN;
import org.apache.maven.index.QueryCreator;
import org.apache.maven.index.SearchEngine;
import org.apache.maven.index.SearchType;
import org.apache.maven.index.context.ContextMemberProvider;
import org.apache.maven.index.context.DefaultIndexingContext;
import org.apache.maven.index.context.ExistingLuceneIndexMismatchException;
import org.apache.maven.index.context.IndexCreator;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.index.context.MergedIndexingContext;
import org.apache.maven.index.expr.SearchExpression;
import org.apache.maven.index.expr.SearchTypedStringSearchExpression;
import org.apache.maven.index.expr.SourcedSearchExpression;
import org.apache.maven.index.util.IndexCreatorSorter;

@Singleton
@Named
public class DefaultIndexer
implements Indexer {
    private final SearchEngine searcher;
    private final IndexerEngine indexerEngine;
    private final QueryCreator queryCreator;
    private static final char[] DIGITS = "0123456789abcdef".toCharArray();

    @Inject
    public DefaultIndexer(SearchEngine searcher, IndexerEngine indexerEngine, QueryCreator queryCreator) {
        this.searcher = searcher;
        this.indexerEngine = indexerEngine;
        this.queryCreator = queryCreator;
    }

    @Override
    public IndexingContext createIndexingContext(String id, String repositoryId, File repository, File indexDirectory, String repositoryUrl, String indexUpdateUrl, boolean searchable, boolean reclaim, List<? extends IndexCreator> indexers) throws IOException, ExistingLuceneIndexMismatchException, IllegalArgumentException {
        DefaultIndexingContext context = new DefaultIndexingContext(id, repositoryId, repository, indexDirectory, repositoryUrl, indexUpdateUrl, IndexCreatorSorter.sort(indexers), reclaim);
        context.setSearchable(searchable);
        return context;
    }

    @Override
    public IndexingContext createMergedIndexingContext(String id, String repositoryId, File repository, File indexDirectory, boolean searchable, ContextMemberProvider membersProvider) throws IOException {
        MergedIndexingContext context = new MergedIndexingContext(id, repositoryId, repository, indexDirectory, searchable, membersProvider);
        return context;
    }

    @Override
    public void closeIndexingContext(IndexingContext context, boolean deleteFiles) throws IOException {
        context.close(deleteFiles);
    }

    @Override
    public void addArtifactToIndex(ArtifactContext ac, IndexingContext context) throws IOException {
        if (ac != null) {
            this.indexerEngine.update(context, ac);
            context.commit();
        }
    }

    @Override
    public void addArtifactsToIndex(Collection<ArtifactContext> ac, IndexingContext context) throws IOException {
        if (ac != null && !ac.isEmpty()) {
            for (ArtifactContext actx : ac) {
                this.indexerEngine.update(context, actx);
            }
            context.commit();
        }
    }

    @Override
    public void deleteArtifactsFromIndex(Collection<ArtifactContext> ac, IndexingContext context) throws IOException {
        if (ac != null && !ac.isEmpty()) {
            for (ArtifactContext actx : ac) {
                this.indexerEngine.remove(context, actx);
                context.commit();
            }
        }
    }

    @Override
    public FlatSearchResponse searchFlat(FlatSearchRequest request) throws IOException {
        if (request.getContexts().isEmpty()) {
            return new FlatSearchResponse(request.getQuery(), 0, Collections.emptySet());
        }
        return this.searcher.forceSearchFlatPaged(request, request.getContexts());
    }

    @Override
    public IteratorSearchResponse searchIterator(IteratorSearchRequest request) throws IOException {
        if (request.getContexts().isEmpty()) {
            return IteratorSearchResponse.empty(request.getQuery());
        }
        return this.searcher.forceSearchIteratorPaged(request, request.getContexts());
    }

    @Override
    public GroupedSearchResponse searchGrouped(GroupedSearchRequest request) throws IOException {
        if (request.getContexts().isEmpty()) {
            return new GroupedSearchResponse(request.getQuery(), 0, Collections.emptyMap());
        }
        return this.searcher.forceSearchGrouped(request, request.getContexts());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<ArtifactInfo> identify(File artifact, Collection<IndexingContext> contexts) throws IOException {
        try (FileInputStream is = new FileInputStream(artifact);){
            int n;
            MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
            byte[] buff = new byte[4096];
            while ((n = is.read(buff)) > -1) {
                sha1.update(buff, 0, n);
            }
            byte[] digest = sha1.digest();
            Collection<ArtifactInfo> collection = this.identify(this.constructQuery(MAVEN.SHA1, (SearchExpression)new SourcedSearchExpression(DefaultIndexer.encode(digest))), contexts);
            return collection;
        }
        catch (NoSuchAlgorithmException ex) {
            IOException ioe = new IOException("Unable to calculate digest");
            ioe.initCause(ex);
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ArtifactInfo> identify(Query query, Collection<IndexingContext> contexts) throws IOException {
        try (IteratorSearchResponse result = this.searcher.searchIteratorPaged(new IteratorSearchRequest(query), contexts);){
            ArrayList<ArtifactInfo> ais = new ArrayList<ArtifactInfo>(result.getTotalHitsCount());
            for (ArtifactInfo ai : result) {
                ais.add(ai);
            }
            Iterable<ArtifactInfo> iterable = ais;
            return iterable;
        }
    }

    @Override
    public Query constructQuery(Field field, SearchExpression expression) throws IllegalArgumentException {
        try {
            return this.queryCreator.constructQuery(field, expression);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Query constructQuery(Field field, String expression, SearchType searchType) throws IllegalArgumentException {
        return this.constructQuery(field, (SearchExpression)new SearchTypedStringSearchExpression(expression, searchType));
    }

    private static String encode(byte[] digest) {
        char[] buff = new char[digest.length * 2];
        int n = 0;
        for (byte b : digest) {
            buff[n++] = DIGITS[(0xF0 & b) >> 4];
            buff[n++] = DIGITS[0xF & b];
        }
        return new String(buff);
    }
}

