/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.build.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class UniqueList<E>
extends ArrayList<E>
implements Set<E> {
    private static final long serialVersionUID = 1L;
    private static int SMALL_TO_LARGE_THRESHOLD = 5;
    private @Nullable Set<E> set = null;

    public UniqueList() {
    }

    public UniqueList(Collection<? extends E> c) {
        if (c.size() >= SMALL_TO_LARGE_THRESHOLD) {
            this.set = new HashSet(c.size());
        }
        for (E aT : c) {
            this.add(aT);
        }
    }

    public UniqueList(int initialCapacity) {
        if (initialCapacity >= SMALL_TO_LARGE_THRESHOLD) {
            this.set = new HashSet(initialCapacity);
        }
    }

    @Override
    public boolean add(E e) {
        Set<E> set2 = this.set;
        if (set2 == null) {
            if (this.size() < SMALL_TO_LARGE_THRESHOLD) {
                if (this.contains(e)) {
                    return false;
                }
                return super.add(e);
            }
            set2 = new HashSet(this);
            this.set = set2;
        }
        if (!set2.add(e)) {
            return false;
        }
        return super.add(e);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        Set<E> set2 = this.set;
        if (set2 == null && this.size() + c.size() >= SMALL_TO_LARGE_THRESHOLD) {
            set2 = new HashSet(this);
            this.set = set2;
        }
        boolean isChanged = false;
        if (set2 == null) {
            for (E aT : c) {
                if (this.contains(aT)) continue;
                isChanged = true;
                super.add(aT);
            }
        } else {
            for (E aT : c) {
                if (!set2.add(aT)) continue;
                isChanged = true;
                super.add(aT);
            }
        }
        return isChanged;
    }

    @Override
    public void clear() {
        super.clear();
        this.set = null;
    }

    @Override
    public boolean contains(Object o) {
        return this.set != null ? this.set.contains(o) : super.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.set != null ? this.set.containsAll(c) : super.containsAll(c);
    }

    @Override
    public boolean remove(Object o) {
        if (this.set != null && !this.set.remove(o)) {
            return false;
        }
        return super.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean isChanged = false;
        for (Object aT : c) {
            if (!this.remove(aT)) continue;
            isChanged = true;
        }
        return isChanged;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (this.set != null) {
            this.set.retainAll(c);
            return super.retainAll(this.set);
        }
        return super.retainAll(c);
    }

    @Override
    public <T> T @NonNull [] toArray(T[] a) {
        return super.toArray(a);
    }
}

