/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.editor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.photran.internal.core.lang.linescanner.FortranLineScanner;
import org.eclipse.photran.internal.core.lang.linescanner.FortranLineType;
import org.eclipse.photran.internal.core.lang.linescanner.ILookaheadLineReader;
import org.eclipse.photran.internal.ui.FortranUIPlugin;
import org.eclipse.photran.internal.ui.editor.FortranEditor;
import org.eclipse.photran.internal.ui.editor.IDocumentCharSequence;

public class FortranStmtPartitionScanner
implements IPartitionTokenScanner {
    public static final String[] PARTITION_TYPES;
    private static final Map<FortranLineType, IToken> LINE_TOKENS;
    private final FortranEditor editor;
    private IDocument document = null;
    private int startOffset = 0;
    private int endOffset = 0;
    private int tokenOffset = 0;
    private int tokenLength = 0;

    static {
        FortranLineType[] lineTypes = FortranLineType.values();
        String[] partitionTypes = new String[lineTypes.length];
        HashMap<FortranLineType, IToken> tokenTypes = new HashMap<FortranLineType, IToken>();
        FortranLineType[] fortranLineTypeArray = lineTypes;
        int n = lineTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String partitionType;
            FortranLineType lineType = fortranLineTypeArray[n2];
            partitionTypes[lineType.ordinal()] = partitionType = FortranStmtPartitionScanner.getPartitionType(lineType);
            tokenTypes.put(lineType, (IToken)new Token((Object)partitionType));
            ++n2;
        }
        PARTITION_TYPES = partitionTypes;
        LINE_TOKENS = tokenTypes;
    }

    public static final String getPartitionType(FortranLineType lineType) {
        switch (lineType) {
            case STATEMENT: {
                return "__dftl_partition_content_type";
            }
        }
        return lineType.toString();
    }

    public FortranStmtPartitionScanner() {
        this.editor = null;
    }

    public FortranStmtPartitionScanner(FortranEditor editor) {
        this.editor = editor;
    }

    public void setRange(IDocument document, int offset, int length) {
        this.document = document;
        this.startOffset = offset;
        this.endOffset = offset + length;
    }

    public void setPartialRange(IDocument document, int offset, int length, String contentType, int partitionOffset) {
        this.document = document;
        try {
            this.startOffset = document.getPartition(offset).getOffset();
        }
        catch (BadLocationException e) {
            FortranUIPlugin.log(e);
            this.startOffset = offset;
        }
        this.endOffset = offset + length;
    }

    public IToken nextToken() {
        this.tokenOffset = this.startOffset;
        this.tokenLength = 0;
        if (this.document == null || this.endOffset <= this.startOffset || this.startOffset >= this.document.getLength()) {
            return Token.EOF;
        }
        try {
            FortranLineScanner lineScanner = new FortranLineScanner(this.isFixedForm(), this.isCPreprocessed());
            lineScanner.scan((ILookaheadLineReader)new DocumentLookaheadLineReader());
            this.tokenLength = lineScanner.getLineLength();
            this.startOffset += this.tokenLength;
            return LINE_TOKENS.get(lineScanner.getLineType());
        }
        catch (BadLocationException e) {
            FortranUIPlugin.log(e);
            return Token.EOF;
        }
    }

    private boolean isFixedForm() {
        return this.editor == null ? false : this.editor.isFixedForm();
    }

    private boolean isCPreprocessed() {
        return this.editor == null ? true : this.editor.isCPreprocessed();
    }

    public int getTokenOffset() {
        return this.tokenOffset;
    }

    public int getTokenLength() {
        return this.tokenLength;
    }

    private final class DocumentLookaheadLineReader
    implements ILookaheadLineReader<BadLocationException> {
        private int offset;

        private DocumentLookaheadLineReader() {
            this.offset = FortranStmtPartitionScanner.this.startOffset;
        }

        public CharSequence readNextLine() throws BadLocationException {
            if (this.offset >= FortranStmtPartitionScanner.this.document.getLength()) {
                return null;
            }
            int lineNumber = FortranStmtPartitionScanner.this.document.getLineOfOffset(this.offset);
            IRegion line = FortranStmtPartitionScanner.this.document.getLineInformation(lineNumber);
            String delimiter = FortranStmtPartitionScanner.this.document.getLineDelimiter(lineNumber);
            if (delimiter == null) {
                delimiter = "";
            }
            IDocumentCharSequence result = new IDocumentCharSequence(FortranStmtPartitionScanner.this.document, line.getOffset(), line.getOffset() + line.getLength() + delimiter.length());
            this.offset += result.length();
            return result;
        }

        public CharSequence advanceAndRestart(int numChars) {
            this.offset = FortranStmtPartitionScanner.this.startOffset + numChars;
            return null;
        }

        public void close() {
        }
    }
}

