/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.openmp.analysis;

public class OpenMPError {
    protected String description_ = "";
    protected String filename_ = "";
    protected String path_ = "";
    protected int lineno_ = 0;
    protected int severity_ = 0;
    public static final int INFO = 0;
    public static final int WARN = 1;
    public static final int ERROR = 2;

    public OpenMPError(String description, String filename, String path, int lineno, int severity) {
        this.description_ = description;
        this.filename_ = filename;
        this.path_ = path;
        this.lineno_ = lineno;
        this.severity_ = severity;
    }

    public OpenMPError(String description, String fqn, int lineno, int severity) {
        this.description_ = description;
        int l1 = fqn.lastIndexOf(47);
        int l2 = fqn.lastIndexOf(92);
        int lastIndex = Math.max(l1, l2);
        if (lastIndex == -1 || lastIndex > fqn.length() + 1) {
            this.filename_ = fqn;
        } else {
            this.filename_ = fqn.substring(lastIndex + 1);
            this.path_ = fqn.substring(0, lastIndex);
        }
        this.lineno_ = lineno;
        this.severity_ = severity;
    }

    public String getDescription() {
        return this.description_;
    }

    public String getFilename() {
        return this.filename_;
    }

    public String getPath() {
        return this.path_;
    }

    public int getLineno() {
        return this.lineno_;
    }

    public int getSeverity() {
        return this.severity_;
    }
}

