/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.openmp.fortran.analysis;

import java.util.regex.Pattern;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTNameNode;
import org.eclipse.photran.internal.core.parser.ASTVarOrFnRefNode;
import org.eclipse.photran.internal.core.parser.GenericASTVisitor;
import org.eclipse.ptp.pldt.common.Artifact;
import org.eclipse.ptp.pldt.common.util.SourceInfo;
import org.eclipse.ptp.pldt.openmp.core.OpenMPScanReturn;

public class OpenMPFortranASTVisitor
extends GenericASTVisitor {
    private static final String PREFIX = "OMP_";
    private static final Pattern END_DIRECTIVE = Pattern.compile("^end", 2);
    private static final boolean shouldIgnoreEndDirectives = false;
    private OpenMPScanReturn scanReturn;
    private String fileName;

    public OpenMPFortranASTVisitor(String fileName, OpenMPScanReturn scanReturn) {
        this.scanReturn = scanReturn;
        this.fileName = fileName;
    }

    public void visitToken(Token node) {
        for (Token ompDirective : node.getOpenMPComments()) {
            if (this.shouldIgnore(ompDirective)) continue;
            this.addArtifact(ompDirective, 3);
        }
    }

    private boolean shouldIgnore(Token ompDirective) {
        return false;
    }

    private boolean isOpenMPEndDirective(Token ompDirective) {
        return END_DIRECTIVE.matcher(ompDirective.getText()).find();
    }

    public void visitASTVarOrFnRefNode(ASTVarOrFnRefNode node) {
        ASTNameNode nameNode = node.getName();
        if (nameNode != null) {
            this.addArtifact(nameNode.getName(), 1);
        }
    }

    private void addArtifact(Token token, int artifactType) {
        String callname = token.getText().toUpperCase();
        if (artifactType == 3 || callname.startsWith(PREFIX)) {
            int start = token.getFileOffset();
            int end = token.getFileOffset() + token.getLength();
            SourceInfo si = new SourceInfo(token.getLine(), start, end, artifactType);
            this.scanReturn.addArtifact(new Artifact(this.fileName, token.getLine(), 1, callname, si));
        }
    }
}

