/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.debug.ui.views.breakpoints;

import org.eclipse.reddeer.common.condition.AbstractWaitCondition;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.swt.api.TreeItem;
import org.eclipse.reddeer.swt.exception.SWTLayerException;
import org.eclipse.reddeer.swt.impl.menu.ContextMenuItem;
import org.eclipse.reddeer.swt.impl.tree.AbstractTreeItem;

public class Breakpoint
extends AbstractTreeItem {
    private static Logger log = Logger.getLogger(Breakpoint.class);

    protected Breakpoint(TreeItem treeItem) {
        super((org.eclipse.swt.widgets.TreeItem)treeItem.getSWTWidget());
    }

    public void remove() {
        this.doOperation("Remove");
    }

    public void disable() {
        this.doOperation("Disable");
        new WaitUntil((WaitCondition)new AbstractWaitCondition(){

            public boolean test() {
                return !Breakpoint.this.isChecked();
            }
        });
    }

    public void enable() {
        this.doOperation("Enable");
        new WaitUntil((WaitCondition)new AbstractWaitCondition(){

            public boolean test() {
                return Breakpoint.this.isChecked();
            }
        });
    }

    public void doOperation(String operation) {
        log.debug("Performing '" + operation + "' on breakpoint: " + this.getText());
        this.select();
        ContextMenuItem menuitem = new ContextMenuItem(new String[]{operation});
        if (menuitem.isEnabled()) {
            menuitem.select();
            log.debug("Operation '" + operation + "' was performed");
        } else {
            log.debug("Operation '" + operation + "' was NOT performed (item is not enabled)");
        }
    }

    public boolean isEnabled() {
        return this.isOperationEnabled("Disable");
    }

    public boolean isOperationEnabled(String operation) {
        log.debug("Checking operation '" + operation + "' on breakpoint:" + this.getText());
        this.select();
        try {
            ContextMenuItem menuitem = new ContextMenuItem(new String[]{operation});
            return menuitem.isEnabled();
        }
        catch (CoreLayerException | SWTLayerException throwable) {
            log.debug("Operation '" + operation + "' not found!");
            return false;
        }
    }
}

