/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.swt.SWT;
import org.eclipse.swt.tools.internal.ASTClass;
import org.eclipse.swt.tools.internal.EmbedMetaData;
import org.eclipse.swt.tools.internal.JNIClass;
import org.eclipse.swt.tools.internal.JNIField;
import org.eclipse.swt.tools.internal.JNIGenerator;
import org.eclipse.swt.tools.internal.JNIMethod;
import org.eclipse.swt.tools.internal.MetaData;
import org.eclipse.swt.tools.internal.MetaDataGenerator;
import org.eclipse.swt.tools.internal.NativesGenerator;
import org.eclipse.swt.tools.internal.ProgressMonitor;
import org.eclipse.swt.tools.internal.ReflectClass;
import org.eclipse.swt.tools.internal.StatsGenerator;
import org.eclipse.swt.tools.internal.StructsGenerator;

public class JNIGeneratorApp {
    JNIClass mainClass;
    JNIClass[] classes;
    ProgressMonitor progress;
    String mainClassName;
    String classesDir;
    String outputDir;
    String classpath;
    MetaData metaData;
    static boolean USE_AST = true;

    public String getClasspath() {
        return this.classpath;
    }

    public String getClassesDir() {
        return this.classesDir;
    }

    public JNIClass getMainClass() {
        return this.mainClass;
    }

    public String getMainClassName() {
        return this.mainClassName;
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    String getMetaDataDir() {
        return "./JNI Generation/org/eclipse/swt/tools/internal/";
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public void generateAll() {
        String mainClasses = new MetaData(JNIGeneratorApp.getDefaultMainClass()).getMetaData("swt_main_classes", null);
        if (mainClasses != null) {
            String[] list = JNIGenerator.split(mainClasses, ",");
            int i = 0;
            while (i < list.length) {
                block5: {
                    String className = list[i].trim();
                    if (!USE_AST) {
                        try {
                            Class.forName(className, false, this.getClass().getClassLoader());
                        }
                        catch (Throwable throwable) {
                            break block5;
                        }
                    }
                    this.setMainClassName(className);
                    this.generate();
                }
                i += 2;
            }
        }
    }

    void generateSTATS_C(JNIClass[] classes) {
        try {
            StatsGenerator gen = new StatsGenerator(false);
            gen.setMainClass(this.mainClass);
            gen.setClasses(classes);
            gen.setMetaData(this.metaData);
            gen.setProgressMonitor(this.progress);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            gen.setOutput(new PrintStream(out));
            String fileName = String.valueOf(this.outputDir) + gen.getFileName();
            gen.setDelimiter(JNIGenerator.getDelimiter(fileName));
            gen.generate();
            if (out.size() > 0) {
                JNIGenerator.output(out.toByteArray(), fileName);
            }
        }
        catch (Exception e) {
            System.out.println("Problem");
            e.printStackTrace(System.out);
        }
    }

    void generateSTATS_H(JNIClass[] classes) {
        try {
            StatsGenerator gen = new StatsGenerator(true);
            gen.setMainClass(this.mainClass);
            gen.setClasses(classes);
            gen.setMetaData(this.metaData);
            gen.setProgressMonitor(this.progress);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            gen.setOutput(new PrintStream(out));
            String fileName = String.valueOf(this.outputDir) + gen.getFileName();
            gen.setDelimiter(JNIGenerator.getDelimiter(fileName));
            gen.generate();
            if (out.size() > 0) {
                JNIGenerator.output(out.toByteArray(), fileName);
            }
        }
        catch (Exception e) {
            System.out.println("Problem");
            e.printStackTrace(System.out);
        }
    }

    void generateSTRUCTS_H(JNIClass[] classes) {
        try {
            StructsGenerator gen = new StructsGenerator(true);
            gen.setMainClass(this.mainClass);
            gen.setClasses(classes);
            gen.setMetaData(this.metaData);
            gen.setProgressMonitor(this.progress);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            gen.setOutput(new PrintStream(out));
            String fileName = String.valueOf(this.outputDir) + gen.getFileName();
            gen.setDelimiter(JNIGenerator.getDelimiter(fileName));
            gen.generate();
            if (out.size() > 0) {
                JNIGenerator.output(out.toByteArray(), fileName);
            }
        }
        catch (Exception e) {
            System.out.println("Problem");
            e.printStackTrace(System.out);
        }
    }

    void generateSTRUCTS_C(JNIClass[] classes) {
        try {
            StructsGenerator gen = new StructsGenerator(false);
            gen.setMainClass(this.mainClass);
            gen.setClasses(classes);
            gen.setMetaData(this.metaData);
            gen.setProgressMonitor(this.progress);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            gen.setOutput(new PrintStream(out));
            String fileName = String.valueOf(this.outputDir) + gen.getFileName();
            gen.setDelimiter(JNIGenerator.getDelimiter(fileName));
            gen.generate();
            if (out.size() > 0) {
                JNIGenerator.output(out.toByteArray(), fileName);
            }
        }
        catch (Exception e) {
            System.out.println("Problem");
            e.printStackTrace(System.out);
        }
    }

    void generateSWT_C(JNIClass[] classes) {
        try {
            NativesGenerator gen = new NativesGenerator();
            gen.setMainClass(this.mainClass);
            gen.setClasses(classes);
            gen.setMetaData(this.metaData);
            gen.setProgressMonitor(this.progress);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            gen.setOutput(new PrintStream(out));
            String fileName = String.valueOf(this.outputDir) + gen.getFileName();
            gen.setDelimiter(JNIGenerator.getDelimiter(fileName));
            gen.generate();
            if (out.size() > 0) {
                JNIGenerator.output(out.toByteArray(), fileName);
            }
        }
        catch (Exception e) {
            System.out.println("Problem");
            e.printStackTrace(System.out);
        }
    }

    void generateMetaData(JNIClass[] classes) {
        try {
            MetaDataGenerator gen = new MetaDataGenerator();
            gen.setMainClass(this.mainClass);
            gen.setClasses(classes);
            gen.setMetaData(this.metaData);
            gen.setProgressMonitor(this.progress);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            gen.setOutput(new PrintStream(out));
            String fileName = String.valueOf(this.getMetaDataDir()) + gen.getFileName();
            if (new File(fileName).exists()) {
                gen.setDelimiter(JNIGenerator.getDelimiter(fileName));
                gen.generate();
                if (!new File(this.getMetaDataDir()).exists()) {
                    System.out.println("Warning: Meta data output dir does not exist");
                    return;
                }
                if (out.size() > 0) {
                    JNIGenerator.output(out.toByteArray(), fileName);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Problem");
            e.printStackTrace(System.out);
        }
    }

    void generateEmbededMetaData(JNIClass[] classes) {
        try {
            EmbedMetaData gen = new EmbedMetaData();
            gen.setMainClass(this.mainClass);
            gen.setClasses(classes);
            gen.setMetaData(this.metaData);
            gen.generate();
        }
        catch (Exception e) {
            System.out.println("Problem");
            e.printStackTrace(System.out);
        }
    }

    public void generate() {
        System.out.println("Generating \"" + this.getMainClassName() + "\"");
        this.generate(null);
    }

    public void generate(ProgressMonitor progress) {
        if (this.mainClass == null) {
            return;
        }
        if (progress != null) {
            progress.setMessage("Initializing...");
        }
        JNIClass[] classes = this.getClasses();
        JNIClass[] natives = this.getNativesClasses(classes);
        JNIClass[] structs = this.getStructureClasses(classes);
        this.progress = progress;
        if (progress != null) {
            int nativeCount = 0;
            JNIClass[] jNIClassArray = natives;
            int n = natives.length;
            int n2 = 0;
            while (n2 < n) {
                JNIClass clazz = jNIClassArray[n2];
                JNIMethod[] jNIMethodArray = clazz.getDeclaredMethods();
                int n3 = jNIMethodArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    JNIMethod method = jNIMethodArray[n4];
                    if ((method.getModifiers() & 0x100) != 0) {
                        ++nativeCount;
                    }
                    ++n4;
                }
                ++n2;
            }
            int total = nativeCount * 4;
            total += classes.length;
            total += natives.length * 3;
            progress.setTotal(total += structs.length * 2);
            progress.setMessage("Generating structs.h ...");
        }
        this.generateSTRUCTS_H(structs);
        if (progress != null) {
            progress.setMessage("Generating structs.c ...");
        }
        this.generateSTRUCTS_C(structs);
        if (progress != null) {
            progress.setMessage("Generating natives ...");
        }
        this.generateSWT_C(natives);
        if (progress != null) {
            progress.setMessage("Generating stats.h ...");
        }
        this.generateSTATS_H(natives);
        if (progress != null) {
            progress.setMessage("Generating stats.c ...");
        }
        this.generateSTATS_C(natives);
        if (progress != null) {
            progress.setMessage("Generating meta data ...");
        }
        this.generateMetaData(classes);
        if (progress != null) {
            progress.setMessage("Done.");
        }
        this.progress = null;
    }

    String getPackageName() {
        int dot = this.mainClassName.lastIndexOf(46);
        if (dot == -1) {
            return "";
        }
        return this.mainClassName.substring(0, dot);
    }

    String[] getClassNames() {
        String pkgName = this.getPackageName();
        String classpath = this.getClasspath();
        if (classpath == null) {
            classpath = System.getProperty("java.class.path");
        }
        String pkgPath = pkgName.replace('.', File.separatorChar);
        String pkgZipPath = pkgName.replace('.', '/');
        ArrayList<String> classes = new ArrayList<String>();
        int start = 0;
        int index = 0;
        while (index < classpath.length()) {
            String path;
            index = classpath.indexOf(File.pathSeparatorChar, start);
            if (index == -1) {
                index = classpath.length();
            }
            if ((path = classpath.substring(start, index)).toLowerCase().endsWith(".jar")) {
                try {
                    Throwable throwable = null;
                    Object var10_11 = null;
                    try (ZipFile zipFile = new ZipFile(path);){
                        Enumeration<? extends ZipEntry> entries = zipFile.entries();
                        while (entries.hasMoreElements()) {
                            ZipEntry entry = entries.nextElement();
                            String name = entry.getName();
                            if (!name.startsWith(pkgZipPath) || name.indexOf(47, pkgZipPath.length() + 1) != -1 || !name.endsWith(".class")) continue;
                            String className = name.substring(pkgZipPath.length() + 1, name.length() - 6);
                            className.replace('/', '.');
                            classes.add(className);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {}
            } else {
                File file = new File(String.valueOf(path) + File.separator + pkgPath);
                if (file.exists()) {
                    String[] entries = file.list();
                    if (entries == null) {
                        entries = new String[]{};
                    }
                    String[] stringArray = entries;
                    int n = entries.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String entry = stringArray[n2];
                        File f = new File(file, entry);
                        if (!f.isDirectory() && f.getAbsolutePath().endsWith(".class")) {
                            String className = entry.substring(0, entry.length() - 6);
                            classes.add(className);
                        }
                        ++n2;
                    }
                }
            }
            start = index + 1;
        }
        return classes.toArray(new String[classes.size()]);
    }

    public JNIClass[] getClasses() {
        if (this.classes != null) {
            return this.classes;
        }
        if (this.mainClassName == null) {
            return new JNIClass[0];
        }
        if (USE_AST) {
            return this.getASTClasses();
        }
        Object[] classNames = this.getClassNames();
        Arrays.sort(classNames);
        String packageName = this.getPackageName();
        JNIClass[] classes = new JNIClass[classNames.length];
        int i = 0;
        while (i < classNames.length) {
            Object className = classNames[i];
            try {
                String qualifiedName = String.valueOf(packageName) + "." + (String)className;
                if (qualifiedName.equals(this.mainClassName)) {
                    classes[i] = this.mainClass;
                } else {
                    String root = this.classesDir != null ? this.classesDir : String.valueOf(new File(this.outputDir).getParent()) + "/";
                    String sourcePath = String.valueOf(root) + qualifiedName.replace('.', '/') + ".java";
                    classes[i] = new ReflectClass(Class.forName(qualifiedName, false, this.getClass().getClassLoader()), this.metaData, sourcePath);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        return classes;
    }

    JNIClass[] getASTClasses() {
        if (this.classes != null) {
            return this.classes;
        }
        if (this.mainClassName == null) {
            return new JNIClass[0];
        }
        String root = this.classesDir != null ? this.classesDir : String.valueOf(new File(this.outputDir).getParent()) + "/";
        String mainPath = new File(String.valueOf(root) + this.mainClassName.replace('.', '/') + ".java").getAbsolutePath();
        ArrayList<JNIClass> classes = new ArrayList<JNIClass>();
        String packageName = this.getPackageName();
        File dir = new File(String.valueOf(root) + "/" + packageName.replace('.', '/'));
        File[] files = dir.listFiles();
        if (files == null) {
            files = new File[]{};
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            try {
                String path = file.getAbsolutePath().replace('\\', '/');
                if (path.endsWith(".java")) {
                    if (mainPath.equals(path)) {
                        classes.add(this.mainClass);
                    } else {
                        try {
                            classes.add(new ASTClass(path, this.metaData));
                        }
                        catch (ClassCastException cce) {
                            cce.getMessage().startsWith(EnumDeclaration.class.getName());
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return classes.toArray(new JNIClass[classes.size()]);
    }

    public JNIClass[] getNativesClasses(JNIClass[] classes) {
        if (this.mainClass == null) {
            return new JNIClass[0];
        }
        ArrayList<JNIClass> result = new ArrayList<JNIClass>();
        JNIClass[] jNIClassArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            JNIClass clazz = jNIClassArray[n2];
            JNIMethod[] jNIMethodArray = clazz.getDeclaredMethods();
            int n3 = jNIMethodArray.length;
            int n4 = 0;
            while (n4 < n3) {
                JNIMethod method = jNIMethodArray[n4];
                int mods = method.getModifiers();
                if ((mods & 0x100) != 0) {
                    result.add(clazz);
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        return result.toArray(new JNIClass[result.size()]);
    }

    public JNIClass[] getStructureClasses(JNIClass[] classes) {
        if (this.mainClass == null) {
            return new JNIClass[0];
        }
        ArrayList<JNIClass> result = new ArrayList<JNIClass>();
        JNIClass[] jNIClassArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                JNIClass clazz = jNIClassArray[n2];
                JNIMethod[] jNIMethodArray = clazz.getDeclaredMethods();
                int n3 = jNIMethodArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    JNIMethod method = jNIMethodArray[n4];
                    int mods = method.getModifiers();
                    if ((mods & 0x100) == 0) {
                        ++n4;
                        continue;
                    }
                    break block7;
                }
                boolean hasPublicFields = false;
                JNIField[] jNIFieldArray = clazz.getDeclaredFields();
                int n5 = jNIFieldArray.length;
                n3 = 0;
                while (n3 < n5) {
                    JNIField field = jNIFieldArray[n3];
                    int mods = field.getModifiers();
                    if ((mods & 1) != 0 && (mods & 8) == 0) {
                        hasPublicFields = true;
                        break;
                    }
                    ++n3;
                }
                if (hasPublicFields) {
                    result.add(clazz);
                }
            }
            ++n2;
        }
        return result.toArray(new JNIClass[result.size()]);
    }

    public void setClasspath(String classpath) {
        this.classpath = classpath;
    }

    public void setMainClass(JNIClass mainClass) {
        this.mainClass = mainClass;
    }

    public void setMetaData(MetaData data) {
        this.metaData = data;
    }

    public void setClasses(JNIClass[] classes) {
        this.classes = classes;
    }

    public void setMainClassName(String str) {
        this.mainClassName = str;
        this.metaData = new MetaData(this.mainClassName);
        String mainClasses = this.getMetaData().getMetaData("swt_main_classes", null);
        if (mainClasses != null) {
            String[] list = JNIGenerator.split(mainClasses, ",");
            int i = 0;
            while (i < list.length) {
                if (this.mainClassName.equals(list[i].trim())) {
                    this.setOutputDir(list[i + 1].trim());
                }
                i += 2;
            }
        }
        if (this.mainClassName != null) {
            try {
                String root = this.classesDir != null ? this.classesDir : String.valueOf(new File(this.outputDir).getParent()) + "/";
                String sourcePath = String.valueOf(root) + this.mainClassName.replace('.', '/') + ".java";
                this.mainClass = USE_AST ? new ASTClass(sourcePath, this.metaData) : new ReflectClass(Class.forName(this.mainClassName, false, this.getClass().getClassLoader()), this.metaData, sourcePath);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setMainClassName(String str, String outputDir) {
        this.setMainClassName(str, outputDir, null);
    }

    public void setMainClassName(String str, String outputDir, String classesDir) {
        this.mainClassName = str;
        this.setClassesDir(classesDir);
        this.setOutputDir(outputDir);
        this.metaData = new MetaData(this.mainClassName);
        try {
            String root = classesDir != null ? classesDir : String.valueOf(new File(outputDir).getParent()) + "/";
            String sourcePath = String.valueOf(root) + this.mainClassName.replace('.', '/') + ".java";
            this.mainClass = USE_AST ? new ASTClass(sourcePath, this.metaData) : new ReflectClass(Class.forName(this.mainClassName, false, this.getClass().getClassLoader()), this.metaData, sourcePath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setClassesDir(String str) {
        if (str != null) {
            if (!str.endsWith("\\") && !str.endsWith("/")) {
                str = String.valueOf(str) + File.separator;
            }
            str = str.replace('\\', '/');
        }
        this.classesDir = str;
    }

    public void setOutputDir(String str) {
        if (str != null) {
            if (!str.endsWith("\\") && !str.endsWith("/")) {
                str = String.valueOf(str) + File.separator;
            }
            str = str.replace('\\', '/');
        }
        this.outputDir = str;
    }

    public static String getDefaultMainClass() {
        return "org.eclipse.swt.internal." + JNIGeneratorApp.getDefaultPlatform() + ".OS";
    }

    public static String getDefaultPlatform() {
        return SWT.getPlatform();
    }

    public static void main(String[] args) {
        JNIGeneratorApp gen = new JNIGeneratorApp();
        if (args.length == 1 && (args[0].equals("*") || args[0].equals("all"))) {
            gen.generateAll();
            return;
        }
        if (args.length > 0) {
            gen.setMainClassName(args[0]);
            if (args.length > 1) {
                gen.setOutputDir(args[1]);
            }
            if (args.length > 2) {
                gen.setClasspath(args[2]);
            }
        } else {
            gen.setMainClassName(JNIGeneratorApp.getDefaultMainClass());
        }
        gen.generate();
    }
}

