/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.events;

import org.eclipse.swt.widgets.Event;
import org.eclipse.swtchart.IPlotArea;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.ISeriesSet;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.events.AbstractHandledEventProcessor;
import org.eclipse.swtchart.extensions.events.IHandledEventProcessor;

public class MouseUpEvent
extends AbstractHandledEventProcessor
implements IHandledEventProcessor {
    @Override
    public int getEvent() {
        return 5;
    }

    @Override
    public int getButton() {
        return 1;
    }

    @Override
    public int getStateMask() {
        return 524288;
    }

    @Override
    public void handleEvent(BaseChart baseChart, Event event) {
        IPlotArea plotArea = baseChart.getPlotArea();
        if (plotArea.isBuffered()) {
            ISeries[] series;
            baseChart.suspendUpdate(true);
            plotArea.setBackgroundImage(null);
            plotArea.setBuffered(false);
            ISeriesSet set = baseChart.getSeriesSet();
            ISeries[] iSeriesArray = series = set.getSeries();
            int n = series.length;
            int n2 = 0;
            while (n2 < n) {
                ISeries serie = iSeriesArray[n2];
                if (serie.isVisibleBuffered()) {
                    baseChart.showSeries(serie.getId());
                    serie.setVisibleBuffered(false);
                }
                ++n2;
            }
            baseChart.suspendUpdate(false);
            baseChart.redraw();
        }
        if (this.isSingleClick(event)) {
            long deltaTime = System.currentTimeMillis() - baseChart.getClickStartTime();
            if (deltaTime >= 100L) {
                baseChart.handleUserSelection(event);
            } else {
                baseChart.getUserSelection().reset();
            }
        }
    }
}

