/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tips.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.tips.core.Tip;
import org.eclipse.tips.core.TipImage;
import org.eclipse.tips.core.TipProvider;
import org.eclipse.tips.core.internal.LogUtil;
import org.eclipse.tips.json.internal.JsonHTMLTip;
import org.eclipse.tips.json.internal.JsonUrlTip;
import org.eclipse.tips.json.internal.Messages;
import org.eclipse.tips.json.internal.Util;

public abstract class JsonTipProvider
extends TipProvider {
    private static final String SPACE = " ";
    private URL fJsonUrl;
    private String fDescription;
    private String fImage;
    private JsonObject fJsonObject;

    public void setJsonUrl(String jsonUrl) throws MalformedURLException {
        this.fJsonUrl = new URL(jsonUrl);
    }

    public synchronized IStatus loadNewTips(IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)(String.valueOf(this.getDescription()) + SPACE + Messages.JsonTipProvider_1), (int)3);
        ArrayList result = new ArrayList();
        try {
            this.fJsonObject = this.loadJsonObject();
            subMonitor.worked(1);
            if (this.fJsonObject == null) {
                return new Status(1, "org.eclipse.tips.json", MessageFormat.format("Could not parse json for {0}. Cache invalidated.", this.getID()), null);
            }
            JsonObject provider = this.fJsonObject.getAsJsonObject("provider");
            this.fDescription = Util.getValueOrDefault(provider, "description", "not set");
            this.fImage = Util.getValueOrDefault(provider, "image", null);
            this.setExpression(Util.getValueOrDefault(provider, "expression", null));
            JsonArray tips = provider.getAsJsonArray("tips");
            subMonitor.worked(1);
            tips.forEach(parm -> {
                boolean bl = result.add(this.createJsonTip((JsonElement)parm));
            });
            subMonitor.worked(1);
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipse.tips.json", e.getMessage(), (Throwable)e);
            this.getManager().log((IStatus)status);
            return status;
        }
        this.getManager().log(LogUtil.info((String)MessageFormat.format(Messages.JsonTipProvider_4, String.valueOf(result.size()))));
        this.setTips(result);
        return Status.OK_STATUS;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonObject loadJsonObject() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            InputStreamReader reader;
            InputStream stream;
            block13: {
                JsonObject jsonObject;
                block14: {
                    stream = this.fJsonUrl.openStream();
                    reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
                    JsonElement result = JsonParser.parseReader((Reader)reader);
                    if (!(result instanceof JsonObject)) break block13;
                    jsonObject = (JsonObject)result;
                    if (reader == null) break block14;
                    reader.close();
                }
                if (stream == null) return jsonObject;
                stream.close();
                return jsonObject;
            }
            if (reader != null) {
                reader.close();
            }
            if (stream == null) return null;
            {
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (stream == null) throw throwable;
                    stream.close();
                    throw throwable;
                }
            }
            {
                stream.close();
                return null;
                catch (Throwable throwable3) {
                    if (reader == null) throw throwable3;
                    reader.close();
                    throw throwable3;
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            }
            if (throwable == throwable4) throw throwable;
            throwable.addSuppressed(throwable4);
            throw throwable;
        }
    }

    public TipImage getImage() {
        if (this.fImage == null) {
            return null;
        }
        return new TipImage(this.fImage);
    }

    public String getDescription() {
        return this.fDescription;
    }

    private Tip createJsonTip(JsonElement parm) {
        JsonObject json = (JsonObject)parm;
        this.replaceVariables(json);
        try {
            if (json.get("url") != null) {
                return new JsonUrlTip(this.getID(), json);
            }
            return new JsonHTMLTip(this.getID(), json);
        }
        catch (ParseException e) {
            this.getManager().log(LogUtil.error(((Object)((Object)this)).getClass(), (Throwable)e));
            throw new RuntimeException(e);
        }
    }

    private void replaceVariables(JsonObject pJson) {
        String url = Util.getValueOrDefault(pJson, "url", null);
        String html = Util.getValueOrDefault(pJson, "html", null);
        JsonObject vars = this.fJsonObject.getAsJsonObject("provider").getAsJsonObject("variables");
        if (vars != null) {
            if (url != null) {
                url = Util.replace(vars, url);
                pJson.remove("url");
                pJson.addProperty("url", url);
            }
            if (html != null) {
                html = Util.replace(vars, html);
                pJson.remove("html");
                pJson.addProperty("html", html);
            }
        }
    }

    public void dispose() {
    }
}

