/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tools.templates.freemarker;

import java.net.URI;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.tools.templates.freemarker.FMGenerator;

public abstract class FMProjectGenerator
extends FMGenerator {
    private String projectName;
    private URI locationURI;
    private IProject[] referencedProjects;
    private IProject project;

    public FMProjectGenerator(String manifestPath) {
        super(manifestPath);
    }

    protected abstract void initProjectDescription(IProjectDescription var1) throws CoreException;

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setLocationURI(URI locationURI) {
        this.locationURI = locationURI;
    }

    public void setReferencedProjects(IProject[] referencedProjects) {
        this.referencedProjects = referencedProjects;
    }

    public IProject getProject() {
        return this.project;
    }

    @Override
    protected void populateModel(Map<String, Object> model) {
        super.populateModel(model);
        model.put("projectName", this.projectName);
    }

    @Override
    public void generate(Map<String, Object> model, IProgressMonitor monitor) throws CoreException {
        this.createProject(monitor);
        super.generate(model, monitor);
    }

    protected IProject createProject(IProgressMonitor monitor) throws CoreException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)"Creating project", (int)1);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        this.project = workspace.getRoot().getProject(this.projectName);
        if (!this.project.exists()) {
            IProjectDescription description = workspace.newProjectDescription(this.projectName);
            description.setLocationURI(this.locationURI);
            if (this.referencedProjects != null) {
                description.setReferencedProjects(this.referencedProjects);
            }
            this.initProjectDescription(description);
            this.project.create(description, (IProgressMonitor)sub);
            this.project.open((IProgressMonitor)sub);
        }
        sub.worked(1);
        return this.project;
    }
}

