/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.viewers.runtime.sources;

import java.util.Collection;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.viatra.addon.viewers.runtime.model.ItemExtender;
import org.eclipse.viatra.addon.viewers.runtime.model.ViewerState;
import org.eclipse.viatra.addon.viewers.runtime.model.listeners.AbstractViewerStateListener;
import org.eclipse.viatra.addon.viewers.runtime.model.listeners.IViewerLabelListener;
import org.eclipse.viatra.addon.viewers.runtime.notation.Containment;
import org.eclipse.viatra.addon.viewers.runtime.notation.Edge;
import org.eclipse.viatra.addon.viewers.runtime.notation.Item;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;

public class TreeContentProvider
extends AbstractViewerStateListener
implements ITreeContentProvider,
IViewerLabelListener {
    AbstractTreeViewer viewer;
    ViewerState state;
    ItemExtender.RootItem filter = new ItemExtender.RootItem();

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        Preconditions.checkArgument((boolean)(viewer instanceof AbstractTreeViewer));
        this.viewer = (AbstractTreeViewer)viewer;
        if (oldInput instanceof ViewerState) {
            ((ViewerState)oldInput).removeStateListener(this);
            ((ViewerState)oldInput).removeLabelListener(this);
        }
        if (newInput instanceof ViewerState) {
            this.state = (ViewerState)newInput;
            if (this.state.isDisposed()) {
                this.state = null;
            } else {
                this.state.addStateListener(this);
                this.state.addLabelListener(this);
            }
        } else if (newInput != null) {
            throw new IllegalArgumentException(String.format("Invalid input type %s for Tree Viewer.", newInput.getClass().getName()));
        }
    }

    public Object[] getElements(Object inputElement) {
        if (this.state == null) {
            return new Object[0];
        }
        return this.state.getItems().stream().filter(this.filter).toArray(Item[]::new);
    }

    public Object[] getChildren(Object parentElement) {
        Collection<Item> children = this.state.getChildren((Item)parentElement);
        return children.toArray(new Object[children.size()]);
    }

    public Object getParent(Object element) {
        return this.state.getParent((Item)element);
    }

    public boolean hasChildren(Object element) {
        return !this.state.getChildren((Item)element).isEmpty();
    }

    @Override
    public void itemAppeared(Item item) {
        if (this.filter.test(item)) {
            this.viewer.getControl().getDisplay().syncExec(() -> this.viewer.add(this.viewer.getInput(), (Object)item));
        }
    }

    @Override
    public void itemDisappeared(Item item) {
        this.viewer.getControl().getDisplay().syncExec(() -> this.viewer.remove((Object)item));
    }

    @Override
    public void containmentAppeared(Containment edge) {
        this.viewer.getControl().getDisplay().syncExec(() -> {
            this.viewer.add((Object)edge.getSource(), (Object)edge.getTarget());
            this.viewer.setExpandedState((Object)edge.getSource(), true);
            this.viewer.refresh((Object)edge.getTarget());
        });
    }

    @Override
    public void containmentDisappeared(Containment edge) {
        this.viewer.getControl().getDisplay().syncExec(() -> {
            this.viewer.remove((Object)edge.getSource(), new Object[]{edge.getTarget()});
            this.viewer.refresh((Object)edge.getSource());
        });
    }

    public void dispose() {
        if (this.state != null) {
            this.state.removeStateListener(this);
        }
    }

    @Override
    public void labelUpdated(Item item, String newLabel) {
        this.viewer.getControl().getDisplay().syncExec(() -> this.viewer.refresh((Object)item));
    }

    @Override
    public void labelUpdated(Edge edge, String newLabel) {
        this.viewer.getControl().getDisplay().syncExec(() -> this.viewer.refresh((Object)edge));
    }
}

