"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const paths_1 = require("./paths");
exports.KUBERNETES_SCHEMA_URL = 'https://raw.githubusercontent.com/instrumenta/kubernetes-json-schema/master/v1.18.1-standalone-strict/all.json';
exports.JSON_SCHEMASTORE_URL = 'https://www.schemastore.org/api/json/catalog.json';
function checkSchemaURI(workspaceFolders, workspaceRoot, uri) {
    if (uri.trim().toLowerCase() === 'kubernetes') {
        return exports.KUBERNETES_SCHEMA_URL;
    }
    else if (paths_1.isRelativePath(uri)) {
        return paths_1.relativeToAbsolutePath(workspaceFolders, workspaceRoot, uri);
    }
    else {
        return uri;
    }
}
exports.checkSchemaURI = checkSchemaURI;
//# sourceMappingURL=schemaUrls.js.map