/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.ui.propertypages;

import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.wst.jsdt.chromium.debug.core.ChromiumDebugPlugin;
import org.eclipse.wst.jsdt.chromium.debug.core.model.ChromiumExceptionBreakpoint;
import org.eclipse.wst.jsdt.chromium.debug.ui.propertypages.JsLineBreakpointPage;
import org.eclipse.wst.jsdt.chromium.debug.ui.propertypages.Messages;

public class JsExceptionBreakpointPage
extends PropertyPage {
    private Button enabledCheckbox;
    private Button includeCaughtCheckbox;

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        Composite mainComposite = JsLineBreakpointPage.createComposite(parent, 2, 1);
        try {
            this.createBreakpointDataControls(mainComposite);
            this.createInfoControls(mainComposite);
            this.createEnabledControls(mainComposite);
            this.createIncludeCaughtControls(mainComposite);
        }
        catch (CoreException e) {
            ChromiumDebugPlugin.log((Throwable)e);
        }
        this.setValid(true);
        return mainComposite;
    }

    public boolean performOk() {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                JsExceptionBreakpointPage.this.storePrefs();
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(runnable, null, 0, null);
        }
        catch (CoreException e) {
            ChromiumDebugPlugin.log((Throwable)e);
        }
        return super.performOk();
    }

    private void storePrefs() throws CoreException {
        ChromiumExceptionBreakpoint breakpoint = this.getBreakpoint();
        breakpoint.setEnabled(this.enabledCheckbox.getSelection());
        breakpoint.setIncludeCaught(this.includeCaughtCheckbox.getSelection());
    }

    private void createBreakpointDataControls(Composite mainComposite) {
    }

    private void createInfoControls(Composite parent) {
    }

    private void createEnabledControls(Composite parent) throws CoreException {
        this.enabledCheckbox = this.checkboxControl(parent, Messages.JavascriptLineBreakpointPage_Enabled, this.getBreakpoint().isEnabled());
    }

    private void createIncludeCaughtControls(Composite parent) throws CoreException {
        Button includeUncaughtCheckbox = this.checkboxControl(parent, Messages.JsExceptionBreakpointPage_UNCAUGHT, true);
        includeUncaughtCheckbox.setEnabled(false);
        this.includeCaughtCheckbox = this.checkboxControl(parent, Messages.JsExceptionBreakpointPage_CAUGHT, this.getBreakpoint().getIncludeCaught());
    }

    private Button checkboxControl(Composite parent, String label, boolean initialState) throws CoreException {
        Button checkbox = new Button(parent, 32);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        checkbox.setLayoutData((Object)gd);
        checkbox.setSelection(initialState);
        checkbox.setText(label);
        return checkbox;
    }

    public void setErrorMessage(String newMessage) {
        super.setErrorMessage(newMessage);
        this.setValid(newMessage == null);
    }

    protected ChromiumExceptionBreakpoint getBreakpoint() {
        return (ChromiumExceptionBreakpoint)this.getElement();
    }
}

