/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.internal.debug.ui.tabs.main;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.wst.xsl.internal.debug.ui.tabs.main.IParametersChangedListener;
import org.eclipse.wst.xsl.internal.debug.ui.tabs.main.ParametersContentProvider;
import org.eclipse.wst.xsl.launching.config.LaunchAttribute;

public class ParameterViewer {
    private final TableViewer viewer;
    private final ListenerList fListeners = new ListenerList();

    public ParameterViewer(Table table) {
        this.viewer = new TableViewer(table);
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    private ParametersContentProvider getParametersContentProvider() {
        return (ParametersContentProvider)this.viewer.getContentProvider();
    }

    public Shell getShell() {
        return this.viewer.getControl().getShell();
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean updateSelection(int actionType, IStructuredSelection selection) {
        switch (actionType) {
            case 1: {
                return true;
            }
        }
        return selection.size() > 0;
    }

    public IStructuredSelection getSelectedEntries() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        return selection;
    }

    public void addParameter(LaunchAttribute parameter) {
        this.getParametersContentProvider().addParameter(parameter);
        this.notifyChanged();
    }

    public void removeEntries(LaunchAttribute[] entries) {
        this.getParametersContentProvider().removeParameters(entries);
        this.notifyChanged();
    }

    public LaunchAttribute[] getParameters() {
        return this.getParametersContentProvider().getParameters();
    }

    public void addParametersChangedListener(IParametersChangedListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removeParametersChangedListener(IParametersChangedListener listener) {
        this.fListeners.remove((Object)listener);
    }

    private void notifyChanged() {
        Object[] listeners;
        Object[] objectArray = listeners = this.fListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            ((IParametersChangedListener)element).parametersChanged(this);
            ++n2;
        }
    }
}

