/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.apache.ode.deploy.model.dd.util;

import java.util.List;
import java.util.StringTokenizer;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMLHelperImpl;

public class DDXMLHelperImpl
extends XMLHelperImpl {
    protected boolean bIsNewQName = false;
    protected QName m_qName = null;

    public DDXMLHelperImpl() {
    }

    public DDXMLHelperImpl(XMLResource resource) {
        super(resource);
    }

    protected Object createFromString(EFactory eFactory, EDataType eDataType, String value) {
        Object obj = eFactory.createFromString(eDataType, value);
        if (this.extendedMetaData != null) {
            if (obj instanceof List) {
                List list = (List)obj;
                int i = 0;
                while (i < list.size()) {
                    Object item = list.get(i);
                    Object replacement = this.updateQNameURI(item);
                    if (replacement != item) {
                        list.set(i, replacement);
                    }
                    ++i;
                }
            } else {
                obj = this.updateQNameURI(obj);
            }
        }
        if (this.bIsNewQName) {
            this.bIsNewQName = false;
            return this.m_qName;
        }
        return obj;
    }

    protected String updateQNamePrefix(EFactory factory, EDataType dataType, Object value, boolean list) {
        if (value instanceof PortType) {
            QName qname = ((PortType)value).getQName();
            return this.handleQName(list, qname);
        }
        if (value instanceof QName) {
            return this.handleQName(list, (QName)value);
        }
        if (!list) {
            return factory.convertToString(dataType, value);
        }
        return null;
    }

    private String handleQName(boolean list, QName qname) {
        String namespace = qname.getNamespaceURI();
        if (namespace.length() == 0) {
            return qname.getLocalPart();
        }
        EPackage ePackage = this.extendedMetaData.getPackage(namespace);
        if (ePackage == null) {
            ePackage = this.extendedMetaData.demandPackage(namespace);
        }
        String prefix = this.getPrefix(ePackage, true);
        if (!this.packages.containsKey(ePackage)) {
            this.packages.put(ePackage, prefix);
        }
        if (!list) {
            String qNameString = new StringBuffer(prefix).append(":").append(qname.getLocalPart()).toString();
            return qNameString;
        }
        return null;
    }

    protected Object updateQNameURI(Object value) {
        int i = 1;
        String strPrefix = null;
        String strLocalName = null;
        String strNamespace = null;
        if (value instanceof QName) {
            String defaultXMLNamespace;
            StringTokenizer tokenizer;
            QName qname = (QName)value;
            strLocalName = qname.getLocalPart();
            strPrefix = qname.getPrefix();
            if (strPrefix == null && (tokenizer = new StringTokenizer(strLocalName, ":")).countTokens() > 1) {
                while (tokenizer.hasMoreTokens()) {
                    String tmp = tokenizer.nextToken();
                    if (i == 1) {
                        strPrefix = tmp;
                    } else {
                        strLocalName = tmp;
                    }
                    ++i;
                }
            }
            if (strPrefix == null && (defaultXMLNamespace = (String)this.prefixesToURIs.get((Object)"")) != null && !defaultXMLNamespace.equalsIgnoreCase("http://www.apache.org/ode/schemas/dd/2007/03")) {
                strNamespace = defaultXMLNamespace;
                strPrefix = "DEFAULT_NS";
            }
            if (strNamespace == null) {
                strNamespace = this.getURI(strPrefix);
            }
            this.m_qName = new QName(strNamespace, strLocalName);
            this.bIsNewQName = true;
            if (strPrefix.length() > 0 && this.m_qName.getNamespaceURI().length() == 0) {
                throw new IllegalArgumentException("The prefix '" + strPrefix + "' is not declared for the QName '" + qname.toString() + "'");
            }
            if (strNamespace == null) {
                this.seenEmptyStringMapping = true;
                String uri = (String)this.prefixesToURIs.get((Object)"");
                if (uri != null) {
                    this.prefixesToURIs.put((Object)"", (Object)strNamespace);
                    this.addNSDeclaration("", uri);
                }
            }
            return qname;
        }
        return value;
    }
}

