/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.adapters.delegates;

import java.util.Collections;
import java.util.List;
import org.eclipse.bpel.ui.adapters.delegates.AbstractContainer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ReferenceContainer
extends AbstractContainer {
    EReference fFeature;

    public ReferenceContainer(EReference aFeature) {
        this.fFeature = aFeature;
    }

    protected boolean isMany() {
        return this.fFeature.isMany();
    }

    protected List<EObject> getChildList(EObject object) {
        return (List)object.eGet((EStructuralFeature)this.fFeature);
    }

    public EObject getSingleChild(Object object) {
        return (EObject)((EObject)object).eGet((EStructuralFeature)this.fFeature);
    }

    public void setSingleChild(Object object, Object child) {
        ((EObject)object).eSet((EStructuralFeature)this.fFeature, child);
    }

    @Override
    protected final boolean isValidChild(EObject object, EObject child) {
        if (child == null) {
            return false;
        }
        return this.fFeature.getEReferenceType().isSuperTypeOf(child.eClass());
    }

    @Override
    public boolean addChild(EObject object, EObject child, EObject insertBefore) {
        if (!this.isValidChild(object, child)) {
            return false;
        }
        if (this.isMany()) {
            List<EObject> list = this.getChildList(object);
            if (insertBefore == null) {
                list.add(child);
            } else {
                int index = list.indexOf(insertBefore);
                if (index < 0) {
                    index = 0;
                }
                list.add(index, child);
            }
        } else {
            EObject value = this.getSingleChild(object);
            if (value != null) {
                return false;
            }
            this.setSingleChild(object, child);
        }
        return true;
    }

    @Override
    public List<EObject> getChildren(EObject object) {
        if (this.isMany()) {
            List<EObject> list = this.getChildList(object);
            if (list.isEmpty()) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(list);
        }
        EObject value = this.getSingleChild(object);
        if (value == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(value);
    }

    @Override
    public boolean removeChild(EObject object, EObject child) {
        if (!this.isValidChild(object, child)) {
            return false;
        }
        if (this.isMany()) {
            List<EObject> list = this.getChildList(object);
            return list.remove(child);
        }
        EObject value = this.getSingleChild(object);
        if (value != child) {
            return false;
        }
        this.setSingleChild(object, null);
        return true;
    }

    @Override
    public boolean replaceChild(EObject object, EObject oldChild, EObject newChild) {
        if (!this.isValidChild(object, oldChild)) {
            return false;
        }
        if (!this.isValidChild(object, newChild)) {
            return false;
        }
        if (this.isMany()) {
            List<EObject> list = this.getChildList(object);
            int index = list.indexOf(oldChild);
            if (index < 0) {
                return false;
            }
            list.set(index, newChild);
            return true;
        }
        EObject value = this.getSingleChild(object);
        if (value != oldChild) {
            return false;
        }
        this.setSingleChild(object, newChild);
        return true;
    }

    @Override
    public boolean canAddObject(EObject object, EObject child, EObject insertBefore) {
        if (!super.canAddObject(object, child, insertBefore)) {
            return false;
        }
        if (this.isMany()) {
            return true;
        }
        return this.getSingleChild(object) == null;
    }

    @Override
    public boolean canRemoveChild(EObject object, EObject child) {
        EObject value;
        if (!this.isValidChild(object, child)) {
            return false;
        }
        return this.isMany() || (value = this.getSingleChild(object)) == child;
    }
}

