/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.ui.properties;

import org.eclipse.cdt.internal.autotools.core.configure.IAConfiguration;
import org.eclipse.cdt.internal.autotools.core.configure.IConfigureOption;
import org.eclipse.cdt.internal.autotools.ui.properties.ToolListElement;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class AutotoolsConfigurePrefStore
implements IPreferenceStore {
    public static final String EMPTY_STRING = "";
    public static final String ALL_OPTIONS_ID = "";
    private static AutotoolsConfigurePrefStore instance = null;
    private ToolListElement selectedElement;
    private IAConfiguration cfg;
    private ListenerList<IPropertyChangeListener> listenerList = new ListenerList();
    private boolean isdirty;

    private AutotoolsConfigurePrefStore() {
    }

    public static AutotoolsConfigurePrefStore getInstance() {
        if (instance == null) {
            instance = new AutotoolsConfigurePrefStore();
        }
        return instance;
    }

    public void setSelection(IAConfiguration cfg, ToolListElement element) {
        this.cfg = cfg;
        this.selectedElement = element;
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.listenerList.add((Object)listener);
    }

    public boolean contains(String name) {
        return this.cfg.getOption(name) != null;
    }

    public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
        Object[] listeners = this.listenerList.getListeners();
        if (!(listeners.length <= 0 || oldValue != null && oldValue.equals(newValue))) {
            PropertyChangeEvent pe = new PropertyChangeEvent((Object)this, name, oldValue, newValue);
            int i = 0;
            while (i < listeners.length) {
                IPropertyChangeListener l = (IPropertyChangeListener)listeners[i];
                l.propertyChange(pe);
                ++i;
            }
        }
    }

    public boolean getBoolean(String name) {
        IConfigureOption option = this.cfg.getOption(name);
        if (option != null && (option.getType() == 1 || option.getType() == 7)) {
            return Boolean.parseBoolean(option.getValue());
        }
        return this.getDefaultBoolean(name);
    }

    public boolean getDefaultBoolean(String name) {
        return false;
    }

    public double getDefaultDouble(String name) {
        return 0.0;
    }

    public float getDefaultFloat(String name) {
        return 0.0f;
    }

    public int getDefaultInt(String name) {
        return 0;
    }

    public long getDefaultLong(String name) {
        return 0L;
    }

    public String getDefaultString(String name) {
        return "";
    }

    public double getDouble(String name) {
        return 0.0;
    }

    public float getFloat(String name) {
        return 0.0f;
    }

    public int getInt(String name) {
        return 0;
    }

    public long getLong(String name) {
        return 0L;
    }

    public String getString(String name) {
        if (name.equals("") && this.selectedElement.getType() == 5) {
            return this.cfg.getToolParameters(this.selectedElement.getName());
        }
        IConfigureOption option = this.cfg.getOption(name);
        if (option != null) {
            return option.getValue();
        }
        return this.getDefaultString(name);
    }

    public boolean isDefault(String name) {
        return false;
    }

    public boolean needsSaving() {
        return this.isdirty;
    }

    public void putValue(String name, String value) {
        this.setValue(name, value);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.listenerList.remove((Object)listener);
    }

    protected void setDirty(boolean isdirty) {
        this.isdirty = isdirty;
    }

    public void setDefault(String name, double value) {
    }

    public void setDefault(String name, float value) {
    }

    public void setDefault(String name, int value) {
    }

    public void setDefault(String name, long value) {
    }

    public void setDefault(String name, String defaultObject) {
    }

    public void setDefault(String name, boolean value) {
    }

    public void setToDefault(String name) {
    }

    public void setValue(String name, double value) {
    }

    public void setValue(String name, float value) {
    }

    public void setValue(String name, int value) {
    }

    public void setValue(String name, long value) {
    }

    public void setValue(String name, String value) {
        IConfigureOption option = this.cfg.getOption(name);
        if (option != null) {
            option.setValue(value);
        }
    }

    public void setValue(String name, boolean value) {
        IConfigureOption option = this.cfg.getOption(name);
        if (option != null) {
            option.setValue(Boolean.toString(value));
        }
    }
}

