/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.fx.utils;

import javafx.collections.ObservableList;
import javafx.scene.shape.Arc;
import javafx.scene.shape.Circle;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.Ellipse;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.QuadCurve;
import javafx.scene.shape.QuadCurveTo;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import org.eclipse.gef.geometry.euclidean.Angle;
import org.eclipse.gef.geometry.planar.CubicCurve;
import org.eclipse.gef.geometry.planar.IGeometry;
import org.eclipse.gef.geometry.planar.Line;
import org.eclipse.gef.geometry.planar.Path;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.geometry.planar.Polygon;
import org.eclipse.gef.geometry.planar.Polyline;
import org.eclipse.gef.geometry.planar.QuadraticCurve;
import org.eclipse.gef.geometry.planar.RoundedRectangle;

public class Shape2Geometry {
    public static org.eclipse.gef.geometry.planar.Arc toArc(Arc arc) {
        return new org.eclipse.gef.geometry.planar.Arc(arc.getCenterX() - arc.getRadiusX(), arc.getCenterY() - arc.getRadiusY(), arc.getRadiusX() + arc.getRadiusX(), arc.getRadiusY() + arc.getRadiusY(), Angle.fromDeg((double)arc.getStartAngle()), Angle.fromDeg((double)arc.getLength()));
    }

    public static CubicCurve toCubicCurve(javafx.scene.shape.CubicCurve cubic) {
        return new CubicCurve(cubic.getStartX(), cubic.getStartY(), cubic.getControlX1(), cubic.getControlY1(), cubic.getControlX2(), cubic.getControlY2(), cubic.getEndX(), cubic.getEndY());
    }

    public static org.eclipse.gef.geometry.planar.Ellipse toEllipse(Circle circle) {
        return new org.eclipse.gef.geometry.planar.Ellipse(circle.getCenterX() - circle.getRadius(), circle.getCenterY() - circle.getRadius(), circle.getRadius() + circle.getRadius(), circle.getRadius() + circle.getRadius());
    }

    public static org.eclipse.gef.geometry.planar.Ellipse toEllipse(Ellipse ellipse) {
        return new org.eclipse.gef.geometry.planar.Ellipse(ellipse.getCenterX() - ellipse.getRadiusX(), ellipse.getCenterY() - ellipse.getRadiusY(), ellipse.getRadiusX() + ellipse.getRadiusX(), ellipse.getRadiusY() + ellipse.getRadiusY());
    }

    public static IGeometry toGeometry(Shape visual) {
        if (visual instanceof Arc) {
            return Shape2Geometry.toArc((Arc)visual);
        }
        if (visual instanceof Circle) {
            return Shape2Geometry.toEllipse((Circle)visual);
        }
        if (visual instanceof javafx.scene.shape.CubicCurve) {
            return Shape2Geometry.toCubicCurve((javafx.scene.shape.CubicCurve)visual);
        }
        if (visual instanceof Ellipse) {
            return Shape2Geometry.toEllipse((Ellipse)visual);
        }
        if (visual instanceof javafx.scene.shape.Line) {
            return Shape2Geometry.toLine((javafx.scene.shape.Line)visual);
        }
        if (visual instanceof javafx.scene.shape.Path) {
            return Shape2Geometry.toPath((javafx.scene.shape.Path)visual);
        }
        if (visual instanceof javafx.scene.shape.Polygon) {
            return Shape2Geometry.toPolygon((javafx.scene.shape.Polygon)visual);
        }
        if (visual instanceof javafx.scene.shape.Polyline) {
            return Shape2Geometry.toPolyline((javafx.scene.shape.Polyline)visual);
        }
        if (visual instanceof QuadCurve) {
            QuadCurve quad = (QuadCurve)visual;
            return Shape2Geometry.toQuadraticCurve(quad);
        }
        if (visual instanceof Rectangle) {
            Rectangle rect = (Rectangle)visual;
            if (rect.getArcWidth() == 0.0 && rect.getArcHeight() == 0.0) {
                return Shape2Geometry.toRectangle(rect);
            }
            return Shape2Geometry.toRoundedRectangle((Rectangle)visual);
        }
        throw new IllegalStateException("Cannot compute geometric outline for Shape of type <" + visual.getClass() + ">.");
    }

    public static Line toLine(javafx.scene.shape.Line line) {
        return new Line(line.getStartX(), line.getStartY(), line.getEndX(), line.getEndY());
    }

    public static final Path toPath(javafx.scene.shape.Path path) {
        ObservableList elements = path.getElements();
        Path.Segment[] segments = new Path.Segment[elements.size()];
        int i = 0;
        while (i < segments.length) {
            PathElement element = (PathElement)elements.get(i);
            if (element instanceof MoveTo) {
                MoveTo moveTo = (MoveTo)element;
                segments[i] = new Path.Segment(0, new Point[]{new Point(moveTo.getX(), moveTo.getY())});
            } else if (element instanceof LineTo) {
                LineTo lineTo = (LineTo)element;
                segments[i] = new Path.Segment(1, new Point[]{new Point(lineTo.getX(), lineTo.getY())});
            } else if (element instanceof QuadCurveTo) {
                QuadCurveTo quadTo = (QuadCurveTo)element;
                segments[i] = new Path.Segment(2, new Point[]{new Point(quadTo.getControlX(), quadTo.getControlY()), new Point(quadTo.getX(), quadTo.getY())});
            } else if (element instanceof CubicCurveTo) {
                CubicCurveTo cubicTo = (CubicCurveTo)element;
                segments[i] = new Path.Segment(3, new Point[]{new Point(cubicTo.getControlX1(), cubicTo.getControlY1()), new Point(cubicTo.getControlX2(), cubicTo.getControlY2()), new Point(cubicTo.getX(), cubicTo.getY())});
            } else if (element instanceof ClosePath) {
                segments[i] = new Path.Segment(4, new Point[0]);
            }
            ++i;
        }
        int windingRule = path.getFillRule() == FillRule.EVEN_ODD ? 0 : 1;
        return new Path(windingRule, segments);
    }

    public static Polygon toPolygon(javafx.scene.shape.Polygon polygon) {
        double[] coords = new double[polygon.getPoints().size()];
        int i = 0;
        while (i < coords.length) {
            coords[i] = (Double)polygon.getPoints().get(i);
            ++i;
        }
        return new Polygon(coords);
    }

    public static Polyline toPolyline(javafx.scene.shape.Polyline polyline) {
        double[] coords = new double[polyline.getPoints().size()];
        int i = 0;
        while (i < coords.length) {
            coords[i] = (Double)polyline.getPoints().get(i);
            ++i;
        }
        return new Polyline(coords);
    }

    public static QuadraticCurve toQuadraticCurve(QuadCurve quad) {
        return new QuadraticCurve(quad.getStartX(), quad.getStartY(), quad.getControlX(), quad.getControlY(), quad.getEndX(), quad.getEndY());
    }

    public static org.eclipse.gef.geometry.planar.Rectangle toRectangle(Rectangle rect) {
        return new org.eclipse.gef.geometry.planar.Rectangle(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
    }

    public static RoundedRectangle toRoundedRectangle(Rectangle rect) {
        return new RoundedRectangle(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), rect.getArcWidth(), rect.getArcHeight());
    }
}

